/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.action;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.npay.common.bean.ServiceObject;
import ru.bitel.bgbilling.modules.npay.server.action.ActionServiceObjectChange;
import ru.bitel.bgbilling.modules.npay.server.bean.object.ServiceObjectManager;
import ru.bitel.bgbilling.modules.npay.server.event.ContractNpayChangedEvent;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;

public class ActionServiceObjectUpdate
extends ActionServiceObjectChange {
    @Override
    public void doAction() throws SQLException, BGException {
        ServiceObject serviceObject;
        Period period;
        int id = this.getIntParameter("id", 0);
        int sid = this.getIntParameter("sid", 0);
        int oid = this.getIntParameter("oid", -1);
        int col = this.getIntParameter("col", 1);
        int moduleId = this.getIntParameter("mid", -1);
        int entityMid = this.getIntParameter("entityMid", 0);
        int entityId = this.getIntParameter("entityId", 0);
        Date dateFrom = this.getDateParameter("date1");
        Date dateTo = this.getDateParameter("date2");
        String comment = this.getParameter("comment", "");
        TimeUtils.checkPeriod((Date)dateFrom, (Date)dateTo);
        if (oid < 0 || this.mid <= 0 || this.cid <= 0 || sid <= 0) {
            throw new BGIllegalArgumentException();
        }
        Service service = null;
        for (Service service2 : ModuleCache.getInstance().getModuleServicesList(moduleId)) {
            if (service2.getId() != sid) continue;
            service = service2;
            break;
        }
        if (!TimeUtils.dateInPeriod((Date)dateFrom, (Period)(period = service.getActivePeriod()))) {
            throw new BGMessageException(String.format("\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0443\u0441\u043b\u0443\u0433\u0438 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432\u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430\n[%s => %s]", TimeUtils.format((Date)dateFrom, (String)"dd.MM.yyyy"), period));
        }
        ServiceObjectManager serviceObjectManager = new ServiceObjectManager(this.con, this.mid);
        Date recalcFrom = dateFrom;
        int typeOperation = 1;
        if (id <= 0) {
            serviceObject = new ServiceObject();
            serviceObject.setId(id);
            recalcFrom = dateFrom;
        } else {
            serviceObject = serviceObjectManager.getServiceObject(id);
            typeOperation = 3;
            recalcFrom = dateFrom.before(serviceObject.getDate1()) ? dateFrom : serviceObject.getDate1();
        }
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionServiceObjectUpdate", (int)this.mid, (int)this.userId);
        if (closedDate != null) {
            Date olddate1 = null;
            Date olddate2 = null;
            if (id > 0) {
                olddate1 = serviceObject.getDate1();
                olddate2 = serviceObject.getDate2();
            }
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (Date)olddate1, (Date)olddate2, (Date)dateFrom, (Date)dateTo);
        }
        serviceObject.setContractId(this.cid);
        serviceObject.setServiceId(sid);
        serviceObject.setObjectId(oid);
        serviceObject.setCol(col);
        serviceObject.setEntityMid(entityMid);
        serviceObject.setEntityId(entityId);
        serviceObject.setDate1(dateFrom);
        serviceObject.setDate2(dateTo);
        serviceObject.setComment(comment);
        serviceObjectManager.updateServiceObject(serviceObject);
        int recalcOnServiceChange = this.moduleSetup.getInt("recalculate.on.service.change", 0);
        if (recalcOnServiceChange > 0 && recalcFrom != null) {
            this.recalculate(recalcFrom, recalcOnServiceChange, "\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438 \u0432 \u043e\u0431\u044c\u0435\u043a\u0442\u0435");
        }
        EventProcessor.getInstance().publishAfterCommit((Event)new ContractNpayChangedEvent(this.mid, this.cid, this.userId, typeOperation, serviceObject));
    }
}

