/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.bean.amount;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.modules.npay.server.bean.amount.ModuleAmount;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class InetModuleAmount
extends ModuleAmount {
    private static Logger log = LogManager.getLogger();

    @Override
    public long getDayAmount(Connection con, int contractId, Calendar day) {
        ResultSet rs;
        PreparedStatement ps;
        StringBuilder sb;
        long result = 0L;
        String sessionAccount = ServerUtils.getModuleMonthTableName((String)"inet_session_log_account", (Date)day.getTime(), (int)this.getModuleId());
        String sessionTable = ServerUtils.getModuleMonthTableName((String)"inet_session_log", (Date)day.getTime(), (int)this.getModuleId());
        if (ServerUtils.tableExists((Connection)con, (String)sessionAccount)) {
            sb = new StringBuilder(100);
            sb.append("SELECT SUM(amount) FROM ").append(sessionAccount).append(" AS session_account INNER JOIN ");
            sb.append(sessionTable).append(" AS session ON session_account.sessionId=session.id");
            sb.append(" WHERE session_account.contractId=? AND TO_DAYS(session.sessionStart)=TO_DAYS(?)");
            if (Utils.notBlankString((String)this.sids)) {
                sb.append(" AND session_account.serviceId IN (").append(this.sids).append(")");
            }
            try {
                ps = con.prepareStatement(sb.toString());
                try {
                    ps.setInt(1, contractId);
                    ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)day));
                    rs = ps.executeQuery();
                    try {
                        if (rs.next()) {
                            result = rs.getLong(1);
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
        }
        sb = new StringBuilder(100);
        sb.append("SELECT SUM(amount) FROM inet_session_account_").append(this.getModuleId()).append(" AS session_account INNER JOIN inet_session_");
        sb.append(this.getModuleId()).append(" AS session ON session_account.sessionId=session.id");
        sb.append(" WHERE session_account.contractId=? AND TO_DAYS(session.sessionStart)=TO_DAYS(?)");
        if (Utils.notBlankString((String)this.sids)) {
            sb.append(" AND session_account.serviceId IN (").append(this.sids).append(")");
        }
        try {
            ps = con.prepareStatement(sb.toString());
            try {
                ps.setInt(1, contractId);
                ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)day));
                rs = ps.executeQuery();
                try {
                    if (rs.next()) {
                        result += rs.getLong(1);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        return result;
    }

    @Override
    public long getPeriodAmount(Connection con, int contractId, Calendar from, Calendar to) {
        ResultSet rs;
        PreparedStatement ps;
        StringBuilder sb;
        long result = 0L;
        String sessionAccount = ServerUtils.getModuleMonthTableName((String)"inet_session_log_account", (Date)from.getTime(), (int)this.getModuleId());
        String sessionTable = ServerUtils.getModuleMonthTableName((String)"inet_session_log", (Date)from.getTime(), (int)this.getModuleId());
        if (ServerUtils.tableExists((Connection)con, (String)sessionAccount)) {
            sb = new StringBuilder(100);
            sb.append("SELECT SUM(session_account.amount) FROM ").append(sessionAccount).append(" AS session_account INNER JOIN ");
            sb.append(sessionTable).append(" AS session ON session_account.sessionId=session.id");
            sb.append(" WHERE session_account.contractId=? AND TO_DAYS(session.sessionStart)>=TO_DAYS(?)");
            sb.append(" AND TO_DAYS(session.sessionStart)<=TO_DAYS(?)");
            if (Utils.notBlankString((String)this.sids)) {
                sb.append(" AND session_account.serviceId IN (").append(this.sids).append(")");
            }
            try {
                ps = con.prepareStatement(sb.toString());
                try {
                    ps.setInt(1, contractId);
                    ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)from));
                    ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)to));
                    rs = ps.executeQuery();
                    try {
                        if (rs.next()) {
                            result = rs.getLong(1);
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
        }
        sb = new StringBuilder(100);
        sb.append("SELECT SUM(session_account.amount) FROM inet_session_account_").append(this.getModuleId()).append(" AS session_account INNER JOIN inet_session_");
        sb.append(this.getModuleId()).append(" AS session ON session_account.sessionId=session.id");
        sb.append(" WHERE session_account.contractId=? AND TO_DAYS(session.sessionStart)>=TO_DAYS(?)");
        sb.append(" AND TO_DAYS(session.sessionStart)<=TO_DAYS(?)");
        if (Utils.notBlankString((String)this.sids)) {
            sb.append(" AND session_account.serviceId IN (").append(this.sids).append(")");
        }
        try {
            ps = con.prepareStatement(sb.toString());
            try {
                ps.setInt(1, contractId);
                ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)from));
                ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)to));
                rs = ps.executeQuery();
                try {
                    if (rs.next()) {
                        result += rs.getLong(1);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        return result;
    }
}

