/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.bean.object;

import bitel.billing.server.contract.bean.ContractUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractNote;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractNoteDao;
import ru.bitel.bgbilling.modules.npay.common.bean.ServiceObject;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class ServiceObjectManager {
    private Connection con;
    private int moduleId;
    private String tableName;

    public ServiceObjectManager(Connection con, int moduleId) {
        this.con = con;
        this.moduleId = moduleId;
        this.tableName = "npay_service_object_" + moduleId;
    }

    public ServiceObject getServiceObject(int id) {
        ServiceObject result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " AS service_object WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getServiceObjectFromRs(rs, false, false);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateServiceObject(ServiceObject value) {
        String query = null;
        PreparedStatement ps = null;
        try {
            if (value.getId() <= 0) {
                query = "INSERT INTO " + this.tableName + " (col, oid, date1, date2, comment, cid, emid, eid, sid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
                ps.setInt(9, value.getServiceId());
            } else {
                query = "UPDATE " + this.tableName + " SET col=?, oid=?, date1=?, date2=?, comment=?, cid=?, emid=?, eid=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(9, value.getId());
            }
            ps.setInt(1, value.getCol());
            ps.setInt(2, value.getObjectId());
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)value.getDate1()));
            ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)value.getDate2()));
            ps.setString(5, value.getComment());
            ps.setInt(6, value.getContractId());
            ps.setInt(7, value.getEntityMid());
            ps.setInt(8, value.getEntityId());
            ps.executeUpdate();
            if (value.getId() <= 0) {
                value.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteServiceObject(int id) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<ServiceObject> getServiceObjectListForObject(int oid) {
        ArrayList<ServiceObject> result = new ArrayList<ServiceObject>();
        try {
            String query = "SELECT service_object.*, service.title FROM " + this.tableName + " AS service_object LEFT JOIN service ON service_object.sid=service.id WHERE service_object.oid=? AND service_object.emid=0 AND service_object.eid=0 ORDER BY service_object.date1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, oid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getServiceObjectFromRs(rs, true, false));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ServiceObject> getServiceObjectList(int cid, Date date) {
        return this.getServiceObjectList(cid, 0, 0, 0, date);
    }

    public List<ServiceObject> getServiceObjectList(int cid, int objectId, int entityMid, int entityId) {
        return this.getServiceObjectList(cid, objectId, entityMid, entityId, null);
    }

    public List<ServiceObject> getServiceObjectList(int cid, int objectId, int entityMid, int entityId, Date date) {
        ArrayList<ServiceObject> result = new ArrayList<ServiceObject>();
        try {
            String query = "SELECT service_object.*, service.title, object.title FROM " + this.tableName + " AS service_object LEFT JOIN service ON service_object.sid=service.id LEFT JOIN object ON service_object.oid=object.id WHERE service_object.cid=? ";
            if (entityMid >= 0) {
                query = query + " AND service_object.emid=" + entityMid;
            }
            if (entityId >= 0) {
                query = query + " AND service_object.eid=" + entityId;
            }
            if (objectId > 0) {
                query = query + " AND service_object.oid=" + objectId;
            }
            if (date != null) {
                query = query + " AND (service_object.date1 IS NULL OR service_object.date1 <= ?)  AND (service_object.date2 IS NULL OR service_object.date2 >= ?) ";
            }
            query = query + " ORDER BY service_object.date1";
            int index = 1;
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(index++, cid);
            if (date != null) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date));
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ServiceObject serviceObject = this.getServiceObjectFromRs(rs, true, true);
                result.add(serviceObject);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private ServiceObject getServiceObjectFromRs(ResultSet rs, boolean serviceTitle, boolean objectTitle) throws SQLException {
        ServiceObject serviceObject = new ServiceObject();
        serviceObject.setId(rs.getInt("service_object.id"));
        serviceObject.setContractId(rs.getInt("service_object.cid"));
        serviceObject.setServiceId(rs.getInt("service_object.sid"));
        serviceObject.setCol(rs.getInt("service_object.col"));
        serviceObject.setDate1((Date)rs.getDate("service_object.date1"));
        serviceObject.setDate2((Date)rs.getDate("service_object.date2"));
        serviceObject.setEntityMid(rs.getInt("service_object.emid"));
        serviceObject.setEntityId(rs.getInt("service_object.eid"));
        serviceObject.setObjectId(rs.getInt("service_object.oid"));
        serviceObject.setComment(rs.getString("service_object.comment"));
        if (serviceTitle) {
            serviceObject.setServiceTitle(rs.getString("service.title"));
        }
        if (objectTitle) {
            serviceObject.setObjectTitle(rs.getString("object.title"));
        }
        return serviceObject;
    }

    public void moveContractSevice(ServiceObject contractService, int cidFrom, int cidTo, int objectTo, int userId) throws Exception {
        if (contractService.getDate1() == null) {
            throw new BGException("\u041d\u0435\u0442 \u0434\u0430\u0442\u044b \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0443\u0441\u043b\u0443\u0433\u0438 \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435.");
        }
        ServiceObjectManager csm = new ServiceObjectManager(this.con, this.moduleId);
        contractService.setContractId(cidTo);
        contractService.setObjectId(objectTo);
        csm.updateServiceObject(contractService);
        ContractUtils cu = new ContractUtils(this.con);
        ContractNote contractNote = new ContractNote();
        contractNote.setUserId(userId);
        contractNote.setContractId(cidFrom);
        contractNote.setDateTime(LocalDateTime.now());
        contractNote.setTitle("\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d\u0430 \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u0430");
        contractNote.setComment("\u0410\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u0430 " + contractService.getServiceTitle() + " \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d\u0430 \u0438\u0437 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + cu.getContractTitle(cidFrom, true) + " \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + cu.getContractTitle(cidTo, true));
        try (ContractNoteDao contractNoteDao = new ContractNoteDao(this.con);){
            contractNoteDao.update((Object)contractNote);
            contractNote.setId(0);
            contractNote.setContractId(cidTo);
            contractNoteDao.update((Object)contractNote);
        }
    }

    public void wrapContractSevice(ServiceObject contractService, int cidTo, int objectTo, int entityToId, int userId, Date dateClose, Date dateOpen) throws Exception {
        if (contractService.getDate2() != null && TimeUtils.dateBeforeOrEq((Date)contractService.getDate2(), (Date)dateClose)) {
            return;
        }
        if (TimeUtils.dateBefore((Date)dateOpen, (Date)contractService.getDate1())) {
            this.moveContractSevice(contractService, contractService.getContractId(), cidTo, objectTo, userId);
            return;
        }
        if (contractService.getDate1() == null) {
            throw new BGException("\u041d\u0435\u0442 \u0434\u0430\u0442\u044b \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0443\u0441\u043b\u0443\u0433\u0438 " + contractService.getServiceTitle() + " \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435.");
        }
        ServiceObjectManager csm = new ServiceObjectManager(this.con, this.moduleId);
        Date oldDate2 = contractService.getDate2();
        contractService.setDate2(dateClose);
        csm.updateServiceObject(contractService);
        if (oldDate2 == null || !TimeUtils.dateBeforeOrEq((Date)oldDate2, (Date)dateOpen)) {
            ServiceObject newService = new ServiceObject();
            newService = contractService.clone();
            newService.setContractId(cidTo);
            newService.setObjectId(objectTo);
            newService.setId(0);
            newService.setDate1(dateOpen);
            newService.setDate2(oldDate2);
            newService.setEntityId(entityToId);
            csm.updateServiceObject(newService);
        }
        ContractUtils cu = new ContractUtils(this.con);
        String contractFrom = cu.getContractTitle(contractService.getContractId(), true);
        String contractTo = cu.getContractTitle(cidTo, true);
        ContractNote contractNote = new ContractNote();
        contractNote.setUserId(userId);
        contractNote.setContractId(contractService.getContractId());
        contractNote.setDateTime(LocalDateTime.now());
        contractNote.setTitle("\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d\u0430 \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u0430 \u0441 \u0434\u0430\u0442\u044b");
        contractNote.setComment("\u0410\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u0430 " + contractService.getServiceTitle() + " \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d\u0430 \u0438\u0437 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + contractFrom + " \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + contractTo + " \u0441 \u0434\u0430\u0442\u044b " + TimeUtils.formatDate((Date)dateOpen));
        try (ContractNoteDao contractNoteDao = new ContractNoteDao(this.con);){
            contractNoteDao.update((Object)contractNote);
            contractNote.setId(0);
            contractNote.setContractId(cidTo);
            contractNoteDao.update((Object)contractNote);
        }
    }
}

