/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.tariff;

import java.math.BigDecimal;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.modules.npay.server.bean.account.ModuleAccount;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayServiceCost;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayTariffContext;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayTariffRequest;
import ru.bitel.common.ParameterMap;

public class MonthAddModeCostTariffTreeNode
extends DefaultTariffTreeNode<NPayTariffRequest, NPayTariffContext> {
    private final int account;
    private final BigDecimal cost;
    private final int type;

    public MonthAddModeCostTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.account = parameterMap.getInt("account", 0);
        this.cost = parameterMap.getBigDecimal("cost", BigDecimal.ZERO);
        this.type = parameterMap.getInt("type", 0);
    }

    protected int executeImpl(Long treeNodeId, NPayTariffRequest req, NPayTariffContext ctx) {
        ModuleAccount moduleAccount = ctx.getModuleAccount(this.account);
        if (moduleAccount == null) {
            req.addError("Not found account " + this.account);
            return 0;
        }
        BigDecimal accountValue = ctx.getModuleAccount(this.account).getPeriodAccount(req.getConnection(), req.contractId, ((NPayServiceCost)req.serviceCost).date1, ((NPayServiceCost)req.serviceCost).date2);
        int monthDays = req.getAccountingMonthDays();
        int periodDays = ((NPayServiceCost)req.serviceCost).accountingPeriodDays;
        BigDecimal cost = this.cost;
        if (this.type == 1) {
            cost = this.cost.multiply(BigDecimal.valueOf(periodDays), ctx.mc).divide(BigDecimal.valueOf(monthDays), ctx.mc);
        }
        ((NPayServiceCost)req.serviceCost).addCost = cost;
        ((NPayServiceCost)req.serviceCost).cost = accountValue.compareTo(cost) < 0 ? cost.subtract(accountValue) : BigDecimal.ZERO;
        return 1;
    }
}

