/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.paykeeper.client;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import ru.bitel.bgbilling.client.common.AbstractTransactionPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.BGAbstractTransaction;
import ru.bitel.bgbilling.modules.paykeeper.client.TransactionTableModel;
import ru.bitel.bgbilling.modules.paykeeper.common.bean.Transaction;
import ru.bitel.bgbilling.modules.paykeeper.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.paykeeper.common.service.PaykeeperService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.SearchResult;

public class TransactionPanel
extends AbstractTransactionPanel {
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            String contractTitle = TransactionPanel.this.contractTitleField.getText();
            AbstractTransactionStatus status = (AbstractTransactionStatus)TransactionPanel.this.statusComboBox.getSelectedItem();
            SearchResult searchResult = ((PaykeeperService)((ClientContext)TransactionPanel.this.getContext()).getPort(PaykeeperService.class)).searchTransactionList(TransactionPanel.this.getContractId(), contractTitle, status.getCode(), TransactionPanel.this.periodPanel.getPeriod(), TransactionPanel.this.getTable().getSort(), TransactionPanel.this.pagePanel.getPage());
            ((TransactionTableModel)TransactionPanel.this.transactionModel).setData(searchResult.getList());
            TransactionPanel.this.pagePanel.setPage(searchResult.getPage());
            TransactionPanel.this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
            TransactionPanel.this.summaField.setText(new DecimalFormat("###,###,##0.00").format(searchResult.getSum()));
        }
    };

    public TransactionPanel() {
        this.statusComboBox.setModel(new DefaultComboBoxModel<TransactionStatus>(TransactionStatus.values()));
    }

    protected JMenuItem getReverseMenuItem() {
        return new JMenuItem("\u041e\u0442\u043c\u0435\u043d\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438"){
            {
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        Object selectedPayment = TransactionPanel.this.transactionModel.getSelectedRow();
                        if (selectedPayment != null && selectedPayment instanceof Transaction) {
                            Transaction transaction = (Transaction)selectedPayment;
                            if (transaction.getStatus().equals(TransactionStatus.APPROVED.getCode())) {
                                if (TransactionPanel.this.checkDate(transaction.getTransactionDate())) {
                                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0424\u0443\u043d\u043a\u0446\u0438\u044f \u0432 \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u043a\u0435...", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
                                } else {
                                    ClientUtils.showErrorMessageDialog((String)"\u041e\u0442\u043c\u0435\u043d\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0432 \u0434\u0435\u043d\u044c \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438");
                                }
                            } else {
                                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0442\u043c\u0435\u043d\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0439 \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c \"\u041e\u0434\u043e\u0431\u0440\u0435\u043d\u043d\u0430\u044f\"", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0);
                            }
                        }
                    }
                });
            }
        };
    }

    private boolean checkDate(Date date) {
        GregorianCalendar now = new GregorianCalendar();
        GregorianCalendar transactionDate = new GregorianCalendar();
        transactionDate.setTime(date);
        boolean result = now.get(1) == transactionDate.get(1);
        result &= now.get(2) == transactionDate.get(2);
        return result &= now.get(5) == transactionDate.get(5);
    }

    protected JMenuItem getRefundMenuItem() {
        return new JMenuItem("\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438"){
            {
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        Object selectedPayment = TransactionPanel.this.transactionModel.getSelectedRow();
                        if (selectedPayment != null && selectedPayment instanceof BGAbstractTransaction) {
                            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0424\u0443\u043d\u043a\u0446\u0438\u044f \u0432 \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u043a\u0435...", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
                        }
                    }
                });
            }
        };
    }
}

