/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.paymaster.server;

import bitel.billing.server.ModuleBase;
import java.sql.Connection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.AbstractAutopaymentManager;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.paymaster.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.paymaster.server.worker.PaymasterAutopaymentEventWorker;

public class Module
extends ModuleBase {
    private static final Logger log = LogManager.getLogger();

    public String[] getServerPackages() {
        return new String[]{"ru.bitel.bgbilling.modules.paymaster.server"};
    }

    public void start(Connection con, BGModule module) throws BGException {
        new PaymasterAutopaymentEventWorker(module.getId());
    }

    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
        block11: {
            super.moduleAction(serverContext, moduleId, event);
            int contractId = event.getContractId();
            try {
                Connection con = serverContext.getConnection();
                if (event instanceof ContractCreateEvent) {
                    ContractCreateEvent contractCreateEvent = (ContractCreateEvent)event;
                    if (!contractCreateEvent.isCheck()) {
                        this.enableAutopayment(contractCreateEvent.getPattern().getData(), "paymaster", moduleId, contractId, con, serverContext.getUserId());
                    }
                    break block11;
                }
                if (event instanceof ContractDeleteEvent) {
                    ContractDeleteEvent contractDeleteEvent = (ContractDeleteEvent)event;
                    if (!contractDeleteEvent.isCheck()) {
                        this.removeAutopayment(moduleId, contractId, con);
                    }
                    break block11;
                }
                if (!(event instanceof ContractCloseEvent)) break block11;
                try (AutopaymentManager autopaymentManager = new AutopaymentManager(con, moduleId);){
                    AutopaymentManager.unregisterAutopayment((Connection)con, (int)moduleId, (AbstractAutopaymentManager)autopaymentManager, (int)contractId);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

