/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.phone.common.bean.PhoneItemListMode;
import ru.bitel.bgbilling.modules.phone.common.bean.PhoneItemListNumber;
import ru.bitel.bgbilling.modules.phone.common.service.BlacklistService;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItem;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItemManager;
import ru.bitel.bgbilling.modules.phone.server.bean.PhoneItemListManager;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.phone.common.service.BlacklistService")
public class BlacklistServiceImpl
extends AbstractService
implements BlacklistService {
    public void updateMode(PhoneItemListMode mode) throws BGException {
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"WSBlacklist.updateMode", (int)this.moduleId, (int)this.userId);
        if (closedDate != null) {
            ClientItemManager cim = new ClientItemManager(this.getConnection(), this.moduleId);
            ClientItem ci = cim.getItem(mode.getPhoneItemId());
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (Calendar)ci.getDate1(), (Calendar)ci.getDate2(), null, null);
        }
        PhoneItemListManager pilm = new PhoneItemListManager(this.moduleId, this.getConnection());
        pilm.clearNumbers(mode.getPhoneItemId());
        pilm.updateMode(mode);
    }

    public void updateNumbers(int itemId, List<PhoneItemListNumber> numbers) throws BGException {
        int maxAmount;
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"WSBlacklist.updateNumbers", (int)this.moduleId, (int)this.userId);
        if (closedDate != null) {
            ClientItemManager cim = new ClientItemManager(this.getConnection(), this.moduleId);
            ClientItem ci = cim.getItem(itemId);
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (Calendar)ci.getDate1(), (Calendar)ci.getDate2(), null, null);
        }
        if ((maxAmount = this.getModuleSetup().getInt("max.list.numbers.amount", 0)) > 0 && numbers.size() > maxAmount) {
            throw new BGMessageException("\u0412\u044b \u0432\u0432\u0435\u043b\u0438 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e \u043d\u043e\u043c\u0435\u0440\u043e\u0432! \u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043d\u043e\u043c\u0435\u0440\u043e\u0432 - " + maxAmount);
        }
        PhoneItemListManager manager = new PhoneItemListManager(this.moduleId, this.getConnection());
        List<PhoneItemListNumber> actualNumbers = manager.getActualNumbersForItem(itemId);
        ArrayList<PhoneItemListNumber> toUpdate = new ArrayList<PhoneItemListNumber>();
        for (PhoneItemListNumber num : numbers) {
            if (actualNumbers.contains(num)) continue;
            num.setNewNumber(true);
            toUpdate.add(num);
        }
        for (PhoneItemListNumber num : actualNumbers) {
            if (numbers.contains(num)) continue;
            num.setToDeleteNumber(true);
            toUpdate.add(num);
        }
        for (PhoneItemListNumber num : toUpdate) {
            manager.updateNumber(num);
        }
    }

    public List<PhoneItemListNumber> getNumbersForItem(int phoneItemId) throws BGException {
        return new PhoneItemListManager(this.moduleId, this.getConnection()).getActualNumbersForItem(phoneItemId);
    }

    public PhoneItemListMode getMode(int phoneItemId) throws BGException {
        PhoneItemListMode mode = new PhoneItemListManager(this.moduleId, this.getConnection()).getMode(phoneItemId);
        if (mode == null) {
            mode = new PhoneItemListMode();
            mode.setMode(PhoneItemListMode.Mode.DISABLED);
            mode.setNewMode(false);
            mode.setPhoneItemId(phoneItemId);
        }
        return mode;
    }
}

