/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.qiwi.server.ishop;

import java.security.MessageDigest;
import java.sql.Connection;
import java.util.Date;
import javax.jws.WebMethod;
import javax.jws.WebService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.qiwi.common.bean.Transaction;
import ru.bitel.bgbilling.modules.qiwi.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.qiwi.common.ru.mw.ishop.client.ArrayOfParams;
import ru.bitel.bgbilling.modules.qiwi.common.ru.mw.ishop.client.IShopClientWS;
import ru.bitel.bgbilling.modules.qiwi.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.qiwi.common.ru.mw.ishop.client.IShopClientWS")
public class IShopClientWSImpl
extends AbstractService
implements IShopClientWS {
    private static Logger log = LogManager.getLogger();

    public int updateBill(String login, String password, String txn, String status) {
        int resultCode;
        block15: {
            log.info("Connected with Qiwi");
            resultCode = 0;
            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
            Connection con = this.getConnection();
            try {
                log.info("Checking sign");
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(moduleSetup.get("qiwi.password", "").getBytes());
                Object sign = Utils.bytesToHexString((byte[])md.digest()).toUpperCase();
                md.reset();
                sign = txn + (String)sign;
                md.update(((String)sign).getBytes());
                sign = Utils.bytesToHexString((byte[])md.digest()).toUpperCase();
                if (((String)sign).equals(password)) {
                    log.info("Signs equals!");
                    try (TransactionManager manager = new TransactionManager(con, this.moduleId);){
                        Transaction transaction = manager.getTransaction(Utils.parseInt((String)txn));
                        if (status.equals(TransactionStatus.PAIDED.getCode()) && !transaction.getStatus().equals(TransactionStatus.PAIDED.getCode())) {
                            boolean autoCommit = con.getAutoCommit();
                            con.setAutoCommit(false);
                            log.info("Process payment...");
                            transaction.setStatus(TransactionStatus.PAIDED.getCode());
                            transaction.setPaymentDate(new Date());
                            Payment payment = new Payment();
                            payment.setContractId(transaction.getContractId());
                            payment.setSum(transaction.getSum());
                            payment.setDate(transaction.getPaymentDate());
                            payment.setTypeId(moduleSetup.getInt("qiwi.payment.type.id", -1));
                            payment.setComment(moduleSetup.get("qiwi.payment.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0439 \u0441\u0435\u0440\u0432\u0438\u0441 QIWI [\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f #{TRANSACTION_ID}]").replace("{TRANSACTION_ID}", transaction.getTransactionId()));
                            try (PaymentDao paymentDao = new PaymentDao(con);){
                                paymentDao.update((Object)payment);
                            }
                            manager.update(transaction);
                            this.getConnection().commit();
                            log.info("Update balance");
                            BalanceUtils balanceUtils = new BalanceUtils(con);
                            balanceUtils.updateBalance(new Date(), transaction.getContractId());
                            balanceUtils.close();
                            this.getConnection().commit();
                            this.getConnection().setAutoCommit(autoCommit);
                            EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                            EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
                            resultCode = 0;
                            break block15;
                        }
                        log.info("Transaction not paided!");
                        transaction.setStatus(status);
                        manager.update(transaction);
                        resultCode = 1;
                        break block15;
                    }
                }
                log.info("Sign are not equal!!!");
                resultCode = 1;
            }
            catch (Exception e) {
                log.error(e.getMessage());
                resultCode = 1;
            }
        }
        return resultCode;
    }

    @WebMethod
    public int updateBillExt(String login, String password, String txn, int status, ArrayOfParams params) {
        return 0;
    }
}

