/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.action;

import bitel.billing.server.ActionBase;
import bitel.billing.server.ActionConType;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.reports.server.bean.BGReportUtils;
import ru.bitel.bgbilling.modules.reports.server.report.BGReport;

@ActionConType(value=2)
public class ActionReport
extends ActionBase {
    public void doAction() throws SQLException, BGException, IOException {
        String id = this.getParameter("report_id");
        BGReport report = null;
        try {
            log.debug("Generate report with id=" + id);
            report = BGReportUtils.getReport(id, this.con, this.conSlave, this.moduleSetup, this.userId, log);
            BGReportUtils.addRequestParams(report, this.request);
        }
        catch (Exception ex) {
            log.error("error get report id=" + id, (Throwable)ex);
            return;
        }
        if (report != null) {
            HttpServletResponse response = this.getResponse();
            try {
                response.setContentType(report.getContentType());
                ServletOutputStream out = response.getOutputStream();
                report.fillReportToStream((OutputStream)out);
                out.flush();
                out.close();
            }
            catch (BGMessageException ex) {
                response.setContentType("error");
                ServletOutputStream out = response.getOutputStream();
                PrintWriter ps = new PrintWriter((OutputStream)out);
                ps.append("\u041e\u0448\u0438\u0431\u043a\u0430! ").append(ex.getMessage());
                ps.close();
                out.flush();
                out.close();
            }
            catch (Exception ex) {
                response.setContentType("error");
                ServletOutputStream out = response.getOutputStream();
                PrintStream ps = new PrintStream((OutputStream)out);
                ex.printStackTrace(ps);
                out.flush();
                out.close();
                log.error("error fill report id=" + id + " to stream", (Throwable)ex);
            }
        }
    }
}

