/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.modules.voiceip;

import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRDataSource;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGDataSource;
import ru.bitel.bgbilling.modules.reports.server.report.BGJasperReport;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Report_Session
extends BGJasperReport {
    public Report_Session() {
        this.id = "voiceip_session";
    }

    @Override
    public void fillReportToStream(OutputStream out) {
        String dc = this.getStringParam("dc");
        int mid = Utils.parseInt((String)this.getStringParam("mid"), (int)-1);
        int mode = Utils.parseInt((String)this.getStringParam("mode"), (int)1);
        Date date1 = TimeUtils.parseDate((String)this.getStringParam("date1"), (String)"dd.MM.yyyy");
        Date date2 = TimeUtils.parseDate((String)this.getStringParam("date2"), (String)"dd.MM.yyyy");
        if (mid > 0 && date1 != null && date2 != null) {
            try {
                BGDataSource bds = new BGDataSource();
                String sessionTableName = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)date1, (int)mid);
                String serverLogTableName = ServerUtils.getModuleMonthTableName((String)"log_server", (Date)date1, (int)mid);
                StringBuffer buf = new StringBuffer();
                buf.append("SELECT t4.title, t1.session_start, t1.session_time, ");
                buf.append("t1.session_cost, CONCAT( t1.from_number, '/', t1.to_number ), ");
                buf.append("t1.dc, t2.requests ");
                buf.append(" FROM ");
                buf.append(sessionTableName);
                buf.append(" AS t1, ");
                buf.append(serverLogTableName);
                buf.append(" AS t2, ");
                buf.append("user_login_");
                buf.append(mid);
                buf.append(" AS t3, ");
                buf.append(" contract AS t4 ");
                buf.append(" WHERE t1.lr=t2.id AND t1.lid=t3.id AND t3.cid=t4.id AND ");
                buf.append(" t1.session_start>=? AND t1.session_start<DATE_ADD( ?, INTERVAL 1 DAY ) ");
                if (dc != null && dc.length() != 0) {
                    buf.append(" AND t1.dc ");
                    if (mode == 2) {
                        buf.append(" NOT ");
                    }
                    buf.append(" IN ( ");
                    buf.append(dc);
                    buf.append(" ) ");
                }
                buf.append(" ORDER BY t1.session_start");
                PreparedStatement ps = this.con.prepareStatement(buf.toString());
                ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)date1));
                ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date2));
                ResultSet rs = ps.executeQuery();
                HashMap<String, String> params = new HashMap<String, String>();
                while (rs.next()) {
                    HashMap<String, Object> row = new HashMap<String, Object>(10);
                    row.put("col1", rs.getString(1));
                    row.put("col2", TimeUtils.format((Calendar)TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp(2)), (String)"dd.MM.yyyy HH:mm:ss"));
                    row.put("col3", rs.getString(3));
                    row.put("col4", rs.getString(4));
                    row.put("col5", rs.getString(5));
                    row.put("col6", rs.getString(6));
                    String requests = rs.getString(7);
                    this.addAttr(row, requests, "NAS-IP-Address", 7);
                    this.addAttr(row, requests, "h323-remote-address", 8);
                    this.addAttr(row, requests, "h323-connect-time", 9);
                    this.addAttr(row, requests, "h323-disconnect-time", 10);
                    bds.addRow(row);
                }
                rs.close();
                ps.close();
                params.put("count", String.valueOf(bds.rows()));
                this.fillReportToStream("voiceip_session", out, params, (JRDataSource)bds);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void addAttr(Map<String, Object> row, String requests, String attrName, int column) {
        Pattern pattern = Pattern.compile(attrName + "=(.+)");
        Matcher m = pattern.matcher(requests);
        if (m.find()) {
            row.put("col" + column, m.group(1));
        } else {
            row.put("col" + column, " - ");
        }
    }
}

