/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.robokassa.server.bean;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.modules.robokassa.common.bean.Transaction;
import ru.bitel.bgbilling.modules.robokassa.common.bean.TransactionStatus;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    private static final Logger logger = LogManager.getLogger();

    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, "robokassa_transaction");
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("createDate", "create_date");
        this.fields.put("transactionDate", "transaction_date");
        this.fields.put("sum", "sum");
    }

    public void searchTransaction(SearchResult<Transaction> searchResult, int contractId, String contractTitle, String status) throws BGException {
        super.searchTransaction(searchResult, contractId, contractTitle, status, null);
    }

    public void doCheckRequest(int transactionId) throws BGException {
        Transaction transaction = (Transaction)this.get(transactionId);
        if (transaction == null) {
            throw new BGException("\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430: #ID " + transactionId);
        }
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        String merchantLogin = moduleSetup.get("robokassa.merchant.login", "");
        String signData = new StringBuffer().append(merchantLogin).append(":").append(transactionId).append(":").append(moduleSetup.get("robokassa.merchant.password.2", "")).toString();
        String signature = "";
        try {
            signature = Utils.getDigest((String)signData, (String)"UTF-8");
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        StringBuilder spec = new StringBuilder().append(moduleSetup.get("robokassa.xml.url", "https://auth.robokassa.ru/Merchant/WebService/Service.asmx")).append(moduleSetup.get("robokassa.xml.method.state", "OpState")).append("?").append("MerchantLogin").append("=").append(merchantLogin).append("&").append("InvoiceID").append("=").append(transactionId).append("&").append("Signature").append("=").append(signature);
        StringBuilder resultXml = new StringBuilder();
        try {
            URL orderStatusUrl = new URL(spec.toString());
            HttpURLConnection connection = (HttpURLConnection)orderStatusUrl.openConnection();
            connection.setReadTimeout(moduleSetup.getInt("robokassa.request.read.timeout", 5000));
            connection.setConnectTimeout(moduleSetup.getInt("robokassa.request.timeout", 10000));
            connection.setRequestMethod("GET");
            connection.setDoOutput(false);
            connection.setDoInput(true);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                if (br.ready()) {
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        resultXml.append(line);
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u041e\u0442\u0432\u0435\u0442: " + resultXml.toString());
            }
        }
        catch (Exception ex) {
            logger.error("\u0421\u0431\u043e\u0439 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0437\u0430\u043f\u0440\u043e\u0441\u0430: " + spec.toString());
            logger.error(ex.getMessage());
        }
        Document doc = XMLUtils.parseDocument((InputSource)new InputSource(new StringReader(resultXml.toString())));
        String resultCode = XMLUtils.selectText((Node)doc, (String)"/OperationStateResponse/Result/Code/text()");
        String resultDescription = XMLUtils.selectText((Node)doc, (String)"/OperationStateResponse/Result/Description/text()");
        StringBuilder params = new StringBuilder().append("ResultCode").append("=").append(resultCode).append("\n").append("ResultDescription").append("=").append(resultDescription);
        if ("0".equals(resultCode)) {
            String stateCode = XMLUtils.selectText((Node)doc, (String)"/OperationStateResponse/State/RequestDate/text()");
            String infoOutSum = "";
            if ("100".equals(stateCode)) {
                infoOutSum = XMLUtils.selectText((Node)doc, (String)"/OperationStateResponse/Info/OutSum/text()", (String)"");
                transaction.setStatus(TransactionStatus.OK.getCode());
                if (transaction.getPaymentId() < 1) {
                    Payment payment = new Payment();
                    payment.setContractId(transaction.getContractId());
                    payment.setSum(new BigDecimal(infoOutSum));
                    Date paymentDate = transaction.getTransactionDate();
                    if (paymentDate == null) {
                        paymentDate = new Date();
                        transaction.setTransactionDate(paymentDate);
                    }
                    payment.setDate(paymentDate);
                    payment.setTypeId(moduleSetup.getInt("robokassa.payment.type.id", 0));
                    payment.setComment(moduleSetup.get("robokassa.payment.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0439 \u0448\u043b\u044e\u0437 \u0420\u0424\u0418 \u0411\u0430\u043d\u043a\u0430 [\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f #{TRANSACTION_ID}]").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId())));
                    try (PaymentDao paymentDao = new PaymentDao(this.con);){
                        paymentDao.update((Object)payment);
                    }
                    transaction.setPaymentId(payment.getId());
                }
            }
            params.append("\n").append("StateCode").append("=").append(stateCode).append("\n").append("StateRequestDate").append("=").append(XMLUtils.selectText((Node)doc, (String)"/OperationStateResponse/State/RequestDate/text()", (String)"")).append("\n").append("StateStateDate").append("=").append(XMLUtils.selectText((Node)doc, (String)"/OperationStateResponse/State/StateDate/text()", (String)"")).append("\n").append("InfoIncCurrLabel").append("=").append(XMLUtils.selectText((Node)doc, (String)"/OperationStateResponse/Info/IncCurrLabel/text()", (String)"")).append("\n").append("InfoIncSum").append("=").append(XMLUtils.selectText((Node)doc, (String)"/OperationStateResponse/Info/IncSum/text()", (String)"")).append("\n").append("InfoIncAccount").append("=").append(XMLUtils.selectText((Node)doc, (String)"/OperationStateResponse/Info/IncAccount/text()", (String)"")).append("\n").append("InfoPaymentMethodCode").append("=").append(XMLUtils.selectText((Node)doc, (String)"/OperationStateResponse/Info/PaymentMethod/Code/text()", (String)"")).append("\n").append("InfoPaymentMethodDescription").append("=").append(XMLUtils.selectText((Node)doc, (String)"/OperationStateResponse/Info/PaymentMethod/Description/text()", (String)"")).append("\n").append("InfoOutCurrLabel").append("=").append(XMLUtils.selectText((Node)doc, (String)"/OperationStateResponse/Info/OutCurrLabel/text()", (String)"")).append("\n").append("InfoOutSum").append("=").append(infoOutSum);
        }
        transaction.setParameters(params.toString());
        this.update(transaction);
    }

    protected Transaction getById(int id) throws BGException, SQLException {
        Transaction transaction = null;
        PreparedStatement ps = this.con.prepareStatement("SELECT t.*, c.title AS contract_title FROM " + this.tableName + " AS t LEFT JOIN contract c ON c.id=t.contract_id WHERE t.id=?");
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            transaction = this.getFromRS(rs);
        }
        rs.close();
        ps.close();
        return transaction;
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException, BGException {
        Transaction transaction = new Transaction();
        transaction.setId(rs.getInt("id"));
        transaction.setContractId(rs.getInt("contract_id"));
        transaction.setContractTitle(rs.getString("contract_title"));
        transaction.setPaymentId(rs.getInt("payment_id"));
        transaction.setCreateDate((Date)rs.getTimestamp("create_date"));
        transaction.setTransactionDate((Date)rs.getTimestamp("transaction_date"));
        transaction.setTransactionId(rs.getString("transaction_id"));
        transaction.setStatus(rs.getString("status"));
        transaction.setParameters(rs.getString("params"));
        transaction.setSum(rs.getBigDecimal("sum"));
        return transaction;
    }

    protected void updateImpl(Transaction transaction) throws BGException {
        if (transaction != null) {
            try {
                String fields = " SET contract_id=?, payment_id=?, create_date=?, transaction_date=?, transaction_id=?, status=?, params=?, sum=?";
                int id = transaction.getId();
                StringBuilder query = new StringBuilder(id > 0 ? "UPDATE " : "INSERT INTO ").append(this.tableName).append(" SET contract_id=?, payment_id=?, create_date=?, transaction_date=?, transaction_id=?, status=?, params=?, sum=?").append(id > 0 ? " WHERE id=?" : "");
                int index = 1;
                PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);
                ps.setInt(index++, transaction.getContractId());
                ps.setInt(index++, transaction.getPaymentId());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
                ps.setString(index++, transaction.getTransactionId());
                ps.setString(index++, transaction.getStatus());
                ps.setString(index++, transaction.getParameters());
                ps.setBigDecimal(index++, transaction.getSum());
                if (id > 0) {
                    ps.setInt(index++, id);
                }
                ps.executeUpdate();
                if (id < 1) {
                    transaction.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
                }
                ps.close();
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public static void addReceipt(ParameterMap moduleSetup, String contractTitle, Map<String, Object> dataMap, BigDecimal sum) {
        if (moduleSetup.getInt("robokassa.receipt", 0) <= 0) {
            return;
        }
        String name = moduleSetup.get("robokassa.receipt.name", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}");
        String paymentMethod = moduleSetup.get("robokassa.receipt.payment_method", "full_payment");
        String paymentObject = moduleSetup.get("robokassa.receipt.payment_object", "commodity");
        String tax = moduleSetup.get("robokassa.receipt.payment_tax", "vat20");
        name = name.replace("{CONTRACT_TITLE}", contractTitle);
        JSONObject item = new JSONObject();
        item.put("name", (Object)name);
        item.put("quantity", 1.0);
        item.put("sum", (Object)sum);
        item.put("payment_method", (Object)paymentMethod);
        item.put("payment_object", (Object)paymentObject);
        item.put("tax", (Object)tax);
        JSONArray items = new JSONArray(Collections.singleton(item));
        JSONObject json = new JSONObject();
        json.put("sno", (Object)"osn");
        json.put("items", (Object)items);
        String data = json.toString();
        data = URLEncoder.encode(data, StandardCharsets.UTF_8);
        dataMap.put("Receipt", data);
    }
}

