/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rscm.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.rscm.client.RSCMUtils;
import ru.bitel.bgbilling.modules.rscm.common.service.RSCMService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.SearchResult;

public class ServiceConfigServices
extends BGUPanel {
    private BGUTable table = null;
    private JLabel recordCountLabel = new JLabel();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private TableModel tableModel = new TableModel(ServiceConfigServices.class.getName());
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent event) throws Exception {
            SearchResult searchResult = ((RSCMService)((ClientContext)ServiceConfigServices.this.getContext()).getPort(RSCMService.class)).searchRSCMService(ServiceConfigServices.this.table.getSort(), ServiceConfigServices.this.pagePanel.getPage());
            ServiceConfigServices.this.tableModel.setData(searchResult.getList());
            ServiceConfigServices.this.pagePanel.setPage(searchResult.getPage());
            ServiceConfigServices.this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
        }
    };
    AbstractBGUPanel.DefaultAction newAction = new AbstractBGUPanel.DefaultAction("new", "\u041d\u043e\u0432\u0430\u044f \u0437\u0430\u043f\u0438\u0441\u044c"){

        public void actionPerformedImpl(ActionEvent event) throws Exception {
            new RSCMServiceParameterEditor("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438", new ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService()).getDialog().setVisible(true);
            ServiceConfigServices.this.performAction("refresh");
        }
    };
    AbstractBGUPanel.DefaultAction editAction = new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent event) throws Exception {
            ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService rscmService = (ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)ServiceConfigServices.this.tableModel.getSelectedRow();
            if (rscmService != null) {
                new RSCMServiceParameterEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438", rscmService).getDialog().setVisible(true);
                ServiceConfigServices.this.performAction("refresh");
            }
        }
    };
    AbstractBGUPanel.DefaultAction deleteAction = new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent event) throws Exception {
            ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService rscmService = (ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)ServiceConfigServices.this.tableModel.getSelectedRow();
            if (rscmService != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0443\u0441\u043b\u0443\u0433\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                try {
                    ((RSCMService)((ClientContext)ServiceConfigServices.this.getContext()).getPort(RSCMService.class)).deleteRSCMService(rscmService.getId());
                    ServiceConfigServices.this.performAction("refresh");
                }
                catch (BGException ex) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ex.getLocalizedMessage());
                }
            }
        }
    };

    public void jbInit() {
        this.table = new BGUTable((javax.swing.table.TableModel)((Object)this.tableModel));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    ServiceConfigServices.this.performAction("edit");
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    class TableModel
    extends BGTableModel<ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService> {
        static final String COLUMN_ID = "id";
        static final String COLUMN_UNIT = "unit";
        static final String COLUMN_INSTALLMENT_DATA = "installmentData";
        static final String COLUMN_SERVICE_TITLE = "serviceTitle";

        public TableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430", 80, 300, 500, COLUMN_SERVICE_TITLE, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u0420\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0430 (\u043f\u043b\u0430\u0442\u0435\u0436\u0438 \u043f\u043e \u043c\u0435\u0441\u044f\u0446\u0430\u043c \u0432 %)", 200, 300, -1, COLUMN_INSTALLMENT_DATA, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u0415\u0434. \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f", 80, 150, 200, COLUMN_UNIT, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
        }

        public Object getValue(ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService rscmService, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if (COLUMN_INSTALLMENT_DATA.equals(identifier)) {
                if (rscmService.getInstallmentData() != null) {
                    return RSCMUtils.getInstallmentDescription(new JSONObject(rscmService.getInstallmentData()));
                }
                return "";
            }
            return super.getValue((Object)rscmService, column);
        }
    }

    class RSCMServiceParameterEditor
    extends BGEditorDialog<ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService> {
        private BGTextField unit;
        private BGComboBox<ComboBoxItem> service;
        private JCheckBox installmentFlag;
        private BGTextField payments;
        private JTextArea samples;

        public RSCMServiceParameterEditor(String title, ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService data) {
            super(title, (Object)data);
            this.unit = new BGTextField(10);
            this.service = new BGComboBox();
            this.installmentFlag = new JCheckBox();
            this.payments = new BGTextField(10);
            this.samples = new JTextArea(4, 30);
        }

        public void doDialogPanel() {
            this.installmentFlag.setSelected(false);
            this.service.setPreferredSize(new Dimension(400, 24));
            this.unit.setHorizontalAlignment(0);
            Dimension dimension = new Dimension(350, 80);
            JScrollPane pane = new JScrollPane(this.samples);
            pane.setMinimumSize(dimension);
            pane.setPreferredSize(dimension);
            this.samples.setMargin(new Insets(5, 5, 5, 5));
            this.samples.setEditable(false);
            this.samples.setText("\u041f\u0440\u0438\u043c\u0435\u0440\u044b \u0437\u0430\u0434\u0430\u043d\u0438\u044f \u0432\u0437\u043d\u043e\u0441\u043e\u0432 \u0432 % (\u0441\u0443\u043c\u043c\u0430 % \u043f\u043e \u043c\u0435\u0441\u044f\u0446\u0430\u043c \u0434\u043e\u043b\u0436\u043d\u0430=100%):\n*/10 - \u0440\u0430\u0432\u043d\u044b\u043c\u0438 \u0434\u043e\u043b\u044f\u043c\u0438 10 \u043c\u0435\u0441\u044f\u0446\u0435\u0432\n50;35;15 - \u0442\u0440\u0438 \u043c\u0435\u0441\u044f\u0446\u0430: 50% \u0432 \u043f\u0435\u0440\u0432\u044b\u0439, \u0434\u0430\u043b\u0435\u0435 35% \u0438 15%\n0;*/10 - \u043f\u0435\u0440\u0432\u044b\u0439 \u043c\u0435\u0441\u044f\u0446 0%, \u0434\u0430\u043b\u0435\u0435 10 \u043c\u0435\u0441\u044f\u0446\u0435\u0432 \u0440\u0430\u0432\u043d\u044b\u043c\u0438 \u0434\u043e\u043b\u044f\u043c\u0438");
            int gridy = 0;
            this.panel.add((Component)new JLabel("\u0423\u0441\u043b\u0443\u0433\u0430:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.service, new GridBagConstraints(1, gridy++, 1, 1, 0.7, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.unit, new GridBagConstraints(1, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041e\u043f\u043b\u0430\u0442\u0430 \u0432 \u0440\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0443:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.installmentFlag, new GridBagConstraints(1, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0412\u0437\u043d\u043e\u0441\u044b \u043f\u043e \u043c\u0435\u0441\u044f\u0446\u0430\u043c \u0432 %:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.payments, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)pane, new GridBagConstraints(0, gridy++, 2, 1, 1.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add(Box.createGlue(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
            try {
                DefaultComboBoxModel<ComboBoxItem> model = null;
                if (((ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)this.data).getId() > 0) {
                    ComboBoxItem item = new ComboBoxItem(((ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)this.data).getServiceId(), ((ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)this.data).getServiceTitle());
                    model = new DefaultComboBoxModel<ComboBoxItem>(new ComboBoxItem[]{item});
                    this.service.setModel(model);
                    this.service.setEnabled(false);
                    this.service.setSelectedIndex(0);
                } else {
                    ComboBoxItem defaultItem = new ComboBoxItem(-1, "-- \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443 --");
                    model = new DefaultComboBoxModel<ComboBoxItem>(new ComboBoxItem[]{defaultItem});
                    for (IdTitle listItem : ((RSCMService)((ClientContext)ServiceConfigServices.this.getContext()).getPort(RSCMService.class)).getRSCMServiceList()) {
                        model.addElement(new ComboBoxItem(listItem.getId(), listItem.getTitle()));
                    }
                }
                this.service.setModel(model);
                this.service.setEnabled(((ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)this.data).getId() == 0);
                this.service.setSelectedIndex(0);
                this.unit.setText(((ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)this.data).getUnit());
                if (((ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)this.data).getInstallmentData() != null) {
                    this.installmentFlag.setSelected(true);
                    JSONObject jsonObject = new JSONObject(((ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)this.data).getInstallmentData());
                    this.payments.setText(jsonObject.optString("payments"));
                }
            }
            catch (BGException ex) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ex.getLocalizedMessage());
            }
        }

        public boolean doApply() throws Exception {
            if (Utils.isEmptyString((String)this.unit.getText().trim())) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \"\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f\"!");
                return false;
            }
            ComboBoxItem item = (ComboBoxItem)this.service.getSelectedItem();
            if (Utils.parseInt((String)((String)item.getObject())) <= 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443!");
                return false;
            }
            JSONObject jsonObject = null;
            if (this.installmentFlag.isSelected()) {
                jsonObject = new JSONObject();
                String value = this.payments.getText().trim();
                String error = null;
                ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
                if (!value.isEmpty() && (error = this.checkPayments(list, value)) != null) {
                    ClientUtils.showErrorMessageDialog((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \"\u0412\u0437\u043d\u043e\u0441\u044b \u043f\u043e \u043c\u0435\u0441\u044f\u0446\u0430\u043c \u0432 %\"\n\n" + error));
                    return false;
                }
                JSONArray paymentsArray = new JSONArray();
                list.forEach(e -> paymentsArray.put(e));
                jsonObject.put("paymentsArray", (Object)paymentsArray);
                jsonObject.put("payments", (Object)value);
            }
            ((ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)this.data).setServiceId(Utils.parseInt((String)String.valueOf(item.getObject())));
            ((ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)this.data).setUnit(this.unit.getText());
            ((ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)this.data).setInstallmentData(this.installmentFlag.isSelected() ? jsonObject.toString() : null);
            try {
                ((RSCMService)((ClientContext)ServiceConfigServices.this.getContext()).getPort(RSCMService.class)).updateRSCMService((ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)this.data);
            }
            catch (BGException ex) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ex.getLocalizedMessage());
            }
            return true;
        }

        private String checkPayments(List<BigDecimal> list, String text) {
            Object error = null;
            BigDecimal p100 = new BigDecimal(100);
            for (String s : text.split(";")) {
                if (!s.matches("^(\\d{1,2}|\\*\\/\\d{1,2})$")) {
                    error = s;
                    break;
                }
                if (s.matches("^\\d+$")) {
                    list.add(new BigDecimal(s));
                    continue;
                }
                if (!s.matches("^\\*\\/\\d{1,2}$")) continue;
                BigDecimal sum = BigDecimal.ZERO;
                for (BigDecimal b : list) {
                    sum = sum.add(b);
                }
                if (sum.compareTo(p100) > 0) {
                    error = "(sum = " + sum + ") > 100%";
                    break;
                }
                int d = Utils.parseInt((String)s.substring(2));
                BigDecimal v = p100.subtract(sum).divide(new BigDecimal(d), 0, RoundingMode.HALF_UP);
                for (int i = 0; i < d; ++i) {
                    list.add(v);
                }
                sum = BigDecimal.ZERO;
                for (BigDecimal b : list) {
                    sum = sum.add(b);
                }
                if (sum.compareTo(p100) == 0) continue;
                error = "(sum = " + sum + ") != 100%";
                break;
            }
            return error;
        }
    }
}

