/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rscm.server.bean;

import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ServiceCostCache;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractService;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractServiceInstallment;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractServiceInstallmentStatus;
import ru.bitel.bgbilling.modules.rscm.server.bean.RSCMCalculatorUtils;
import ru.bitel.bgbilling.modules.rscm.server.bean.RSCMTariffRequestResult;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class RSCMContractServiceManager
implements AutoCloseable {
    private static final Logger log = LogManager.getLogger();
    private Connection con;
    private int moduleId;
    private String tableNameAccount;
    private String tableNameInstallment;

    public RSCMContractServiceManager(Connection con, int moduleId) {
        this.con = con;
        this.moduleId = moduleId;
        this.tableNameAccount = "rscm_service_account_" + moduleId;
        this.tableNameInstallment = "rscm_service_account_installment_" + moduleId;
        BGNestedContext.push((String)"rscm");
    }

    public String checkBalanceForService(int contractId, int serviceId, BigDecimal amount, LocalDate date) throws BGException {
        Calendar cal = TimeUtils.convertLocalDateTimeToCalendar((LocalDateTime)date.atStartOfDay());
        Object result = null;
        TariffTreeSet tariffTreeSet = null;
        BigDecimal limit = BigDecimal.ZERO;
        try (ContractManager contractManager = new ContractManager(this.con);){
            limit = contractManager.getContractById(contractId).getBalanceLimit();
            tariffTreeSet = contractManager.getRealtimeTariffTreeSet(contractId, cal.getTime(), "rscm", this.moduleId, true);
        }
        BalanceUtils bu = new BalanceUtils(this.con);
        List treeList = tariffTreeSet.getTreeEntryList(cal);
        if (treeList != null && treeList.size() > 0) {
            TariffRequest tariffRequest = null;
            boolean fl = true;
            for (TariffTreeSet.TariffSetEntry tree : treeList) {
                tariffRequest = new TariffRequest();
                tariffRequest.setRequestParam("sid", (Object)serviceId);
                tariffRequest.setRequestParam("time", (Object)date);
                tree.getTree().processRequest(tariffRequest);
                BigDecimal cost = (BigDecimal)tariffRequest.getResponseParam("cost");
                BigDecimal divisor = (BigDecimal)tariffRequest.getResponseParam("divisor");
                if (!tariffRequest.wasAccepted() || cost == null || divisor == null || divisor.longValue() <= 0L) continue;
                BigDecimal summa = amount.multiply(cost.divide(divisor, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP));
                BigDecimal balance = bu.getBalance(cal.getTime(), contractId);
                if (balance.subtract(limit).compareTo(summa) < 0) {
                    result = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u043f\u043b\u0430\u0442\u0438\u0442\u044c \u0443\u0441\u043b\u0443\u0433\u0443\nsumma=" + summa + ", balance=" + balance + ", limit=" + limit;
                }
                fl = false;
                break;
            }
            if (fl) {
                log.error("Tariff request wasn't processed: " + tariffRequest.toString());
                result = "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0446\u0435\u043d\u0430 \u0443\u0441\u043b\u0443\u0433\u0438 \u0432 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u043c \u043f\u043b\u0430\u043d\u0435!";
            }
        } else {
            result = "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u0430\u0440\u0438\u0444 \u043c\u043e\u0434\u0443\u043b\u044f \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u0443\u044e \u0434\u0430\u0442\u0443!";
        }
        bu.close();
        return result;
    }

    public void checkTariffsForService(int contractId, int serviceId, LocalDate localDate) throws BGException {
        Calendar date = TimeUtils.convertLocalDateTimeToCalendar((LocalDateTime)localDate.atStartOfDay());
        TariffTreeSet tariffTreeSet = null;
        try (ContractManager contractManager = new ContractManager(this.con);){
            tariffTreeSet = contractManager.getRealtimeTariffTreeSet(contractId, TimeUtils.getStartMonth((Calendar)date).getTime(), "rscm", this.moduleId, true);
        }
        List treeList = tariffTreeSet.getTreeEntryList(date);
        if (treeList != null && treeList.size() > 0) {
            boolean accepted = false;
            TariffRequest tariffRequest = null;
            for (TariffTreeSet.TariffSetEntry tree : treeList) {
                tariffRequest = new TariffRequest();
                tariffRequest.setRequestParam("sid", (Object)serviceId);
                tariffRequest.setRequestParam("time", (Object)date);
                tree.getTree().processRequest(tariffRequest);
                BigDecimal cost = (BigDecimal)tariffRequest.getResponseParam("cost");
                BigDecimal divisor = (BigDecimal)tariffRequest.getResponseParam("divisor");
                if (!tariffRequest.wasAccepted() || cost == null || divisor == null || divisor.longValue() <= 0L) continue;
                accepted = true;
                break;
            }
            if (!accepted) {
                throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0443\u0441\u043b\u0443\u0433\u0443! \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0443\u0441\u043b\u0443\u0433\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0442\u0430\u0440\u0438\u0444\u0435 \u0438\u043b\u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u043e!");
            }
        } else {
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0443\u0441\u043b\u0443\u0433\u0443! \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0443\u0441\u043b\u0443\u0433\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0442\u0430\u0440\u0438\u0444\u0435 \u0438\u043b\u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u043e!");
        }
    }

    public List<RSCMContractService> getContractServiceList(int contractId, Calendar month) throws BGException {
        if (month == null) {
            month = new GregorianCalendar();
        }
        Period period = new Period();
        month.set(5, 1);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)month);
        period.setDateFrom(month.getTime());
        month.add(2, 1);
        month.add(14, -1);
        period.setDateTo(month.getTime());
        return this.getContractServiceList(contractId, period, new Page(1, 0), true);
    }

    public List<RSCMContractService> getContractServiceList(int contractId, Period period, Page page, boolean dateAscOrder) throws BGException {
        ArrayList<RSCMContractService> result = new ArrayList<RSCMContractService>();
        String query = "SELECT SQL_CALC_FOUND_ROWS rscm.*, service.title, rscm_service.unit FROM " + this.tableNameAccount + " AS rscm LEFT JOIN service ON service.id=rscm.sid LEFT JOIN rscm_service_" + this.moduleId + " AS rscm_service ON rscm.sid=rscm_service.sid WHERE rscm.cid=" + contractId + " AND rscm.date >= ? AND rscm.date < ?" + " ORDER BY rscm.date" + (dateAscOrder ? "" : " DESC") + (page != null && page.getPageSize() > 0 ? page.sqlLimit() : "");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
            ps.setDate(2, TimeUtils.convertLocalDateToSqlDate((LocalDate)period.getLocalDateTo().plusDays(1L)));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getContractServiceFromRS(rs));
            }
            rs.close();
            page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    private RSCMContractService getContractServiceFromRS(ResultSet rs) throws SQLException {
        RSCMContractService result = new RSCMContractService();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("cid"));
        result.setServiceId(rs.getInt("sid"));
        result.setInstallmentId(rs.getInt("installment_id"));
        result.setServiceTitle(rs.getString("title"));
        result.setUnit(rs.getString("unit"));
        result.setAmount(rs.getBigDecimal("amount"));
        result.setComment(rs.getString("comment"));
        result.setDate(TimeUtils.convertDateToLocalDate((Date)rs.getDate("date")));
        return result;
    }

    public void updateContractService(RSCMContractService contractService) throws BGException {
        if (contractService == null) {
            return;
        }
        boolean insert = contractService.getId() < 1;
        String query = (insert ? "INSERT INTO " : "UPDATE ") + this.tableNameAccount + " SET cid=?, sid=?, installment_id=?, date=?, amount=?, comment=?" + (insert ? "" : " WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int parameterIndex = 1;
            ps.setInt(parameterIndex++, contractService.getContractId());
            ps.setInt(parameterIndex++, contractService.getServiceId());
            ps.setInt(parameterIndex++, contractService.getInstallmentId());
            ps.setDate(parameterIndex++, TimeUtils.convertLocalDateToSqlDate((LocalDate)contractService.getDate()));
            ps.setBigDecimal(parameterIndex++, contractService.getAmount());
            ps.setString(parameterIndex++, contractService.getComment());
            if (!insert) {
                ps.setInt(parameterIndex++, contractService.getId());
            }
            ps.executeUpdate();
            if (insert) {
                contractService.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void deleteContractService(int id, int contractId, LocalDate month) throws BGException {
        try (Statement st = this.con.createStatement();){
            st.executeUpdate("DELETE FROM " + this.tableNameAccount + " WHERE id=" + id + " AND cid=" + contractId);
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public RSCMContractService getContractService(int contractId, int id) throws BGException {
        RSCMContractService result = null;
        try {
            String query = "SELECT rscm.*, service.title, rscm_service.unit FROM " + this.tableNameAccount + " AS rscm LEFT JOIN service ON service.id=rscm.sid LEFT JOIN rscm_service_" + this.moduleId + " AS rscm_service ON rscm.sid=rscm_service.id WHERE rscm.id=? AND rscm.cid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.setInt(2, contractId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = this.getContractServiceFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void updateRSCMContractServiceInstallment(RSCMContractServiceInstallment rscmContractServiceInstallment) throws BGException {
        if (rscmContractServiceInstallment == null) {
            return;
        }
        boolean insert = rscmContractServiceInstallment.getId() < 1;
        String query = (insert ? "INSERT INTO " : "UPDATE ") + this.tableNameInstallment + " SET contract_id=?, service_id=?, status=?, date_from=?, date_next=?, amount=?, payment_count=?, installment=?" + (insert ? "" : " WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int parameterIndex = 1;
            ps.setInt(parameterIndex++, rscmContractServiceInstallment.getContractId());
            ps.setInt(parameterIndex++, rscmContractServiceInstallment.getServiceId());
            ps.setInt(parameterIndex++, rscmContractServiceInstallment.getStatus().getCode());
            ps.setDate(parameterIndex++, TimeUtils.convertLocalDateToSqlDate((LocalDate)rscmContractServiceInstallment.getDateFrom()));
            ps.setDate(parameterIndex++, TimeUtils.convertLocalDateToSqlDate((LocalDate)rscmContractServiceInstallment.getDateNext()));
            ps.setBigDecimal(parameterIndex++, rscmContractServiceInstallment.getAmount());
            ps.setInt(parameterIndex++, rscmContractServiceInstallment.getPaymentCount());
            ps.setString(parameterIndex++, rscmContractServiceInstallment.getInstallment());
            if (!insert) {
                ps.setInt(parameterIndex++, rscmContractServiceInstallment.getId());
            }
            ps.executeUpdate();
            if (insert) {
                rscmContractServiceInstallment.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void hotCalc(int contractId, LocalDate date) throws BGException, BGMessageException {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        if (moduleSetup.getBoolean("hot.calc", false)) {
            LocalDate now;
            ContractManager contractManager = new ContractManager(this.con);
            ServiceCostCache costCache = new ServiceCostCache();
            LocalDate dateStart = date.withDayOfMonth(1);
            LocalDate dateEnd = dateStart.plusMonths(1L);
            if (moduleSetup.getBoolean("not.calculate.future.services", false) && (now = LocalDate.now()).isBefore(dateEnd)) {
                dateEnd = now;
                dateEnd = dateEnd.plusDays(1L);
            }
            if (log.isDebugEnabled()) {
                log.debug("hot calc: processing {} [{}-{}]", (Object)this.tableNameAccount, (Object)TimeUtils.format((LocalDate)dateStart, (String)"dd.MM.yyyy"), (Object)TimeUtils.format((LocalDate)dateEnd, (String)"dd.MM.yyyy"));
            }
            try {
                String tableName = "rscm_service_account_" + this.moduleId;
                TariffTreeSet tariffTreeSet = contractManager.getRealtimeTariffTreeSet(contractId, TimeUtils.convertLocalDateToDate((LocalDate)date.withDayOfMonth(1)), "rscm", this.moduleId, true);
                String query = "SELECT s.sid AS sid, s.date AS date, s.amount AS amount, c.domainId AS domainId FROM " + tableName + " AS s INNER JOIN contract AS c ON c.id=s.cid WHERE s.date >= ? AND s.date < ? AND cid=?";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setDate(1, TimeUtils.convertLocalDateToSqlDate((LocalDate)dateStart));
                ps.setDate(2, TimeUtils.convertLocalDateToSqlDate((LocalDate)dateEnd));
                ps.setInt(3, contractId);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    int serviceId = rs.getInt("sid");
                    Calendar time = TimeUtils.convertDateToCalendar((Date)rs.getDate("date"));
                    List treeList = tariffTreeSet.getTreeEntryList(time);
                    if (treeList != null && treeList.size() > 0) {
                        RSCMTariffRequestResult result = RSCMCalculatorUtils.processTariffRequest(costCache, treeList, rs.getInt("domainId"), contractId, serviceId, rs.getBigDecimal("amount"), time, log);
                        if (result.accepted) continue;
                        log.error("Tariff request wasn't processed: {}", (Object)result.tariffRequestString);
                        throw new BGMessageException("\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u043d\u0435 \u0431\u044b\u043b \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d! \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0443\u0441\u043b\u0443\u0433\u0430 \u0432 \u0442\u0430\u0440\u0438\u0444\u0435.");
                    }
                    ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.con, Integer.valueOf(contractId));
                    if (contractRuntime != null) {
                        log.error("Tariff not found contract => {}; date => {}", (Object)contractRuntime.getContractTitle(), (Object)TimeUtils.format((Calendar)time, (String)"dd.MM.yyyy"));
                        throw new BGMessageException("\u0422\u0430\u0440\u0438\u0444 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d! \u0414\u043e\u0433\u043e\u0432\u043e\u0440: " + contractRuntime.getContractTitle());
                    }
                    log.error("Tariff not found contractId => " + contractId + "; date => " + TimeUtils.format((Calendar)time, (String)"dd.MM.yyyy"));
                    throw new BGMessageException("\u0422\u0430\u0440\u0438\u0444 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d! \u041a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + contractId);
                }
                rs.close();
                ps.close();
                String services = ModuleCache.getInstance().getModuleServicesString(this.moduleId);
                BalanceUtils balanceUtils = new BalanceUtils(this.con);
                balanceUtils.setAccount(this.con, log, TimeUtils.convertLocalDateTimeToCalendar((LocalDateTime)date.atStartOfDay()), costCache, services, String.valueOf(contractId), null);
                balanceUtils.close();
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
            finally {
                contractManager.close();
            }
        }
    }

    public void searchContractServiceInstallment(SearchResult<RSCMContractServiceInstallment> searchResult, int contractId, Page page) throws BGException, BGMessageException {
        if (searchResult == null) {
            return;
        }
        List list = searchResult.getList();
        String query = "SELECT * FROM " + this.tableNameInstallment + " WHERE contract_id=" + contractId + (page != null && page.getPageSize() > 0 ? page.sqlLimit() : "");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(this.getContractServiceInstallmentFromRS(rs));
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public RSCMContractService getContractServiceByInstallmentId(int installmentId, int contractId, LocalDate month) throws BGException, BGMessageException {
        RSCMContractService contractService = null;
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableNameAccount + " WHERE cid=? AND installment_id=? AND date>=? AND date<=?");){
            int paramIndex = 1;
            ps.setInt(paramIndex++, contractId);
            ps.setInt(paramIndex++, installmentId);
            ps.setDate(paramIndex++, TimeUtils.convertLocalDateToSqlDate((LocalDate)month.withDayOfMonth(1)));
            ps.setDate(paramIndex++, TimeUtils.convertLocalDateToSqlDate((LocalDate)month.withDayOfMonth(month.lengthOfMonth())));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    contractService = this.getContractServiceFromRS(rs);
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return contractService;
    }

    public List<RSCMContractServiceInstallment> getContractServiceInstallmentList() throws BGException, BGMessageException {
        ArrayList<RSCMContractServiceInstallment> list = new ArrayList<RSCMContractServiceInstallment>();
        String query = "SELECT * FROM " + this.tableNameInstallment;
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                list.add(this.getContractServiceInstallmentFromRS(rs));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return list;
    }

    public RSCMContractServiceInstallment getContractServiceInstallment(int id) throws BGException, BGMessageException {
        RSCMContractServiceInstallment installment = null;
        String query = "SELECT * FROM " + this.tableNameInstallment + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    installment = this.getContractServiceInstallmentFromRS(rs);
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return installment;
    }

    public RSCMContractServiceInstallment deleteContractServiceInstallment(int id) throws BGException, BGMessageException {
        RSCMContractServiceInstallment installment = null;
        String query = "DELETE FROM " + this.tableNameInstallment + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return installment;
    }

    @Override
    public void close() throws Exception {
        BGNestedContext.pop();
    }

    private RSCMContractServiceInstallment getContractServiceInstallmentFromRS(ResultSet rs) throws SQLException {
        RSCMContractServiceInstallment result = new RSCMContractServiceInstallment();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("contract_id"));
        result.setServiceId(rs.getInt("service_id"));
        result.setStatus(RSCMContractServiceInstallmentStatus.getRSCMContractServiceInstallmentStatusByCode((int)rs.getInt("status")));
        result.setDateFrom(TimeUtils.convertDateToLocalDate((Date)rs.getDate("date_from")));
        result.setDateNext(TimeUtils.convertDateToLocalDate((Date)rs.getDate("date_next")));
        result.setAmount(rs.getBigDecimal("amount"));
        result.setPaymentCount(rs.getInt("payment_count"));
        result.setInstallment(rs.getString("installment"));
        return result;
    }
}

