/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.runtel.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.runtel.server.bean.RunTelContract;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class RunTelDao
extends AbstractDao<RunTelContract> {
    public RunTelDao(Connection con, int moduleId) {
        super(con, moduleId, "");
    }

    public void searchContracts(SearchResult<RunTelContract> searchResult, int emailParameterId) throws BGException {
        String query = "SELECT c.id, c.title, c.comment, c.date1, c.date2, c.status, e.email  FROM contract_module AS cm LEFT JOIN contract AS c ON c.id=cm.cid LEFT JOIN contract_parameter_type_3 AS e ON c.id=e.cid AND e.pid=?  WHERE cm.mid=?";
        List contracts = searchResult.getList();
        try {
            int parameterIndex = 1;
            PreparedStatement preparedStatement = this.con.prepareStatement(query);
            preparedStatement.setInt(parameterIndex++, emailParameterId);
            preparedStatement.setInt(parameterIndex++, this.moduleId);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String[] emailArray = null;
                String emails = resultSet.getString("e.email");
                if (Utils.notBlankString((String)emails)) {
                    emailArray = emails.split("\n");
                }
                RunTelContract runTelContract = new RunTelContract();
                runTelContract.setContractId(resultSet.getInt("c.id"));
                runTelContract.setContractTitle(resultSet.getString("c.title"));
                runTelContract.setContractComment(resultSet.getString("c.comment"));
                runTelContract.setPeriod(new Period((Date)resultSet.getDate("c.date1"), (Date)resultSet.getDate("c.date2")));
                runTelContract.setStatus(resultSet.getInt("c.status"));
                runTelContract.setEmail(emailArray != null && emailArray.length > 0 ? emailArray[0] : null);
                contracts.add(runTelContract);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    protected RunTelContract getFromRS(ResultSet rs) throws SQLException, BGException {
        return null;
    }

    protected void updateImpl(RunTelContract b) throws BGException, SQLException {
    }
}

