/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCamera;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostTMCAO;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ForpostCameraDao
extends AbstractDao<ForpostCamera> {
    private Logger logger = LogManager.getLogger();
    private final String TABLE_FORPOST_ACCOUNT;
    private final String TABLE_FORPOST_ACCOUNT_CONTRACT;

    public ForpostCameraDao(Connection con, int moduleId) {
        super(con, moduleId, "smarthouse_forpost_camera");
        this.TABLE_FORPOST_ACCOUNT = "smarthouse_forpost_account_" + moduleId;
        this.TABLE_FORPOST_ACCOUNT_CONTRACT = "smarthouse_forpost_account_contract_" + moduleId;
    }

    public List<ForpostCamera> list() throws BGException {
        return this.list(null, "id", new Object[0]);
    }

    protected ForpostCamera getFromRS(ResultSet rs) throws SQLException, BGException {
        ForpostCamera result = new ForpostCamera();
        result.setId(rs.getInt("id"));
        result.setName(rs.getString("name"));
        result.setAccountId(rs.getInt("account_id"));
        result.setAccountObjectId(rs.getInt("account_object_id"));
        result.setMasterId(rs.getInt("master_id"));
        result.setLogin(rs.getString("login"));
        result.setIpOrDomain(rs.getString("ip_or_domain"));
        result.setPort(rs.getInt("port"));
        result.setIsActive(rs.getInt("is_active"));
        result.setData(rs.getString("data"));
        return result;
    }

    protected void updateImpl(ForpostCamera forpostCamera) throws BGException {
        if (forpostCamera != null) {
            String sqlField = "name=?, account_id=?, account_object_id=?, master_id=?, login=?, ip_or_domain=?, port=?, is_active=?, data=?";
            try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " SET id=?, " + sqlField + " ON DUPLICATE KEY UPDATE " + sqlField);){
                int parameterIndex = 1;
                ps.setInt(parameterIndex++, forpostCamera.getId());
                ps.setString(parameterIndex++, forpostCamera.getName());
                ps.setInt(parameterIndex++, forpostCamera.getAccountId());
                ps.setInt(parameterIndex++, forpostCamera.getAccountObjectId());
                ps.setInt(parameterIndex++, forpostCamera.getMasterId());
                ps.setString(parameterIndex++, forpostCamera.getLogin());
                ps.setString(parameterIndex++, forpostCamera.getIpOrDomain());
                ps.setInt(parameterIndex++, forpostCamera.getPort());
                ps.setInt(parameterIndex++, forpostCamera.getIsActive());
                ps.setString(parameterIndex++, forpostCamera.getData());
                ps.setString(parameterIndex++, forpostCamera.getName());
                ps.setInt(parameterIndex++, forpostCamera.getAccountId());
                ps.setInt(parameterIndex++, forpostCamera.getAccountObjectId());
                ps.setInt(parameterIndex++, forpostCamera.getMasterId());
                ps.setString(parameterIndex++, forpostCamera.getLogin());
                ps.setString(parameterIndex++, forpostCamera.getIpOrDomain());
                ps.setInt(parameterIndex++, forpostCamera.getPort());
                ps.setInt(parameterIndex++, forpostCamera.getIsActive());
                ps.setString(parameterIndex++, forpostCamera.getData());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(ps.toString());
                }
                ps.executeUpdate();
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void deleteForpostCamera(int id) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE id=?");){
            ps.setInt(1, id);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(ps.toString());
            }
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void searchForpostCameras(SearchResult<ForpostTMCAO<ForpostCamera>> searchResult, KeyValue filter) throws BGException {
        Page page = searchResult.getPage();
        List list = searchResult.getList();
        StringBuilder query = new StringBuilder();
        query.append("SELECT SQL_CALC_FOUND_ROWS cam.*, a.name AS accountName, c.id AS contractId, c.title AS contractTitle FROM " + this.tableName + " AS cam ");
        query.append("LEFT JOIN " + this.TABLE_FORPOST_ACCOUNT + " AS a ON a.id=cam.account_id ");
        query.append("LEFT JOIN " + this.TABLE_FORPOST_ACCOUNT_CONTRACT + " AS ac ON ac.account_id=cam.account_id ");
        query.append("LEFT JOIN contract AS c ON c.id=ac.contract_id ");
        if (filter != null && Utils.notBlankString((String)filter.getValue())) {
            switch (filter.getKey()) {
                case "id": {
                    query.append("WHERE cam.id=? ");
                    break;
                }
                case "name": {
                    query.append("WHERE cam.name like ? ");
                    break;
                }
                case "host": {
                    query.append("WHERE cam.ip_or_domain like ? ");
                    break;
                }
            }
        }
        query.append(page != null ? page.sqlLimit() : "");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);){
            if (filter != null && Utils.notBlankString((String)filter.getValue())) {
                switch (filter.getKey()) {
                    case "id": {
                        ps.setInt(1, Utils.parseInt((String)filter.getValue().trim()));
                        break;
                    }
                    case "name": {
                        ps.setString(1, "%" + filter.getValue().trim() + "%");
                        break;
                    }
                    case "host": {
                        ps.setString(1, "%" + filter.getValue().trim() + "%");
                        break;
                    }
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ForpostTMCAO tableModelRow = new ForpostTMCAO();
                tableModelRow.setContractId(rs.getInt("contractId"));
                tableModelRow.setContractTitle(rs.getString("contractTitle"));
                tableModelRow.setAccountName(rs.getString("accountName"));
                tableModelRow.setObject((Object)this.getFromRS(rs));
                list.add(tableModelRow);
            }
            rs.close();
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            throw new BGException((Throwable)e);
        }
    }

    public void searchForpostAccountCameras(SearchResult<ForpostCamera> searchResult, int accountId) throws BGException {
        Page page = searchResult.getPage();
        List list = searchResult.getList();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + (accountId > 0 ? " WHERE account_id=? " : "") + (page != null ? page.sqlLimit() : ""));){
            if (accountId > 0) {
                ps.setInt(1, accountId);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(this.getFromRS(rs));
            }
            rs.close();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            throw new BGException((Throwable)e);
        }
    }

    public void doSync(ForpostCamera[] cameras) throws BGException {
        if (cameras == null) {
            return;
        }
        long now = System.currentTimeMillis();
        String sqlField = "name=?, account_id=?, account_object_id=?, master_id=?, login=?, ip_or_domain=?, port=?, is_active=?, data=?, sync_datetime=?";
        try (PreparedStatement psInsert = this.con.prepareStatement("INSERT INTO " + this.tableName + " SET id=?, " + sqlField + " ON DUPLICATE KEY UPDATE " + sqlField);
             PreparedStatement psDelete = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE sync_datetime<>? AND account_id=?");){
            int accountId = 0;
            for (ForpostCamera forpostCamera : cameras) {
                int parameterIndex = 1;
                psInsert.setInt(parameterIndex++, forpostCamera.getId());
                psInsert.setString(parameterIndex++, forpostCamera.getName());
                psInsert.setInt(parameterIndex++, forpostCamera.getAccountId());
                psInsert.setInt(parameterIndex++, forpostCamera.getAccountObjectId());
                psInsert.setInt(parameterIndex++, forpostCamera.getMasterId());
                psInsert.setString(parameterIndex++, forpostCamera.getLogin());
                psInsert.setString(parameterIndex++, forpostCamera.getIpOrDomain());
                psInsert.setInt(parameterIndex++, forpostCamera.getPort());
                psInsert.setInt(parameterIndex++, forpostCamera.getIsActive());
                psInsert.setString(parameterIndex++, forpostCamera.getData());
                psInsert.setLong(parameterIndex++, now);
                psInsert.setString(parameterIndex++, forpostCamera.getName());
                psInsert.setInt(parameterIndex++, forpostCamera.getAccountId());
                psInsert.setInt(parameterIndex++, forpostCamera.getAccountObjectId());
                psInsert.setInt(parameterIndex++, forpostCamera.getMasterId());
                psInsert.setString(parameterIndex++, forpostCamera.getLogin());
                psInsert.setString(parameterIndex++, forpostCamera.getIpOrDomain());
                psInsert.setInt(parameterIndex++, forpostCamera.getPort());
                psInsert.setInt(parameterIndex++, forpostCamera.getIsActive());
                psInsert.setString(parameterIndex++, forpostCamera.getData());
                psInsert.setLong(parameterIndex++, now);
                psInsert.executeUpdate();
                accountId = forpostCamera.getAccountId();
            }
            if (accountId > 0) {
                psDelete.setLong(1, now);
                psDelete.setInt(2, accountId);
                psDelete.executeUpdate();
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public ForpostCamera getForpostCamera(int forpostCameraId) throws BGException {
        try {
            return (ForpostCamera)this.getById(forpostCameraId);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public Map<Integer, Integer> getForpostCameraModelStat() throws BGException {
        HashMap<Integer, Integer> hashMap;
        block9: {
            Statement st = this.con.createStatement();
            try {
                HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
                ResultSet rs = st.executeQuery("SELECT SUBSTRING( REGEXP_SUBSTR( data, 'CameraModelID=\\\\d+' ) , 15) as cameraModelId, count(*) FROM " + this.tableName + " GROUP BY cameraModelId");
                while (rs.next()) {
                    String id = rs.getString(1);
                    if (id == null) continue;
                    result.put(rs.getInt(1), rs.getInt(2));
                }
                hashMap = result;
                if (st == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new BGException((Throwable)e);
                }
            }
            st.close();
        }
        return hashMap;
    }
}

