/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.client.upload;

import bitel.billing.module.common.BGComponentBorder;
import bitel.billing.module.common.BGControlPanelListSelect;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGSelectedDevicePanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.sorm.common.UploadModulesTitle;
import ru.bitel.bgbilling.modules.sorm.common.bean.InstalledInstanceModule;
import ru.bitel.bgbilling.modules.sorm.common.service.SormService;
import ru.bitel.common.Utils;

public class ConditionPanel
extends JPanel {
    private String title;
    private JCheckBox enable;
    private JCheckBox fictive;
    private JPanel detailPanel = new JPanel(new GridBagLayout());
    private int mid;

    ConditionPanel(String title, int mid) {
        this(title);
        this.mid = mid;
    }

    public ConditionPanel(String title) {
        this.title = title;
        this.init();
    }

    private void init() {
        this.enable = new JCheckBox(this.title, false);
        this.enable.setFocusPainted(false);
        this.fictive = new JCheckBox(this.title, false);
        this.fictive.setVisible(true);
        this.detailPanel.setVisible(false);
        BGComponentBorder componentBorder = new BGComponentBorder((Component)this.enable, (JComponent)this.detailPanel, BorderFactory.createEtchedBorder());
        this.fictive.addActionListener(e -> {
            this.detailPanel.setVisible(true);
            this.fictive.setVisible(false);
            this.enable.setSelected(true);
        });
        this.enable.addActionListener(e -> {
            this.detailPanel.setVisible(false);
            this.fictive.setVisible(true);
            this.fictive.setSelected(false);
        });
        this.detailPanel.setBorder((Border)componentBorder);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.fictive, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.detailPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.fictive.doClick();
        }
    }

    List<ConditionPanel> getInnerPanels() {
        ArrayList<ConditionPanel> result = new ArrayList<ConditionPanel>();
        for (Component component : this.detailPanel.getComponents()) {
            if (!(component instanceof ConditionPanel)) continue;
            result.add((ConditionPanel)component);
        }
        return result;
    }

    public List<Integer> getSelectedIds() {
        List<Integer> list = new ArrayList<Integer>();
        for (Component component : this.detailPanel.getComponents()) {
            if (component instanceof BGControlPanelListSelect) {
                list = ((BGControlPanelListSelect)component).getListIds();
            }
            if (!(component instanceof BGSelectedDevicePanel)) continue;
            list = ((BGSelectedDevicePanel)component).getSelectedDeviceItem();
        }
        return list;
    }

    public void setSelectedIds(List<Integer> selectedIds) throws BGException {
        String values = Utils.toString(selectedIds);
        if (Utils.isBlankString((String)values)) {
            return;
        }
        for (Component component : this.detailPanel.getComponents()) {
            int mid;
            SormService sormService;
            Optional<InstalledInstanceModule> optional;
            Container parent;
            if (component instanceof BGControlPanelListSelect) {
                ((BGControlPanelListSelect)component).setListValues(values);
                continue;
            }
            if (!(component instanceof BGSelectedDevicePanel) || !((parent = component.getParent().getParent()) instanceof ConditionPanel) || !(optional = (sormService = (SormService)new ClientContext("kernel", 0, mid = ((ConditionPanel)parent).getMid(), null).getPort(SormService.class)).getInstalledSormModules().stream().filter(i -> i.getModuleId() == mid).findFirst()).isPresent()) continue;
            InstalledInstanceModule module = optional.get();
            String titleModule = module.getTitleModule();
            if (titleModule.equals(UploadModulesTitle.INET.getTitleModule())) {
                ((BGSelectedDevicePanel)component).setSelectedDeviceItem(values, mid, false);
                continue;
            }
            if (!titleModule.equals(UploadModulesTitle.VOICE.getTitleModule())) continue;
            ((BGSelectedDevicePanel)component).setSelectedDeviceItem(values, mid, true);
        }
    }

    public JPanel getDetailPanel() {
        return this.detailPanel;
    }

    public boolean isEnable() {
        return this.enable.isSelected();
    }

    public int getMid() {
        return this.mid;
    }

    public void setMid(int mid) {
        this.mid = mid;
    }
}

