/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.client.upload.vasexpert;

import bitel.billing.module.common.ListItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import ru.bitel.bgbilling.modules.sorm.client.SormSettingsPanel;
import ru.bitel.bgbilling.modules.sorm.client.upload.DirectoryConfigurePanel;
import ru.bitel.bgbilling.modules.sorm.client.upload.SormRatioPanel;
import ru.bitel.bgbilling.modules.sorm.common.bean.Ratio;
import ru.bitel.bgbilling.modules.sorm.common.bean.RatioDescription;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.upload.vasexpert.VasExpertPaymentType;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;

public class VasexpertDirectoryConfigurePanel
extends DirectoryConfigurePanel {
    private SormRatioPanel ratioPanel = new SormRatioPanel("<html>\u0414\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u043a\u0430\u043a\u0438\u0435 \u0442\u0438\u043f\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439<br>\u044f\u0432\u043b\u044f\u044e\u0442\u0441\u044f \u043d\u0430\u043b\u0438\u0447\u043d\u044b\u043c\u0438, \u0430 \u043a\u0430\u043a\u0438\u0435 \u0431\u0435\u0437\u043d\u0430\u043b\u0438\u0447\u043d\u044b\u043c\u0438</html>");
    private JCheckBox enableContractIdWithServiceId = new JCheckBox("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 ID \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0430 \u0441\u0432\u044f\u0437\u043a\u0443 ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 + ID \u0441\u0435\u0440\u0432\u0438\u0441\u0430?");

    public VasexpertDirectoryConfigurePanel(SormSettingsPanel parent, SormProject sormProject) {
        super(parent, sormProject);
        this.init();
    }

    @Override
    protected void jbInit() throws Exception {
        super.jbInit();
        this.payType.getDetailPanel().add((Component)((Object)this.ratioPanel), this.constraints);
        this.ratioPanel.setDataSelectionList(this.getDataForListSelection());
        this.inetPanel.add((Component)this.getCheckboxPanel(), this.constraints);
    }

    private JPanel getCheckboxPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.enableContractIdWithServiceId, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 3, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.createHelpLabel((String)"<html>\u0415\u0441\u043b\u0438 \u0435\u0441\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0441 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u0438\u043c\u0438 \u0441\u0435\u0440\u0432\u0438\u0441\u0430\u043c\u0438 \u043c\u043e\u0434\u0443\u043b\u044f \u0438\u043d\u0435\u0442,<br>\u0442\u043e \u0434\u043b\u044f \u0412\u0430\u0441\u042d\u043a\u0441\u043f\u0435\u0440\u0442\u0441 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u0443\u044e \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0443</html>", (int)-1), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 10, 3, 3), 0, 0));
        return panel;
    }

    @Override
    public void setSormProject(SormProject sormProject) {
        super.setSormProject(sormProject);
        this.enableContractIdWithServiceId.setSelected(Utils.maskBlank((String)sormProject.getLoadedConfig().get("sorm.upload.contractidwithservice"), (String)"").equals("1"));
    }

    @Override
    public void buildConfig(Preferences config) {
        super.buildConfig(config);
        config.set("sorm.upload.contractidwithservice", this.enableContractIdWithServiceId.isSelected() ? "1" : "0");
    }

    @Override
    public void reloadRatioPaymentsPanel(Preferences config) {
        Map ratioMap;
        ParameterMap parameterMap = null;
        if (config != null && (ratioMap = config.subKeyed("sorm.upload.paytype.ratio")).size() > 0) {
            parameterMap = (ParameterMap)ratioMap.get("");
        }
        ArrayList<Ratio> result = new ArrayList<Ratio>();
        for (ListItem selectedType : this.getSelectedPayTypes()) {
            String id = (String)selectedType.getAttribute("id");
            VasExpertPaymentType type = null;
            if (parameterMap != null) {
                int code = parameterMap.getInt(id, -1);
                type = VasExpertPaymentType.getType((int)code);
            }
            result.add(new Ratio(Utils.parseInt((String)id), selectedType.getText(), (RatioDescription)(type == null ? VasExpertPaymentType.BANK_PAYMENT : type)));
        }
        this.ratioPanel.setDataTable(result);
    }

    private List<ru.bitel.common.model.ListItem> getDataForListSelection() {
        ArrayList<ru.bitel.common.model.ListItem> result = new ArrayList<ru.bitel.common.model.ListItem>();
        for (final VasExpertPaymentType type : VasExpertPaymentType.values()) {
            result.add(new ru.bitel.common.model.ListItem(){

                public int getId() {
                    return type.getCode();
                }

                public String getTitle() {
                    return type.getDescription();
                }
            });
        }
        return result;
    }

    @Override
    public void setPaymentRatio(Preferences config) {
        for (Ratio ratio : this.ratioPanel.getRatioList()) {
            config.set("sorm.upload.paytype.ratio." + ratio.getId(), String.valueOf(ratio.getRatioDescription().getCode()));
        }
    }
}

