/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.task;

import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.service.SormService;
import ru.bitel.bgbilling.modules.sorm.server.upload.SormProjectUpload;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;

public class SormPaymentUploadTask
extends TaskBase {
    private static final Logger logger = LogManager.getLogger();

    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        List<SormProject> activeSormProjects = this.getActiveSormProjects();
        logger.info("\u0412\u0441\u0435\u0433\u043e \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u043f\u0440\u043e\u0435\u043a\u0442\u043e\u0432 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439: " + activeSormProjects.size());
        for (SormProject sormProject : activeSormProjects) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0434\u043b\u044f \u043f\u0440\u043e\u0435\u043a\u0442\u0430 \u0421\u041e\u0420\u041c: " + sormProject.getTitle());
                }
                int uploadType = this.taskSetup.getInt("typeUpload." + sormProject.getId(), 0);
                SormUtils.sormModuleId = this.getModuleId();
                boolean isFullPaymentsUpload = uploadType == 1;
                SormProjectUpload.Builder uploadBuilder = SormProjectUpload.newUploadBuilder(sormProject);
                if (isFullPaymentsUpload) {
                    uploadBuilder.fullUploadOnlyPayments();
                } else {
                    uploadBuilder.uploadOnlyPayments();
                }
                uploadBuilder.build().startUpload();
            }
            catch (BGException e) {
                logger.error(e.getMessage());
            }
        }
    }

    private List<SormProject> getActiveSormProjects() {
        try {
            ServerContext serverContext = (ServerContext)ServerContext.get();
            return ((SormService)serverContext.getService(SormService.class, this.getModuleId())).getActiveSormProject();
        }
        catch (BGException e) {
            logger.error(e.getMessage());
            return Collections.emptyList();
        }
    }

    public String getDescription() {
        return "\u0421\u041e\u0420\u041c. \u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432";
    }
}

