/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client;

import bitel.billing.module.common.BGControlPanelMonth;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.client.VoiceSourceManagerPanel;
import ru.bitel.bgbilling.modules.voice.common.bean.DataProcessRecord;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDevice;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceProcessLog;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceDeviceService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceLogManagementService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.Result;

public class VoiceLogPanel
extends BGUPanel {
    private static final String LOG_LOAD = "logLoad";
    protected BGControlPanelMonth monthPanel = new BGControlPanelMonth((Border)new CompoundBorder((Border)new BGTitleBorder("\u041f\u0435\u0440\u0438\u043e\u0434"), new EmptyBorder(0, 5, 5, 5)));
    private JPanel devicePanel;
    BGUList<VoiceDevice> deviceList = new BGUList();
    private VoiceSourceManagerPanel sourcePanel;
    private JCheckBox jcbLoad = new JCheckBox();
    private JCheckBox jcbInProcess = new JCheckBox();
    protected JCheckBox jcbProcessed = new JCheckBox();
    VoiceLogManagementService logService = (VoiceLogManagementService)((ClientContext)this.getContext()).getPort(VoiceLogManagementService.class);
    VoiceDeviceService deviceService = (VoiceDeviceService)((ClientContext)this.getContext()).getPort(VoiceDeviceService.class);
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            VoiceDevice selectedDevice = (VoiceDevice)VoiceLogPanel.this.deviceList.getSelectedValue();
            DefaultListModel deviceModel = new DefaultListModel();
            VoiceLogPanel.this.deviceList.setModel(deviceModel);
            VoiceLogPanel.this.deviceList.setData(VoiceLogPanel.this.getDeviceList());
            if (selectedDevice != null) {
                VoiceLogPanel.this.deviceList.setSelectedValue((Object)selectedDevice, true);
            }
            VoiceLogPanel.this.performAction(VoiceLogPanel.LOG_LOAD);
        }
    };
    AbstractBGUPanel.AsyncAction<int[]> asyncLogLoadAction = new AbstractBGUPanel.AsyncAction<int[]>("logLoad", "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043b\u043e\u0433\u043e\u0432"){
        private VoiceDevice selectedDevice;
        private int[] exists;
        {
            this.exists = new int[32];
        }

        protected void done(int[] result) throws Exception {
            this.exists = result;
            if (this.selectedDevice == null) {
                return;
            }
            if (VoiceLogPanel.this.jcbLoad.isSelected() && this.exists == null) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430. \u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043d\u0430\u043b\u0438\u0447\u0438\u0438 \u043b\u043e\u0433\u043e\u0432 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
            }
            int[][] values = new int[][]{this.exists == null ? new int[31] : this.exists, VoiceLogPanel.this.getIsLoading(this.selectedDevice), VoiceLogPanel.this.getLoaded(this.selectedDevice)};
            VoiceLogPanel.this.sourcePanel.setViewMode(new boolean[]{VoiceLogPanel.this.jcbLoad.isSelected(), VoiceLogPanel.this.jcbInProcess.isSelected(), VoiceLogPanel.this.jcbProcessed.isSelected()});
            VoiceLogPanel.this.sourcePanel.setData(values, new int[32], VoiceLogPanel.this.monthPanel.getLocalDate().lengthOfMonth());
        }

        protected int[] doInBackground() throws Exception {
            this.selectedDevice = (VoiceDevice)VoiceLogPanel.this.deviceList.getSelectedValue();
            if (this.selectedDevice == null) {
                return null;
            }
            if (VoiceLogPanel.this.jcbLoad.isSelected()) {
                this.exists = VoiceLogPanel.this.getLogExist(this.selectedDevice);
            }
            return this.exists;
        }
    };

    protected void jbInit() throws Exception {
        this.devicePanel = this.createDevicePanel();
        this.devicePanel.setBorder((Border)new BGTitleBorder("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430"));
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.add((Component)this.monthPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        leftPanel.add((Component)this.devicePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)leftPanel, (Component)this.createRightPanel(), 400L), "Center");
        this.monthPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("date")) {
                    VoiceDevice device = (VoiceDevice)VoiceLogPanel.this.deviceList.getSelectedValue();
                    if (device == null) {
                        ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e!");
                        return;
                    }
                    VoiceLogPanel.this.performAction(VoiceLogPanel.LOG_LOAD);
                }
            }
        });
    }

    private JPanel createDevicePanel() {
        JPanel devicePanel = new JPanel(new GridBagLayout());
        devicePanel.add((Component)new JScrollPane((Component)this.deviceList), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.deviceList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                VoiceDevice device = (VoiceDevice)VoiceLogPanel.this.deviceList.getSelectedValue();
                if (device == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e!");
                    return;
                }
                VoiceLogPanel.this.performAction(VoiceLogPanel.LOG_LOAD);
            }
        });
        return devicePanel;
    }

    protected JPanel createRightPanel() {
        int[] colors = new int[]{Color.RED.getRGB(), Color.GREEN.getRGB(), Color.BLUE.getRGB()};
        this.sourcePanel = new VoiceSourceManagerPanel(3, colors);
        this.sourcePanel.addMenuItem("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0443 (\u0442\u0435\u043a\u0443\u0449\u0435\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e)", "proccess");
        this.sourcePanel.addMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0438\u0437 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 (\u0442\u0435\u043a\u0443\u0449\u0435\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e)", "deleteProccess");
        this.sourcePanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                VoiceLogPanel.this.command(e.getPropertyName());
            }
        });
        ActionListener actionViewMode = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VoiceDevice device = (VoiceDevice)VoiceLogPanel.this.deviceList.getSelectedValue();
                if (device == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e!");
                    return;
                }
                VoiceLogPanel.this.performAction(VoiceLogPanel.LOG_LOAD);
            }
        };
        this.jcbLoad.setText("\u0415\u0441\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435");
        this.jcbLoad.setSelected(true);
        this.jcbLoad.addActionListener(actionViewMode);
        this.jcbInProcess.setText("\u0412 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435");
        this.jcbInProcess.setSelected(true);
        this.jcbInProcess.addActionListener(actionViewMode);
        this.jcbProcessed.setText("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d");
        this.jcbProcessed.setSelected(true);
        this.jcbProcessed.addActionListener(actionViewMode);
        JPanel checkBoxPanel = new JPanel(new GridBagLayout());
        checkBoxPanel.add((Component)this.jcbLoad, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        checkBoxPanel.add((Component)this.jcbInProcess, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        checkBoxPanel.add((Component)this.jcbProcessed, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)((Object)this.sourcePanel), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)checkBoxPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    protected List<VoiceDevice> getDeviceList() throws BGException {
        return this.deviceService.voiceDeviceSourceList();
    }

    private void command(String command) {
        try {
            if (!command.equals("proccess") && !command.equals("deleteProccess")) {
                return;
            }
            List days = this.sourcePanel.getSelectedDays(TimeUtils.convertLocalDateTimeToCalendar((LocalDateTime)this.monthPanel.getLocalDate().atStartOfDay()));
            VoiceDevice device = (VoiceDevice)this.deviceList.getSelectedValue();
            if (device == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e!");
                return;
            }
            if (command.equals("proccess")) {
                this.addLogsToProcess(days, device);
            } else if (command.equals("deleteProccess")) {
                this.logService.voiceDeleteProcessLogs(Integer.valueOf(device.getId()), days);
            }
            this.performAction(LOG_LOAD);
        }
        catch (BGException e) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), e.getMessage());
        }
    }

    protected void addLogsToProcess(List<Date> days, VoiceDevice device) throws BGException {
        this.logService.voiceAddProcessLogs(Integer.valueOf(device.getId()), days);
    }

    public int[] getIsLoading(VoiceDevice selectedDevice) throws BGException {
        int[] isLoading = new int[31];
        for (DataProcessRecord log : this.logService.voiceLogLoading(Integer.valueOf(selectedDevice.getId()), TimeUtils.convertLocalDateToDate((LocalDate)this.monthPanel.getLocalDate()))) {
            Date day = log.getDay();
            int d = TimeUtils.convertDateToCalendar((Date)day).get(5);
            int h = log.getCurrentHour();
            int n = d - 1;
            isLoading[n] = isLoading[n] | 1 << h;
            for (int i = h; i < 24; ++i) {
                int n2 = d - 1;
                isLoading[n2] = isLoading[n2] | 1 << i;
            }
        }
        return isLoading;
    }

    public int[] getLoaded(VoiceDevice selectedDevice) throws BGException {
        int[] isLoaded = new int[31];
        for (VoiceProcessLog log : this.logService.voiceLogLoaded(Integer.valueOf(selectedDevice.getId()), TimeUtils.convertLocalDateToDate((LocalDate)this.monthPanel.getLocalDate()))) {
            Date day = log.getDay();
            int d = TimeUtils.convertDateToCalendar((Date)day).get(5);
            isLoaded[d - 1] = 0xFFFFFF;
        }
        return isLoaded;
    }

    protected int[] getLogExist(VoiceDevice selectedDevice) throws BGException {
        Result result = this.logService.voiceLogExist(Integer.valueOf(selectedDevice.getId()), TimeUtils.convertLocalDateToDate((LocalDate)this.monthPanel.getLocalDate()));
        return (int[])result.getAttribute("logExists");
    }
}

