/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.directory.geocode;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;
import javax.xml.ws.Holder;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.client.directory.geocode.VoiceGeographicCodeExportPanel;
import ru.bitel.bgbilling.modules.voice.client.directory.geocode.VoiceGeographicCodeImportPanel;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDestination;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperator;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceDestinationService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceGeographicCodeService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceOperatorService;
import ru.bitel.bgbilling.modules.voice.common.utils.VoiceCommonUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.treetable.BGTreeTableModel;

public class VoiceGeographicCodePanel
extends BGUPanel {
    private static final String ACTION_FILTER = "filter";
    private BGUTreeTable codeTable;
    private VoiceGeographicCodeTreeTableModel codeModel;
    private BGTextField codeDestinationFilter;
    private VoiceGeographicCode root = null;
    private VoiceGeographicCodeImportPanel importPanel;
    private VoiceGeographicCodeExportPanel exportPanel;
    private VoiceOperatorService operatorService;
    private VoiceGeographicCodeService geographicCodeService;
    private TreePath[] currentSelectionPaths;
    private TreePath currentSelectionPath;
    private BGUComboBox<VoiceOperator> operators = new BGUComboBox();

    public VoiceGeographicCodePanel(ClientContext context) {
        super((LayoutManager)new GridBagLayout(), context);
    }

    protected void jbInit() throws Exception {
        JPanel operPanel = new JPanel(new GridBagLayout());
        operPanel.add((Component)this.operators, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        CardLayout cardLayout = new CardLayout();
        JPanel cardPanel = new JPanel(cardLayout);
        cardPanel.add((Component)this.getMainPanel(), "main");
        cardPanel.add((Component)new JPanel(), "empty");
        this.add(BGSwingUtilites.wrapBorder((JPanel)operPanel, (String)"\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.add(cardPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        this.operators.addItemListener(a -> {
            if (a.getStateChange() == 1) {
                VoiceOperator oper = (VoiceOperator)this.operators.getSelectedItem();
                cardLayout.show(cardPanel, oper.getId() == 0 || oper.isUseCustomGeoDict() ? "main" : "empty");
                this.loadCodeTree();
            }
        });
    }

    private JPanel getMainPanel() {
        this.codeModel = new VoiceGeographicCodeTreeTableModel();
        this.codeTable = new BGUTreeTable((BGTreeTableModel)this.codeModel);
        this.codeTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    VoiceGeographicCodePanel.this.performAction("editItem");
                }
            }
        });
        this.importPanel = new VoiceGeographicCodeImportPanel(this);
        BGSwingUtilites.wrapBorder((JPanel)((Object)this.importPanel), (String)"\u041e\u043f\u0446\u0438\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u0430");
        this.importPanel.setVisible(false);
        this.exportPanel = new VoiceGeographicCodeExportPanel(this);
        BGSwingUtilites.wrapBorder((JPanel)((Object)this.exportPanel), (String)"\u041e\u043f\u0446\u0438\u0438 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430");
        this.exportPanel.setVisible(false);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 3, 3), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.codeTable), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        panel.add((Component)((Object)this.importPanel), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 3, 3), 0, 0));
        panel.add((Component)((Object)this.exportPanel), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getFilterPanel() {
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setDefaultButtons(e -> this.performAction(e.getActionCommand()));
        toolBar.setToolBar(Arrays.asList("newItem", "editItem", "deleteItem", "deleteAllItem", "separator", "import", "export"));
        toolBar.setFloatable(false);
        this.codeDestinationFilter = new BGTextField(20);
        this.codeDestinationFilter.setPromptText("\u0444\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u043a\u043e\u0434\u0443", true, true);
        this.codeDestinationFilter.addPropertyChangeListener((PropertyChangeListener)new GeocodeFilterCaretListener());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)toolBar, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
        panel.add((Component)this.codeDestinationFilter, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 20, 0, 3), 0, 0));
        return panel;
    }

    public BGTreeTableModel<VoiceGeographicCode> getCodeTableModel() {
        return this.codeModel;
    }

    private void refreshOperators() throws BGException {
        int selectedIndex = this.operators.getSelectedIndex();
        if (selectedIndex <= 0) {
            selectedIndex = 0;
        }
        List operList = this.getVoiceOperatorService().voiceOperatorList();
        operList.add(0, new VoiceOperator(0, "\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e"));
        this.operators.setData(operList);
        if (selectedIndex < this.operators.getItemCount()) {
            this.operators.setSelectedIndex(selectedIndex);
        }
    }

    private void loadCodeTree() {
        Holder holder = new Holder();
        try {
            this.getVoiceGeographicCodeService().getGeographicCodeTree(((VoiceOperator)this.operators.getSelectedItem()).getId(), holder);
            this.root = (VoiceGeographicCode)VoiceCommonUtils.readFromHolder((Holder)holder);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        if (this.root == null) {
            return;
        }
        this.codeModel.setData(this.root);
        if (this.currentSelectionPaths != null && this.currentSelectionPaths.length > 0) {
            for (TreePath treePath : this.currentSelectionPaths) {
                this.codeTable.makeVisible(treePath);
            }
            this.currentSelectionPaths = null;
        }
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceGeographicCodePanel.this.refreshOperators();
                VoiceGeographicCodePanel.this.loadCodeTree();
            }
        };
        new AbstractBGUPanel.DefaultAction("newItem", ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceGeographicCode parentVoiceGeographicCode = (VoiceGeographicCode)VoiceGeographicCodePanel.this.codeModel.getSelectedRow();
                if (parentVoiceGeographicCode == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u043a\u043e\u0434 \u0434\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c\u043e\u0433\u043e");
                    return;
                }
                VoiceGeographicCodePanel.this.currentSelectionPaths = VoiceGeographicCodePanel.this.codeTable.getSelectionPaths();
                VoiceGeographicCodePanel.this.currentSelectionPath = VoiceGeographicCodePanel.this.codeTable.getSelectionPath();
                VoiceGeographicCode voiceGeographicCode = new VoiceGeographicCode();
                voiceGeographicCode.setCode(parentVoiceGeographicCode != null ? parentVoiceGeographicCode.getCode() : "");
                voiceGeographicCode.setDestinationId(0);
                voiceGeographicCode.setDestinationTitle("");
                VoiceGeographicCodePanel.this.setVisibleBottomPanels(voiceGeographicCode, false, false);
            }
        };
        new AbstractBGUPanel.DefaultAction("editItem", ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                List selectedCodes = VoiceGeographicCodePanel.this.codeModel.getSelectedRows();
                if (selectedCodes == null || selectedCodes.size() != 1) {
                    BGToolTip.showErrorMessage((JComponent)VoiceGeographicCodePanel.this.codeTable, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 1 \u0433\u0435\u043e\u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043a\u043e\u0434 \u0432 \u0434\u0435\u0440\u0435\u0432\u0435!");
                    return;
                }
                VoiceGeographicCodePanel.this.currentSelectionPaths = VoiceGeographicCodePanel.this.codeTable.getSelectionPaths();
                VoiceGeographicCodePanel.this.currentSelectionPath = VoiceGeographicCodePanel.this.codeTable.getSelectionPath();
                VoiceGeographicCodePanel.this.setVisibleBottomPanels((VoiceGeographicCode)selectedCodes.get(0), false, false);
            }
        };
        new AbstractBGUPanel.DefaultAction("deleteItem", ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                List selectedCodeList = VoiceGeographicCodePanel.this.codeModel.getSelectedRows();
                if (selectedCodeList == null || selectedCodeList.isEmpty()) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0434\u0438\u043d \u0438\u043b\u0438 \u0431\u043e\u043b\u0435\u0435 \u0433\u0435\u043e\u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043a\u043e\u0434\u043e\u0432 \u0432 \u0434\u0435\u0440\u0435\u0432\u0435!");
                    return;
                }
                String confirmMessage = "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c " + (selectedCodeList.size() > 1 ? "\u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u043a\u043e\u0434\u044b" : "\u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u043a\u043e\u0434") + "?";
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), confirmMessage, "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                    List codeIdForDelete = selectedCodeList.stream().map(code -> code.getId()).collect(Collectors.toList());
                    VoiceGeographicCodePanel.this.getVoiceGeographicCodeService().deleteGeographicCode(codeIdForDelete);
                    TreePath[] deletedPaths = VoiceGeographicCodePanel.this.codeTable.getSelectionPaths();
                    VoiceGeographicCodePanel.this.currentSelectionPaths = new TreePath[deletedPaths.length];
                    for (int i = 0; i < deletedPaths.length; ++i) {
                        VoiceGeographicCodePanel.this.currentSelectionPaths[i] = deletedPaths[i].getParentPath();
                    }
                    VoiceGeographicCodePanel.this.loadCodeTree();
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("deleteAllItem", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u0435"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u0435 \u0434\u0435\u0440\u0435\u0432\u043e \u0433\u0435\u043e\u043a\u043e\u0434\u043e\u0432?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                    VoiceGeographicCodePanel.this.getVoiceGeographicCodeService().deleteAllGeographicCode(((VoiceOperator)VoiceGeographicCodePanel.this.operators.getSelectedItem()).getId());
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("import", ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceGeographicCodePanel.this.importPanel.performActionOpen();
                VoiceGeographicCodePanel.this.setVisibleBottomPanels(null, true, false);
            }
        };
        new AbstractBGUPanel.DefaultAction("export", ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceGeographicCodePanel.this.exportPanel.performActionOpen();
                VoiceGeographicCodePanel.this.setVisibleBottomPanels(null, false, true);
            }
        };
        new AbstractBGUPanel.DefaultAction(ACTION_FILTER, ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
            }
        };
    }

    public void setVisibleBottomPanels(VoiceGeographicCode voiceGeographicCode, boolean hideImport, boolean hideExport) {
        if (voiceGeographicCode != null) {
            new VoiceGeographicCodeEditor(voiceGeographicCode.getId() > 0 ? "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0433\u0435\u043e\u043a\u043e\u0434\u043e\u0432" : "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0433\u0435\u043e\u043a\u043e\u0434", voiceGeographicCode).getDialog().setVisible(true);
        }
        this.importPanel.setVisible(hideImport);
        this.exportPanel.setVisible(hideExport);
    }

    public int getOperatorId() {
        return ((VoiceOperator)this.operators.getSelectedItem()).getId();
    }

    private VoiceOperatorService getVoiceOperatorService() {
        if (this.operatorService == null) {
            this.operatorService = (VoiceOperatorService)((ClientContext)this.getContext()).getPort(VoiceOperatorService.class);
        }
        return this.operatorService;
    }

    private VoiceGeographicCodeService getVoiceGeographicCodeService() {
        if (this.geographicCodeService == null) {
            this.geographicCodeService = (VoiceGeographicCodeService)((ClientContext)this.getContext()).getPort(VoiceGeographicCodeService.class);
        }
        return this.geographicCodeService;
    }

    private void filterTree(String text, VoiceGeographicCode fromCode, VoiceGeographicCode toCode) {
        String code = fromCode.getCode();
        if (code.length() <= text.length() && code.equals(text.substring(0, code.length())) || code.length() >= text.length() && code.startsWith(text)) {
            VoiceGeographicCode copyCode = new VoiceGeographicCode();
            fromCode.copyTo(copyCode);
            toCode.addChild(copyCode);
            if (fromCode.getChildren() != null) {
                for (VoiceGeographicCode checkCode : fromCode.getChildren()) {
                    this.filterTree(text, checkCode, copyCode);
                }
            }
        }
    }

    class VoiceGeographicCodeTreeTableModel
    extends BGTreeTableModel<VoiceGeographicCode> {
        public VoiceGeographicCodeTreeTableModel() {
            super(VoiceGeographicCodeTreeTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041a\u043e\u0434", VoiceGeographicCode.class, -1, 300, 300, null, false);
            this.addColumn("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435", -1, -1, -1, "destinationTitle");
        }

        public Object getValue(VoiceGeographicCode val, int column) throws BGException {
            if (column == 0 && val == this.root) {
                return val.getTitle();
            }
            switch (column) {
                case 0: {
                    return val;
                }
            }
            return super.getValue((Object)val, column);
        }
    }

    private class GeocodeFilterCaretListener
    implements PropertyChangeListener {
        private GeocodeFilterCaretListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("textChange".equals(evt.getPropertyName())) {
                String filterText = VoiceGeographicCodePanel.this.codeDestinationFilter.getText();
                VoiceGeographicCode filterRoot = VoiceGeographicCodePanel.this.root;
                if (!filterText.isEmpty()) {
                    filterRoot = new VoiceGeographicCode();
                    VoiceGeographicCodePanel.this.root.copyTo(filterRoot);
                    for (VoiceGeographicCode checkCode : VoiceGeographicCodePanel.this.root.getChildren()) {
                        VoiceGeographicCodePanel.this.filterTree(filterText, checkCode, filterRoot);
                    }
                }
                VoiceGeographicCodePanel.this.codeModel.setData(filterRoot);
                VoiceGeographicCodePanel.this.codeTable.expand(filterText.length());
            }
        }
    }

    class VoiceGeographicCodeEditor
    extends BGEditorDialog<VoiceGeographicCode> {
        private final VoiceDestination NOT_SELECTED_DESTINATION_ITEM;
        private BGTextField code;
        private BGControlPanelPeriodNoB codePeriod;
        private BGUComboBox<VoiceDestination> destinations;
        private List<VoiceDestination> destinationList;
        private Map<Integer, VoiceDestination> destinationsMap;

        public VoiceGeographicCodeEditor(String title, VoiceGeographicCode data) {
            super(title, (Object)data);
            this.NOT_SELECTED_DESTINATION_ITEM = new VoiceDestination(-1, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e");
            this.code = new BGTextField();
            this.codePeriod = new BGControlPanelPeriodNoB();
            this.destinations = new BGUComboBox();
            this.destinationList = new ArrayList<VoiceDestination>();
            this.destinationsMap = new HashMap<Integer, VoiceDestination>();
        }

        public void doDialogPanel() {
            this.code.setHorizontalAlignment(0);
            this.code.setFont(this.code.getFont().deriveFont(this.code.getFont().getSize2D() * 1.5f));
            this.panel.add((Component)new JLabel("\u0413\u0435\u043e\u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043a\u043e\u0434:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            this.panel.add((Component)this.code, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 3, 3), 0, 0));
            this.panel.add((Component)new JLabel("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            this.panel.add((Component)this.destinations, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 3, 3), 0, 0));
            this.loadDestinations();
            this.destinations.setData(this.destinationList);
            this.destinations.setSelectedItem((Object)this.NOT_SELECTED_DESTINATION_ITEM);
            this.code.setText(((VoiceGeographicCode)this.data).getCode());
            this.code.setEnabled(((VoiceGeographicCode)this.data).getId() == 0);
            this.codePeriod.setDateFrom(((VoiceGeographicCode)this.data).getDateFrom());
            this.codePeriod.setDateTo(((VoiceGeographicCode)this.data).getDateTo());
            try {
                this.destinations.setSelectedItem((Object)((VoiceDestinationService)((ClientContext)VoiceGeographicCodePanel.this.getContext()).getWebService(VoiceDestinationService.class)).voiceDestinationGet(((VoiceGeographicCode)this.data).getDestinationId()));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        public boolean doApply() throws Exception {
            String codeString = this.code.getText();
            if (Utils.isBlankString((String)codeString)) {
                BGToolTip.showErrorMessage((JComponent)this.code, (String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u0435\u043e\u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0430!");
                return false;
            }
            VoiceDestination selectedDestination = (VoiceDestination)this.destinations.getSelectedItem();
            if (selectedDestination == null || selectedDestination.equals((Object)this.NOT_SELECTED_DESTINATION_ITEM)) {
                BGToolTip.showErrorMessage(this.destinations, (String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435!");
                return false;
            }
            ((VoiceGeographicCode)this.data).setCode(codeString);
            ((VoiceGeographicCode)this.data).setOperatorId(VoiceGeographicCodePanel.this.getOperatorId());
            ((VoiceGeographicCode)this.data).setDestinationId(((VoiceDestination)this.destinations.getSelectedItem()).getId());
            ((VoiceGeographicCode)this.data).setDestinationTitle(this.destinationsMap.get(((VoiceGeographicCode)this.data).getDestinationId()).getTitle());
            ((VoiceGeographicCode)this.data).setDateFrom(this.codePeriod.getDateFrom());
            ((VoiceGeographicCode)this.data).setDateTo(this.codePeriod.getDateTo());
            int id = ((VoiceGeographicCodeService)((ClientContext)VoiceGeographicCodePanel.this.getContext()).getWebService(VoiceGeographicCodeService.class)).updateGeographicCode((VoiceGeographicCode)this.data);
            if (((VoiceGeographicCode)this.data).getId() == 0) {
                VoiceGeographicCodePanel.this.loadCodeTree();
            }
            ((VoiceGeographicCode)this.data).setId(id);
            VoiceGeographicCodePanel.this.codeModel.fireTableDataChanged();
            VoiceGeographicCodePanel.this.codeTable.makeVisible(VoiceGeographicCodePanel.this.currentSelectionPath);
            return true;
        }

        void loadDestinations() {
            try {
                Holder data = new Holder();
                this.destinationList.clear();
                this.destinationsMap.clear();
                ((VoiceDestinationService)((ClientContext)VoiceGeographicCodePanel.this.getContext()).getWebService(VoiceDestinationService.class)).voiceDestinationList(VoiceGeographicCodePanel.this.getOperatorId(), null, null, data);
                this.destinationList = (List)VoiceCommonUtils.readFromHolder((Holder)data);
                if (this.destinationList != null && !this.destinationList.isEmpty()) {
                    this.destinationsMap = VoiceDestination.getDestinationMap(this.destinationList);
                    this.destinationList.add(0, this.NOT_SELECTED_DESTINATION_ITEM);
                    return;
                }
            }
            catch (IOException | ClassNotFoundException | BGException e) {
                VoiceGeographicCodePanel.this.processException(e);
            }
        }
    }
}

