/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.directory.zonemap;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGSelectFilePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.xml.ws.Holder;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleEditorDialog;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.voice.client.directory.zonemap.VoiceZoneMapPanel;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZone;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZoneMap;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZoneMapItem;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceGeographicCodeService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceZoneMapService;
import ru.bitel.bgbilling.modules.voice.common.utils.VoiceCommonUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.common.model.IdTitle;

public class VoiceZoneMapEditorForm
extends BGUPanel {
    private BGTextField zoneMapTitle = new BGTextField(50);
    private BGTextField comment = new BGTextField();
    protected ZoneMapTreeTableModel zoneMapItemModel;
    private BGUTreeTable zoneMapTable;
    private Directory<VoiceZone> zoneDrectory;
    private VoiceZoneMapService voiceZoneMapService;
    private final VoiceZoneMapPanel parentPanel;
    private final BGEditor bgEditor;
    private VoiceZoneMap currentZoneMap;
    private BGDialogToolBar toolBar;

    public VoiceZoneMapEditorForm(BGEditor bgEditor, VoiceZoneMapPanel parentPanel) {
        this.bgEditor = bgEditor;
        this.parentPanel = parentPanel;
    }

    protected void jbInit() throws Exception {
        this.zoneDrectory = ((ClientContext)this.getContext()).getDirectory(VoiceZone.class);
        this.zoneMapItemModel = new ZoneMapTreeTableModel(ZoneMapTreeTableModel.class.getName());
        this.zoneMapTable = new BGUTreeTable((BGTreeTableModel)this.zoneMapItemModel);
        AbstractAction newItem = new AbstractAction("newItem", ClientUtils.getIcon((String)"item_add")){

            @Override
            public void actionPerformed(ActionEvent e) {
                VoiceZoneMapItem voiceZoneMapItem = new VoiceZoneMapItem();
                voiceZoneMapItem.setMapId(VoiceZoneMapEditorForm.this.currentZoneMap.getId());
                new VoiceZoneMapItemDialog("\u041d\u043e\u0432\u0430\u044f \u0437\u0430\u043f\u0438\u0441\u044c", voiceZoneMapItem).getDialog().setVisible(true);
                try {
                    VoiceZoneMapEditorForm.this.loadZoneMapData();
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        };
        AbstractAction editItem = new AbstractAction("editItem", ClientUtils.getIcon((String)"item_edit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                VoiceZoneMapItem voiceZoneMapItem = (VoiceZoneMapItem)VoiceZoneMapEditorForm.this.zoneMapItemModel.getSelectedRow();
                if (voiceZoneMapItem == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                    return;
                }
                new VoiceZoneMapItemDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0437\u0430\u043f\u0438\u0441\u0438", voiceZoneMapItem).getDialog().setVisible(true);
                try {
                    VoiceZoneMapEditorForm.this.loadZoneMapData();
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        };
        AbstractAction deleteItem = new AbstractAction("deleteItem", ClientUtils.getIcon((String)"item_delete")){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selected = VoiceZoneMapEditorForm.this.zoneMapItemModel.getSelectedRows();
                if (selected == null) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                } else if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435?") == 0) {
                    try {
                        VoiceZoneMapEditorForm.this.getVoiceZoneMapService().voiceZoneMapItemDelete(selected.stream().map(i -> i.getId()).collect(Collectors.toList()));
                        VoiceZoneMapEditorForm.this.loadZoneMapData();
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            }
        };
        AbstractAction importItem = new AbstractAction("import", ClientUtils.getIcon((String)"import")){

            @Override
            public void actionPerformed(ActionEvent e) {
                new VoiceZoneMapImportDialog("\u0418\u043c\u043f\u043e\u0440\u0442 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u0437\u043e\u043d", VoiceZoneMapEditorForm.this.currentZoneMap).getDialog().setVisible(true);
                try {
                    VoiceZoneMapEditorForm.this.loadZoneMapData();
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        };
        this.toolBar = new BGDialogToolBar();
        this.toolBar.add((Action)newItem);
        this.toolBar.add((Action)editItem);
        this.toolBar.add((Action)deleteItem);
        this.toolBar.addSeparator();
        this.toolBar.add((Action)importItem);
        this.setLayout(new GridBagLayout());
        this.add(this.getTopPanel(this.toolBar), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(3, 3, 3, 3), 0, 0));
        BGSwingUtilites.wrapBorder((JPanel)((Object)this), (String)" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 ");
        this.toolBar.compact();
    }

    private VoiceZoneMapService getVoiceZoneMapService() {
        if (this.voiceZoneMapService == null) {
            this.voiceZoneMapService = (VoiceZoneMapService)((ClientContext)this.getContext()).getPort(VoiceZoneMapService.class);
        }
        return this.voiceZoneMapService;
    }

    private JPanel getTopPanel(BGDialogToolBar toolBar) {
        Color bgColor = this.zoneMapTitle.getBackground();
        this.zoneMapTitle.setEditable(false);
        this.zoneMapTitle.setBackground(bgColor);
        this.comment.setEditable(false);
        this.comment.setBackground(bgColor);
        JButton zoneMapTitleEditButton = new JButton(ClientUtils.getIcon((String)"edit"));
        zoneMapTitleEditButton.addActionListener(e -> new TitleEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f", this.currentZoneMap).getDialog().setVisible(true));
        JButton zoneMapCommentEditButton = new JButton(ClientUtils.getIcon((String)"edit"));
        zoneMapCommentEditButton.addActionListener(e -> new CommentEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f", this.currentZoneMap).getDialog().setVisible(true));
        JPanel hPanel = new JPanel(new GridBagLayout());
        hPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 3, 0, 3), 0, 0));
        hPanel.add((Component)this.zoneMapTitle, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        hPanel.add((Component)zoneMapTitleEditButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        hPanel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 20, 0, 3), 0, 0));
        hPanel.add((Component)this.comment, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        hPanel.add((Component)zoneMapCommentEditButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)hPanel, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 3), 0, 0));
        panel.add((Component)toolBar, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.zoneMapTable), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        return panel;
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("new", "\u041d\u043e\u0432\u044b\u0439"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (VoiceZoneMapEditorForm.this.getParent().isVisible()) {
                    ClientUtils.showErrorMessageDialog((String)"\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
                    return;
                }
                VoiceZoneMapEditorForm.this.currentZoneMap = new VoiceZoneMap();
                new NewVoiceZoneMapDialog("\u041d\u043e\u0432\u0430\u044f \u043a\u0430\u0440\u0442\u0430 \u0437\u043e\u043d", VoiceZoneMapEditorForm.this.currentZoneMap).getDialog().setVisible(true);
                if (VoiceZoneMapEditorForm.this.currentZoneMap.getId() > 0) {
                    VoiceZoneMapEditorForm.this.zoneMapTitle.setText(VoiceZoneMapEditorForm.this.currentZoneMap.getTitle());
                    VoiceZoneMapEditorForm.this.comment.setText(VoiceZoneMapEditorForm.this.currentZoneMap.getComment());
                    VoiceZoneMapItem emptyRoot = new VoiceZoneMapItem();
                    emptyRoot.setTitle("\u0414\u0435\u0440\u0435\u0432\u043e \u043a\u043e\u0434\u043e\u0432");
                    VoiceZoneMapEditorForm.this.zoneMapItemModel.setData(emptyRoot);
                    VoiceZoneMapEditorForm.this.performActionOpen();
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (VoiceZoneMapEditorForm.this.getParent().isVisible()) {
                    ClientUtils.showErrorMessageDialog((String)"\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
                    return;
                }
                VoiceZoneMapEditorForm.this.currentZoneMap = (VoiceZoneMap)VoiceZoneMapEditorForm.this.parentPanel.zoneMapTableModel.getSelectedRow();
                if (VoiceZoneMapEditorForm.this.currentZoneMap == null) {
                    return;
                }
                VoiceZoneMapEditorForm.this.zoneMapTitle.setText(VoiceZoneMapEditorForm.this.currentZoneMap.getTitle());
                VoiceZoneMapEditorForm.this.comment.setText(VoiceZoneMapEditorForm.this.currentZoneMap.getComment());
                VoiceZoneMapEditorForm.this.loadZoneMapData();
                VoiceZoneMapEditorForm.this.performActionOpen();
            }
        };
        new AbstractBGUPanel.DefaultAction("close", "\u0417\u0430\u043a\u0440\u044b\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceZoneMapEditorForm.this.bgEditor.getActionMap().get("close").actionPerformed(e);
            }
        };
    }

    void loadZoneMapData() throws BGException, IOException, ClassNotFoundException {
        Holder items = new Holder();
        this.getVoiceZoneMapService().voiceZoneMapItemTree(this.currentZoneMap.getId(), items);
        VoiceZoneMapItem root = (VoiceZoneMapItem)VoiceCommonUtils.readFromHolder((Holder)items);
        if (root == null) {
            return;
        }
        this.zoneMapItemModel.setData(root);
    }

    class ZoneMapTreeTableModel
    extends BGTreeTableModel<VoiceZoneMapItem> {
        public ZoneMapTreeTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u041a\u043e\u0434", VoiceGeographicCode.class, 200, 200, 200, "code", false);
            this.addColumn("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435", -1, -1, -1, "destinationTitle").setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043e\u043d\u0430", -1, -1, -1, "zoneId").setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(VoiceZoneMapItem val, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("code".equals(identifier) && val == this.root) {
                return val.getTitle();
            }
            if ("zoneId".equals(identifier)) {
                VoiceZone zone = (VoiceZone)VoiceZoneMapEditorForm.this.zoneDrectory.get(val.getZoneId());
                return zone != null ? zone.getTitle() : null;
            }
            return super.getValue((Object)val, column);
        }
    }

    class CommentEditor
    extends BGTitleEditorDialog<VoiceZoneMap> {
        public CommentEditor(String title, VoiceZoneMap data) {
            super(title, (IdTitle)data, "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", true);
        }

        protected void titleSetText() {
            this.title.setText(((VoiceZoneMap)this.data).getComment());
        }

        protected void dataSetTitle() {
            ((VoiceZoneMap)this.data).setComment(this.title.getText());
        }

        protected void doUpdate() throws Exception {
            VoiceZoneMapEditorForm.this.getVoiceZoneMapService().voiceZoneMapUpdate((VoiceZoneMap)this.data);
            VoiceZoneMapEditorForm.this.comment.setText(this.title.getText());
        }
    }

    class TitleEditor
    extends BGTitleEditorDialog<VoiceZoneMap> {
        public TitleEditor(String title, VoiceZoneMap data) {
            super(title, (IdTitle)data);
        }

        protected void titleSetText() {
            this.title.setText(((VoiceZoneMap)this.data).getTitle());
        }

        protected void dataSetTitle() {
            ((VoiceZoneMap)this.data).setTitle(this.title.getText());
        }

        protected void doUpdate() throws Exception {
            VoiceZoneMapEditorForm.this.getVoiceZoneMapService().voiceZoneMapUpdate((VoiceZoneMap)this.data);
            VoiceZoneMapEditorForm.this.zoneMapTitle.setText(this.title.getText());
        }
    }

    class VoiceZoneMapImportDialog
    extends BGEditorDialog<VoiceZoneMap> {
        private JTabbedPane tabbedPane;
        private JTextArea importContent;
        private BGSelectFilePanel file;

        public VoiceZoneMapImportDialog(String title, VoiceZoneMap data) {
            super(title, (Object)data);
            this.tabbedPane = new JTabbedPane();
            this.importContent = new JTextArea(20, 50);
            this.file = new BGSelectFilePanel(false);
        }

        public void doDialogPanel() {
            this.tabbedPane.add((Component)this.getTextPanel(), "\u0418\u043c\u043f\u043e\u0440\u0442 \u0438\u0437 \u0442\u0435\u043a\u0441\u0442\u0430");
            this.tabbedPane.add((Component)this.getFilePanel(), "\u0418\u043c\u043f\u043e\u0440\u0442 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430");
            this.panel.add((Component)this.tabbedPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0424\u043e\u0440\u043c\u0430\u0442 \u0441\u0442\u0440\u043e\u043a: \u041a\u041e\u0414<TAB>\u041d\u0410\u0417\u0412\u0410\u041d\u0418\u0415_\u0417\u041e\u041d\u042b"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(15, 5, 15, 0), 0, 0));
        }

        private JPanel getTextPanel() {
            this.importContent.setMargin(new Insets(3, 3, 3, 3));
            JScrollPane scrollPane = new JScrollPane(this.importContent);
            int gridy = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            panel.add((Component)scrollPane, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 1, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getFilePanel() {
            int gridy = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0424\u0430\u0439\u043b:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.file, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 5, 0, 5), 0, 0));
            panel.add(Box.createGlue(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            return panel;
        }

        public boolean doApply() throws Exception {
            File file;
            int index = this.tabbedPane.getSelectedIndex();
            if (index == 0) {
                if (Utils.isBlankString((String)this.importContent.getText())) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0442\u0435\u043a\u0441\u0442!");
                    return false;
                }
            } else if (index == 1 && (file = this.file.getSelectedFile()) == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b!");
                return false;
            }
            this.loadData(index);
            return true;
        }

        private void loadData(final int index) {
            Holder content = new Holder();
            content.value = new DataHandler(new DataSource(){

                public OutputStream getOutputStream() throws IOException {
                    return null;
                }

                public String getName() {
                    return null;
                }

                public InputStream getInputStream() throws IOException {
                    if (index == 0) {
                        byte[] bytes = null;
                        try {
                            bytes = VoiceZoneMapImportDialog.this.importContent.getText().getBytes("utf-8");
                        }
                        catch (Exception e) {
                            ClientUtils.showErrorMessageDialog((Throwable)e);
                        }
                        return new ByteArrayInputStream(bytes);
                    }
                    if (index == 1) {
                        try (FileInputStream fis = new FileInputStream(VoiceZoneMapImportDialog.this.file.getSelectedFile());){
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Utils.readByBlock((InputStream)fis));
                            return byteArrayInputStream;
                        }
                    }
                    return null;
                }

                public String getContentType() {
                    return "application/octet-stream";
                }
            });
            try {
                String result = VoiceZoneMapEditorForm.this.getVoiceZoneMapService().importZoneMap(VoiceZoneMapEditorForm.this.currentZoneMap.getId(), index, content);
                if (result != null && !result.isEmpty()) {
                    ClientUtils.showScrollMessageDialog((String)result, (String)"\u041e\u0448\u0438\u0431\u043a\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u0430");
                }
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }
    }

    class VoiceZoneMapItemDialog
    extends BGEditorDialog<VoiceZoneMapItem> {
        private BGComboBox<VoiceGeographicCode> codeCombobox;
        private BGUComboBox<VoiceZone> zoneCombobox;
        private final VoiceGeographicCode NOT_SELECTED_ITEM;

        public VoiceZoneMapItemDialog(String title, VoiceZoneMapItem data) {
            super(title, (Object)data);
            this.NOT_SELECTED_ITEM = new VoiceGeographicCode(-1, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e");
        }

        public void doDialogPanel() {
            this.codeCombobox = new BGComboBox();
            this.codeCombobox.setEnabled(((VoiceZoneMapItem)this.data).getId() == 0);
            this.zoneCombobox = new BGUComboBox();
            int gridy = 0;
            this.panel.add((Component)new JLabel("\u041a\u043e\u0434"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            this.panel.add((Component)this.codeCombobox, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 3, 3), 0, 0));
            this.panel.add((Component)new JLabel("\u0417\u043e\u043d\u0430"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 3, 3), 0, 0));
            this.panel.add((Component)this.zoneCombobox, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 3, 3), 0, 0));
            try {
                this.loadGeocodes();
                this.codeCombobox.setSelectedItem((Object)new VoiceGeographicCode(((VoiceZoneMapItem)this.data).getCodeId(), null));
                this.zoneCombobox.setSelectedItem((Object)((VoiceZoneMapItem)this.data).getZoneId());
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }

        public boolean doApply() throws Exception {
            VoiceZone zone = (VoiceZone)this.zoneCombobox.getSelectedItem();
            if (zone != null) {
                ((VoiceZoneMapItem)this.data).setZoneId(zone.getId());
            }
            if (((VoiceZoneMapItem)this.data).getId() == 0) {
                VoiceGeographicCode selectedGeocode = (VoiceGeographicCode)this.codeCombobox.getSelectedItem();
                if (selectedGeocode == null || selectedGeocode.equals((Object)this.NOT_SELECTED_ITEM)) {
                    BGToolTip.showErrorMessage(this.codeCombobox, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0433\u0435\u043e\u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043a\u043e\u0434 \u0438\u0437 \u0432\u044b\u043f\u0430\u0434\u0430\u044e\u0449\u0435\u0433\u043e \u0441\u043f\u0438\u0441\u043a\u0430!");
                    return false;
                }
                ((VoiceZoneMapItem)this.data).setCodeId(selectedGeocode.getId());
            }
            VoiceZoneMapEditorForm.this.getVoiceZoneMapService().voiceZoneMapItemUpdate((VoiceZoneMapItem)this.data);
            return true;
        }

        public JDialog getDialog() {
            JDialog dialog = super.getDialog();
            dialog.setMinimumSize(new Dimension(600, 100));
            dialog.setLocationRelativeTo(JOptionPane.getRootFrame());
            return dialog;
        }

        private void loadGeocodes() throws BGException, ClassNotFoundException, IOException {
            Directory zoneDrectory = ((ClientContext)VoiceZoneMapEditorForm.this.getContext()).getDirectory(VoiceZone.class);
            VoiceGeographicCodeService geocodeService = (VoiceGeographicCodeService)((ClientContext)VoiceZoneMapEditorForm.this.getContext()).getPort(VoiceGeographicCodeService.class);
            Holder holder = new Holder();
            geocodeService.getGeographicCodeTree(0, holder);
            VoiceGeographicCode root = (VoiceGeographicCode)VoiceCommonUtils.readFromHolder((Holder)holder);
            List codeList = root.toList();
            codeList.stream().forEach(n -> {
                n.setTitle(n.getCode() + " - " + n.getDestinationTitle());
                n.setCode(null);
                n.setDestinationTitle(null);
            });
            codeList.add(0, this.NOT_SELECTED_ITEM);
            this.codeCombobox.setModel(new DefaultComboBoxModel<VoiceGeographicCode>(codeList.toArray(new VoiceGeographicCode[0])));
            this.zoneCombobox.setData(zoneDrectory.list());
        }
    }

    class NewVoiceZoneMapDialog
    extends BGEditorDialog<VoiceZoneMap> {
        private JTextField title;
        private JTextField comment;

        public NewVoiceZoneMapDialog(String title, VoiceZoneMap voiceZoneMap) {
            super(title, (Object)voiceZoneMap);
            this.title = new JTextField(50);
            this.comment = new JTextField(50);
        }

        public void doDialogPanel() {
            int gridy = 0;
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.comment, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 10, 0), 0, 0));
            this.title.setText(((VoiceZoneMap)this.data).getTitle());
            this.comment.setText(((VoiceZoneMap)this.data).getComment());
        }

        public boolean doApply() throws Exception {
            String mapTitle = this.title.getText();
            if (Utils.isBlankString((String)mapTitle)) {
                BGToolTip.showErrorMessage((JComponent)this.title, (String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u0430\u0440\u0442\u044b \u0437\u043e\u043d!");
                return false;
            }
            ((VoiceZoneMap)this.data).setTitle(mapTitle);
            ((VoiceZoneMap)this.data).setComment(this.comment.getText());
            ((VoiceZoneMap)this.data).setId(VoiceZoneMapEditorForm.this.getVoiceZoneMapService().voiceZoneMapUpdate((VoiceZoneMap)this.data));
            return true;
        }
    }
}

