/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.AccessCodes;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAuthError;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.common.sql.ConnectionSet;

public class VoiceAuthErrorDao
extends AbstractIdDao<VoiceAuthError> {
    private ConnectionSet connectionSet;

    public VoiceAuthErrorDao(ConnectionSet connectionSet, int moduleId, Date date) {
        super(connectionSet.getConnection(), moduleId, "voice_auth_error", date);
        this.connectionSet = connectionSet;
    }

    protected VoiceAuthError getFromRS(ResultSet rs) throws SQLException, BGException {
        VoiceAuthError error = new VoiceAuthError();
        error.setId(rs.getInt("id"));
        error.setDeviceId(rs.getInt("deviceId"));
        error.setDeviceTitle(rs.getString("deviceTitle"));
        error.setContractId(rs.getInt("contractId"));
        error.setContractTitle(rs.getString("contractTitle"));
        error.setAccountId(rs.getInt("accountId"));
        error.setAccountTitle(rs.getString("accountTitle"));
        error.setErrorCode(rs.getInt("code"));
        error.setErrorText(AccessCodes.toString((ParameterMap)Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)), (int)error.getErrorCode()));
        error.setLastErrorTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("lastTime")));
        error.setLogCoordinateRecordId(rs.getInt("logCoordinateRecordId"));
        return error;
    }

    protected void updateImpl(VoiceAuthError b) throws BGException, SQLException {
    }

    public void update(VoiceAuthError b) throws BGException {
        super.update((Object)b);
    }

    public void addError(VoiceAuthError error) throws BGException {
        Connection con = this.connectionSet.getTrashConnection(this.tableName, 1);
        try {
            Statement st = con.createStatement();
            if (!ServerUtils.tableExists((Connection)con, (String)this.tableName)) {
                StringBuilder sb = new StringBuilder(100).append("CREATE TABLE IF NOT EXISTS " + this.tableName + "(id INT AUTO_INCREMENT NOT NULL, deviceId INT NOT NULL,deviceTitle CHAR(15) NOT NULL,contractId INT(10) UNSIGNED NULL DEFAULT NULL, contractTitle CHAR(15) NOT NULL,accountId INT(11) NULL DEFAULT NULL,accountTitle CHAR(100) NULL DEFAULT NULL,code INT NOT NULL,lastTime DATETIME NOT NULL,logCoordinateRecordId INT NOT NULL,KEY id(id),KEY deviceId(deviceId),KEY lastTime(lastTime),KEY `time_dcsc` (`lastTime`,`deviceId`,`contractId`,`accountId`,`code`),CONSTRAINT `fk_" + this.tableName + "_account` FOREIGN KEY (`accountId`) REFERENCES `voice_account_base_" + this.moduleId + "` (`id`) ON UPDATE CASCADE ON DELETE CASCADE,CONSTRAINT `fk_" + this.tableName + "_contract` FOREIGN KEY (`contractId`) REFERENCES `contract` (`id`) ON UPDATE CASCADE ON DELETE CASCADE,CONSTRAINT `fk_" + this.tableName + "_device` FOREIGN KEY (`deviceId`) REFERENCES `voice_device_" + this.moduleId + "` (`id`) ON UPDATE CASCADE ON DELETE CASCADE )");
                st.executeUpdate(sb.toString());
            }
            st.close();
            long millis = System.currentTimeMillis();
            Timestamp now = TimeUtils.convertDateToTimestampSeconds((Date)new Date(millis));
            PreparedStatement ps = con.prepareStatement("INSERT INTO " + this.tableName + " (deviceId, deviceTitle, contractId, contractTitle, accountId,  accountTitle, code, logCoordinateRecordId, lastTime) VALUES (?,?,?,?,?,?,?,?,?)");
            ps.setInt(1, error.getDeviceId());
            ps.setString(2, error.getDeviceTitle());
            if (error.getContractId() > 0) {
                ps.setInt(3, error.getContractId());
            } else {
                ps.setNull(3, 4);
            }
            ps.setString(4, error.getContractTitle());
            if (error.getAccountId() > 0) {
                ps.setInt(5, error.getAccountId());
            } else {
                ps.setNull(5, 4);
            }
            ps.setString(6, error.getAccountTitle());
            ps.setInt(7, error.getErrorCode());
            ps.setInt(8, error.getLogCoordinateRecordId());
            ps.setTimestamp(9, now);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public Result<VoiceAuthError> errorList(Date timeFrom, Date timeTo, Set<Integer> deviceIds, Set<Integer> contractIds, Set<Integer> accountIds, String contract, String login, Page page) throws BGException {
        ArrayList<VoiceAuthError> result = new ArrayList<VoiceAuthError>();
        Connection con = this.connectionSet.getTrashConnection(this.tableName, 2);
        try {
            if (ServerUtils.tableExists((Connection)con, (String)this.tableName)) {
                StringBuilder sb = new StringBuilder();
                sb.append("SELECT SQL_CALC_FOUND_ROWS auth_error.* FROM " + this.tableName + " as auth_error");
                if (Utils.notBlankString((String)contract)) {
                    sb.append(" LEFT JOIN contract ON contract.id=auth_error.contractId");
                }
                if (Utils.notBlankString((String)login)) {
                    sb.append(" LEFT JOIN voice_account_" + this.moduleId + " as account ON account.id=auth_error.accountId");
                }
                sb.append(" WHERE auth_error.lastTime>=? AND auth_error.lastTime<?");
                if (contractIds != null && contractIds.size() > 0) {
                    sb.append(" AND auth_error.contractId IN (" + Utils.toString(contractIds) + ")");
                }
                if (deviceIds != null && deviceIds.size() > 0) {
                    sb.append(" AND auth_error.deviceId IN (" + Utils.toString(deviceIds) + ")");
                }
                if (accountIds != null && accountIds.size() > 0) {
                    sb.append(" AND auth_error.accountId IN (" + Utils.toString(accountIds) + ")");
                }
                if (Utils.notBlankString((String)contract)) {
                    sb.append(" AND contract.title LIKE ?");
                }
                if (Utils.notBlankString((String)login)) {
                    sb.append(" AND account.login LIKE ?");
                }
                sb.append(" ORDER BY auth_error.lastTime DESC LIMIT ?,?");
                PreparedStatement ps = con.prepareStatement(sb.toString());
                int i = 0;
                ps.setTimestamp(++i, TimeUtils.convertDateToTimestampSeconds((Date)timeFrom));
                ps.setTimestamp(++i, TimeUtils.convertDateToTimestampSeconds((Date)timeTo));
                if (Utils.notBlankString((String)contract)) {
                    ps.setString(++i, "%" + contract.trim() + "%");
                }
                if (Utils.notBlankString((String)login)) {
                    ps.setString(++i, "%" + login.trim() + "%");
                }
                ps.setInt(++i, page.getPageFirstRecordNumber());
                ps.setInt(++i, page.getPageSize());
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
                rs.close();
                ps.close();
                page.setRecordCount(ServerUtils.foundRows((Connection)con));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return new Result(result, page);
    }
}

