/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean.code;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.ws.Holder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceBaseCodeBean;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMap;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMapItem;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;
import ru.bitel.bgbilling.modules.voice.common.utils.VoiceCommonUtils;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceCostMapDao;
import ru.bitel.bgbilling.modules.voice.server.bean.code.CostMapItemReader;
import ru.bitel.bgbilling.modules.voice.server.bean.code.GeoCodeImportManager;
import ru.bitel.bgbilling.modules.voice.server.bean.code.VoiceCostMapItemDao;
import ru.bitel.bgbilling.modules.voice.server.bean.code.VoiceGeographicCodeDao;
import ru.bitel.bgbilling.modules.voice.server.event.GeoCodeUpdateEvent;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceCostMapUpdateEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.model.Period;

public class CostMapImportManager {
    private static final Logger logger = LogManager.getLogger();
    private int operatorIdImpl = -100;
    private boolean addNewGeocodes;
    private VoiceCostMapDao costMapDao;
    private VoiceCostMapItemDao costMapItemDao;
    private VoiceGeographicCodeDao codeDao;
    private int moduleId;
    private int userId;
    private Map<Integer, List<VoiceCostMapItem>> costItemMapImpl;
    private GeoCodeImportManager codeImportManagerImpl;
    private Map<String, Integer> codeMap;
    private Connection con;
    private boolean importMode = false;

    public CostMapImportManager(Connection con, int moduleId, int userId) throws BGException {
        this.con = con;
        this.costMapDao = new VoiceCostMapDao(con, moduleId);
        this.costMapItemDao = new VoiceCostMapItemDao(con, moduleId);
        this.codeDao = new VoiceGeographicCodeDao(con, moduleId);
        this.moduleId = moduleId;
        this.userId = userId;
    }

    public String importCostMap(int costMapId, Period period, boolean addNewGeocodes, String importerId, Holder<DataHandler> importContent) throws BGException {
        this.addNewGeocodes = addNewGeocodes;
        boolean needEvent = false;
        String result = "";
        this.importMode = true;
        CostMapItemReader fileReader = this.getFileReader(importerId);
        this.getCodeMap(this.getOperatorId(costMapId));
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ((DataHandler)importContent.value).writeTo((OutputStream)baos);
            String contentString = baos.toString("UTF-8");
            int count = 0;
            List<VoiceCostMapItem> list = fileReader.getGeocodesFromString(contentString, result, costMapId, period);
            for (VoiceCostMapItem item : list) {
                if (item == null || this.updateCostMapItem(item, false) <= 0) continue;
                if (++count % 10000 == 0) {
                    logger.debug((Object)count);
                }
                needEvent = true;
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BGMessageException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438! \u041f\u043e\u0434\u0440\u043e\u0431\u043d\u0435\u0435 \u0441\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u0432 \u043b\u043e\u0433\u0430\u0445 \u0441\u0435\u0440\u0432\u0435\u0440\u0430.");
        }
        if (needEvent) {
            EventProcessor.getInstance().publishAfterCommit((Event)new GeoCodeUpdateEvent(this.moduleId, this.userId));
            EventProcessor.getInstance().publishAfterCommit((Event)new VoiceCostMapUpdateEvent(this.moduleId, this.userId, costMapId));
        }
        return result;
    }

    private CostMapItemReader getFileReader(String importerId) {
        for (Class clazz : ServerUtils.getClassList((String)"ru.bitel.bgbilling.modules.voice.server.bean.code.importer")) {
            if (!Arrays.asList(clazz.getInterfaces()).contains(CostMapItemReader.class)) continue;
            try {
                CostMapItemReader itemReader = clazz.asSubclass(CostMapItemReader.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                if (!importerId.equals(itemReader.getId())) continue;
                return itemReader;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public int updateCostMapItem(VoiceCostMapItem item) throws BGException {
        return this.updateCostMapItem(item, true);
    }

    private int updateCostMapItem(VoiceCostMapItem item, boolean needEvent) throws BGException {
        try {
            if (item.getCodeId() <= 0) {
                int operatorId = this.getOperatorId(item.getCostMapId());
                Integer codeId = this.getCodeMap(operatorId).get(item.getCode());
                if (codeId == null || codeId <= 0) {
                    if (!this.addNewGeocodes) {
                        return -1;
                    }
                    VoiceGeographicCode newCode = new VoiceGeographicCode();
                    newCode.setCode(item.getCode());
                    newCode.setDestinationTitle(item.getDestinationTitle());
                    newCode.setOperatorId(operatorId);
                    newCode.setDateFrom(null);
                    newCode.setDateTo(null);
                    codeId = this.getCodeImportManagerImpl().insertCode(newCode, true);
                    if (codeId <= 0) {
                        return -1;
                    }
                    this.getCodeMap(operatorId).put(newCode.getCode(), codeId);
                }
                item.setCodeId(codeId.intValue());
            }
            List codes = this.getCostItemMap(item.getCodeId(), item.getCostMapId()).get(item.getCodeId());
            item.setId(-1);
            this.costMapItemDao.update(item);
            codes = VoiceCommonUtils.insertInHistory((VoiceBaseCodeBean)item, codes);
            this.costMapItemDao.updateHistory(codes);
            if (needEvent) {
                EventProcessor.getInstance().publishAfterCommit((Event)new GeoCodeUpdateEvent(this.moduleId, this.userId));
                EventProcessor.getInstance().publishAfterCommit((Event)new VoiceCostMapUpdateEvent(this.moduleId, this.userId, item.getCostMapId()));
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return item.getId();
    }

    private Map<Integer, List<VoiceCostMapItem>> getCostItemMap(int codeId, int costMapId) throws BGException {
        if (this.costItemMapImpl == null) {
            if (this.importMode) {
                codeId = -1;
            }
            this.costItemMapImpl = this.costMapItemDao.codeMap(codeId, costMapId);
        }
        return this.costItemMapImpl;
    }

    private GeoCodeImportManager getCodeImportManagerImpl() throws BGException {
        if (this.codeImportManagerImpl == null) {
            this.codeImportManagerImpl = new GeoCodeImportManager(this.con, this.moduleId, this.userId);
        }
        return this.codeImportManagerImpl;
    }

    private int getOperatorId(int costMapId) throws BGException {
        VoiceCostMap costMap;
        if (this.operatorIdImpl == -100 && (costMap = (VoiceCostMap)this.costMapDao.get(costMapId)) != null) {
            this.operatorIdImpl = costMap.getOperatorId();
        }
        return this.operatorIdImpl;
    }

    private Map<String, Integer> getCodeMap(int operatorId) throws BGException {
        if (this.codeMap == null) {
            List<VoiceGeographicCode> list = this.codeDao.list(-1, operatorId);
            this.codeMap = new HashMap<String, Integer>();
            for (VoiceGeographicCode code : list) {
                this.codeMap.put(code.getCode(), code.getId());
            }
        }
        return this.codeMap;
    }
}

