/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceGeographicCodeService;
import ru.bitel.bgbilling.modules.voice.server.bean.code.GeoCodeManager;
import ru.bitel.bgbilling.modules.voice.server.event.GeoCodeUpdateEvent;
import ru.bitel.bgbilling.modules.voice.server.utils.VoiceUtils;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.model.Node;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.voice.common.service.VoiceGeographicCodeService")
public class VoiceGeographicCodeServiceImpl
extends AbstractService
implements VoiceGeographicCodeService {
    private static final Logger logger = LogManager.getLogger();
    private GeoCodeManager codeDao;

    @PostConstruct
    private void init() {
        this.codeDao = new GeoCodeManager(this.getConnection(), this.moduleId, this.userId);
    }

    public void getGeographicCodeTree(int operatorId, Holder<DataHandler> codeData) throws BGException, BGMessageException {
        List<VoiceGeographicCode> codeList = this.codeDao.list(-1, operatorId);
        this.listToTreeRoot(codeData, codeList);
    }

    public int updateGeographicCode(VoiceGeographicCode code) throws BGException, BGMessageException {
        try (GeoCodeManager geoCodeManager = new GeoCodeManager(this.getConnection(), this.moduleId, this.userId);){
            int n = geoCodeManager.updateGeographicCode(code);
            return n;
        }
    }

    public int deleteGeographicCode(List<Integer> codes) throws BGException, BGMessageException {
        EventProcessor.getInstance().publishAfterCommit((Event)new GeoCodeUpdateEvent(this.moduleId, this.userId));
        return this.codeDao.delete(codes);
    }

    public String importGeographicCode(int operatorId, boolean addNew, boolean updateExist, Holder<DataHandler> importContent) throws BGException, BGMessageException {
        try (GeoCodeManager manager = new GeoCodeManager(this.getConnection(), this.moduleId, this.userId);){
            String string = manager.importGeographicCode(operatorId, addNew, updateExist, importContent);
            return string;
        }
    }

    public void deleteAllGeographicCode(int operatorId) throws BGException, BGMessageException {
        List<VoiceGeographicCode> codes = this.codeDao.list(-1, operatorId);
        this.codeDao.delete(codes.stream().map(item -> item.getId()).collect(Collectors.toList()));
    }

    private void listToTreeRoot(Holder<DataHandler> codeData, List<VoiceGeographicCode> codeList) throws BGException, BGMessageException {
        VoiceUtils.fillParents(codeList);
        VoiceGeographicCode root = new VoiceGeographicCode();
        root.setTitle("\u0414\u0435\u0440\u0435\u0432\u043e \u043a\u043e\u0434\u043e\u0432");
        root = (VoiceGeographicCode)TreeUtils.tree(codeList, (Node)root);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(root);
            oos.flush();
            final byte[] rootBytes = baos.toByteArray();
            codeData.value = new DataHandler(new DataSource(){

                public OutputStream getOutputStream() throws IOException {
                    return null;
                }

                public String getName() {
                    return null;
                }

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(rootBytes);
                }

                public String getContentType() {
                    return null;
                }
            });
        }
        catch (IOException e) {
            throw new BGException((Throwable)e);
        }
    }
}

