/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZoneMap;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZoneMapItem;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceZoneMapService;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceZoneMapDao;
import ru.bitel.bgbilling.modules.voice.server.bean.code.VoiceZoneMapItemDao;
import ru.bitel.bgbilling.modules.voice.server.bean.code.ZoneMapImportManager;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceZoneMapUpdateEvent;
import ru.bitel.bgbilling.modules.voice.server.utils.VoiceUtils;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.model.Node;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.voice.common.service.VoiceZoneMapService")
public class VoiceZoneMapServiceImpl
extends AbstractService
implements VoiceZoneMapService {
    private VoiceZoneMapDao zoneMapDao;
    private VoiceZoneMapItemDao zoneMapItemDao;

    @PostConstruct
    private void init() {
        this.zoneMapDao = new VoiceZoneMapDao(this.getConnection(), this.moduleId);
        this.zoneMapItemDao = new VoiceZoneMapItemDao(this.getConnection(), this.moduleId);
    }

    public List<VoiceZoneMap> voiceZoneMapList() throws BGException {
        return this.zoneMapDao.list();
    }

    public int voiceZoneMapUpdate(VoiceZoneMap zoneMap) throws BGException {
        this.zoneMapDao.update(zoneMap);
        EventProcessor.getInstance().publishAfterCommit((Event)new VoiceZoneMapUpdateEvent(this.moduleId, this.userId, zoneMap.getId()));
        return zoneMap.getId();
    }

    public int voiceZoneMapDelete(int zoneMapId) throws BGException {
        EventProcessor.getInstance().publishAfterCommit((Event)new VoiceZoneMapUpdateEvent(this.moduleId, this.userId, zoneMapId));
        this.zoneMapItemDao.deleteByMapId(zoneMapId);
        return this.zoneMapDao.delete(zoneMapId);
    }

    public void voiceZoneMapItemTree(int zoneMapId, Holder<DataHandler> content) throws BGException {
        List<VoiceZoneMapItem> zoneMapItemList = this.zoneMapItemDao.list(zoneMapId);
        VoiceUtils.fillParents(zoneMapItemList);
        VoiceZoneMapItem root = new VoiceZoneMapItem();
        root.setTitle("\u0414\u0435\u0440\u0435\u0432\u043e \u043a\u043e\u0434\u043e\u0432");
        root = (VoiceZoneMapItem)TreeUtils.tree(zoneMapItemList, (Node)root);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(root);
            oos.flush();
            final byte[] rootBytes = baos.toByteArray();
            content.value = new DataHandler(new DataSource(){

                public OutputStream getOutputStream() throws IOException {
                    return null;
                }

                public String getName() {
                    return null;
                }

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(rootBytes);
                }

                public String getContentType() {
                    return null;
                }
            });
            EventProcessor.getInstance().publishAfterCommit((Event)new VoiceZoneMapUpdateEvent(this.moduleId, this.userId, zoneMapId));
        }
        catch (IOException e) {
            throw new BGException((Throwable)e);
        }
    }

    public VoiceZoneMapItem voiceZoneMapItemGet(int itemId) throws BGException {
        return (VoiceZoneMapItem)this.zoneMapItemDao.get(itemId);
    }

    public int voiceZoneMapItemUpdate(VoiceZoneMapItem item) throws BGException {
        this.zoneMapItemDao.update(item);
        EventProcessor.getInstance().publishAfterCommit((Event)new VoiceZoneMapUpdateEvent(this.moduleId, this.userId, item.getMapId()));
        return item.getId();
    }

    public int voiceZoneMapItemDelete(List<Integer> itemIds) throws BGException {
        if (!itemIds.isEmpty()) {
            int itemId = itemIds.get(0);
            VoiceZoneMapItem item = (VoiceZoneMapItem)this.zoneMapItemDao.get(itemId);
            EventProcessor.getInstance().publishAfterCommit((Event)new VoiceZoneMapUpdateEvent(this.moduleId, this.userId, item.getMapId()));
        }
        for (Integer itemId : itemIds) {
            this.zoneMapItemDao.delete(itemId);
        }
        return itemIds.size();
    }

    public String importZoneMap(int zoneMapId, int mode, Holder<DataHandler> importContent) throws BGException {
        return new ZoneMapImportManager(this.getConnection(), this.moduleId, this.userId).importZoneMap(zoneMapId, mode, importContent);
    }
}

