/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.yoomoney.server.action.apps;

import bitel.billing.server.contract.bean.ContractModuleManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.util.Log;
import org.json.JSONException;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.apps.server.bean.AppsAbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.yoomoney.common.bean.Transaction;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class ActionDoPayment
extends AppsAbstractAction {
    private static final Logger logger = LogManager.getLogger();
    private ModuleSetup moduleSetup;
    private int responseCode;

    public void execute() throws BGException {
        block29: {
            int moduleId = this.getIntParameter("module_id", -1);
            int paymentType = this.getIntParameter("paymentType", 1);
            if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(moduleId)) {
                throw new BGMessageException("\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
            }
            this.moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
            BigDecimal amount = this.getBigDecimal("amount", BigDecimal.ZERO).setScale(2, RoundingMode.HALF_EVEN);
            String idempotenceKey = this.getParameter("Idempotence-Key");
            String answer = null;
            try (TransactionManager manager = new TransactionManager(this.con, moduleId);
                 ContractDao contractDao = new ContractDao(this.con, -1);){
                Contract contract = (Contract)contractDao.get(this.contractId);
                if (contract == null) {
                    throw new BGMessageException("Contract don't finde !");
                }
                ObjectMapper mapper = new ObjectMapper();
                HashMap<String, Object> paymentRequestData = new HashMap<String, Object>();
                HashMap<String, String> amountData = new HashMap<String, String>();
                amountData.put("value", Utils.formatCost((BigDecimal)amount));
                amountData.put("currency", "RUB");
                paymentRequestData.put("amount", amountData);
                paymentRequestData.put("capture", true);
                paymentRequestData.put("description", contract.getTitle() + ", " + this.contractId);
                if (paymentType == 1) {
                    paymentRequestData.put("payment_token", this.getParameter("paymentToken"));
                } else if (paymentType == 2) {
                    HashMap<String, String> paymentData = new HashMap<String, String>();
                    paymentData.put("type", "apple_pay");
                    paymentData.put("payment_data", this.getParameter("paymentData"));
                    paymentRequestData.put("payment_method_data", paymentData);
                }
                HashMap<String, CallSite> metadata = new HashMap<String, CallSite>();
                paymentRequestData.put("metadata", metadata);
                metadata.put("contractId", (CallSite)((Object)("" + this.contractId)));
                if (this.moduleSetup.getBoolean("yoomoney.fiscalization.enable", false)) {
                    this.fiscalization(paymentRequestData, amountData, contract);
                }
                answer = this.request(mapper.writeValueAsString(paymentRequestData), idempotenceKey);
                JSONObject jsonResponse = new JSONObject(answer);
                if (this.responseCode == 200) {
                    String status = jsonResponse.getString("status");
                    if ("succeeded".equals(status)) {
                        this.actionMap.put("result", "ok");
                    } else if ("pending".equals(status)) {
                        JSONObject confirmation = jsonResponse.optJSONObject("confirmation");
                        if (confirmation == null) {
                            this.actionMap.put("result", "unknown");
                            throw new BGMessageException("\u041d\u0435 \u043f\u0440\u0438\u0448\u043b\u0438 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b. Confirmation json");
                        }
                        String type = confirmation.optString("type");
                        String url = confirmation.optString("confirmation_url");
                        if (!"redirect".equals(type) || Utils.isBlankString((String)url)) {
                            throw new BGMessageException("\u041d\u0435 \u043f\u0440\u0438\u0448\u043b\u0438 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b. Type or url");
                        }
                        this.actionMap.put("result", "3ds_required");
                        this.actionMap.put("3ds_url", url);
                    } else if ("canceled".equals(status)) {
                        this.actionMap.put("result", "canceled");
                        JSONObject cancellationDetailsJson = jsonResponse.optJSONObject("cancellation_details");
                        if (cancellationDetailsJson != null) {
                            String party = cancellationDetailsJson.optString("party");
                            String reason = cancellationDetailsJson.optString("reason");
                            if (Utils.notBlankString((String)reason)) {
                                this.actionMap.put("cancelComment", Transaction.getCancelComment((String)party, (String)reason));
                            }
                        }
                    } else {
                        this.actionMap.put("result", "unknown");
                    }
                    break block29;
                }
                logger.error(answer);
                throw new BGMessageException(this.getHttpErrorComment(this.responseCode, jsonResponse.optString("code"), jsonResponse.optString("description")));
            }
            catch (IOException | ParseException | JSONException e) {
                Log.error((Object)("Answer: " + answer));
                throw new BGException(e.getMessage(), e);
            }
        }
    }

    private String request(String request, String idempotenceKey) throws ClientProtocolException, IOException, BGException {
        String shopId = this.moduleSetup.get("mobile.shopId", this.moduleSetup.get("yoomoney.shopId", null));
        String apiKey = this.moduleSetup.get("mobile.api.key", null);
        String encoded = Base64.getEncoder().encodeToString((shopId + ":" + apiKey).getBytes(StandardCharsets.UTF_8));
        if (logger.isDebugEnabled()) {
            logger.debug("shopId = {}", (Object)shopId);
            logger.debug("apiKey = {}", (Object)apiKey);
            logger.debug("encoded = {}", (Object)encoded);
        }
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpPost httppost = new HttpPost(this.moduleSetup.get("yoomoney.payment.api.url", "https://api.yookassa.ru/v3/payments"));
        httppost.setHeader("Idempotence-Key", idempotenceKey);
        httppost.addHeader("Content-Type", "application/json;");
        httppost.addHeader("Authorization", "Basic " + encoded);
        httppost.setEntity((HttpEntity)new StringEntity(request, StandardCharsets.UTF_8));
        HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
        this.responseCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            throw new BGException("Http Entity is null");
        }
        return entity != null ? EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8) : "";
    }

    private void fiscalization(Map<String, Object> paymentRequestData, Map<String, String> amountData, Contract contract) throws BGMessageException {
        String payment_mode;
        int taxSystemCode;
        String email = this.getParameter("email");
        String phone = this.getParameter("phone");
        if (Utils.isBlankString((String)phone) && Utils.isBlankString((String)email)) {
            throw new BGMessageException("\u0414\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430 \u0438\u043b\u0438 e-mail.");
        }
        HashMap<String, Object> fiscalizationData = new HashMap<String, Object>();
        paymentRequestData.put("receipt", fiscalizationData);
        if (!Utils.isBlankString((String)phone)) {
            fiscalizationData.put("phone", phone);
        }
        if (!Utils.isBlankString((String)email)) {
            fiscalizationData.put("email", email);
        }
        if ((taxSystemCode = this.moduleSetup.getInt("yoomoney.fiscalization.receipt.tax.system", -1)) > 0) {
            fiscalizationData.put("tax_system_code", this.moduleSetup.getInt("yoomoney.fiscalization.receipt.tax.system", 1));
        }
        HashMap<String, String> customer = new HashMap<String, String>();
        fiscalizationData.put("customer", customer);
        if (!Utils.isBlankString((String)phone)) {
            customer.put("phone", phone);
        }
        if (!Utils.isBlankString((String)email)) {
            customer.put("email", email);
        }
        ArrayList items = new ArrayList();
        HashMap<String, Object> item = new HashMap<String, Object>();
        fiscalizationData.put("items", items);
        item.put("description", this.moduleSetup.get("yoomoney.fiscalization.receipt.name", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contract.getTitle()));
        item.put("quantity", this.moduleSetup.get("yoomoney.fiscalization.receipt.qty", "1"));
        item.put("amount", amountData);
        item.put("vat_code", this.moduleSetup.getInt("yoomoney.fiscalization.receipt.vat_code", 1));
        String subject = this.moduleSetup.get("yoomoney.fiscalization.receipt.payment.subject.type", null);
        if (Utils.notBlankString((String)subject)) {
            item.put("payment_subject", subject);
        }
        if (Utils.notBlankString((String)(payment_mode = this.moduleSetup.get("yoomoney.fiscalization.receipt.payment.method.type", null)))) {
            item.put("payment_mode", this.moduleSetup.get("yoomoney.fiscalization.receipt.payment.method.type", "full_prepayment"));
        }
    }

    private String getHttpErrorComment(int httpCode, String code, String description) {
        Object comment = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430: ";
        switch (httpCode) {
            case 400: {
                comment = (String)comment + "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441. \u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u043f\u0440\u0430\u0432\u0438\u043b \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0441 API";
                break;
            }
            case 401: {
                comment = (String)comment + "[Basic Auth] \u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0432\u0430\u0448\u0435\u0433\u043e \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 \u0432 \u042e.\u041a\u0430\u0441\u0441\u0435 \u0438\u043b\u0438 \u0441\u0435\u043a\u0440\u0435\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 (\u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438 \u043f\u0430\u0440\u043e\u043b\u044c \u043f\u0440\u0438 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438). [OAuth 2.0] \u041d\u0435\u0432\u0430\u043b\u0438\u0434\u043d\u044b\u0439 OAuth-\u0442\u043e\u043a\u0435\u043d: \u0438\u0441\u0442\u0435\u043a \u0441\u0440\u043e\u043a \u0436\u0438\u0437\u043d\u0438 \u0438\u043b\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043e\u0442\u043e\u0437\u0432\u0430\u043b \u0435\u0433\u043e";
                break;
            }
            case 403: {
                comment = (String)comment + "\u0421\u0435\u043a\u0440\u0435\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 \u0438\u043b\u0438 OAuth-\u0442\u043e\u043a\u0435\u043d \u0432\u0435\u0440\u043d\u044b\u0439, \u043d\u043e \u043d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0441\u043e\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438";
                break;
            }
            case 404: {
                comment = (String)comment + "\u0420\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d";
                break;
            }
            case 429: {
                comment = (String)comment + "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043b\u0438\u043c\u0438\u0442 \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432 \u0432 \u0435\u0434\u0438\u043d\u0438\u0446\u0443 \u0432\u0440\u0435\u043c\u0435\u043d\u0438";
                break;
            }
            case 500: {
                comment = (String)comment + "\u0422\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043d\u0435\u043f\u043e\u043b\u0430\u0434\u043a\u0438 \u043d\u0430 \u0441\u0442\u043e\u0440\u043e\u043d\u0435 \u042e.\u041a\u0430\u0441\u0441\u044b. \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d";
                break;
            }
            default: {
                comment = (String)comment + "unknown, httpCode-" + httpCode;
            }
        }
        comment = (String)comment + ". " + code + ". " + description;
        return comment;
    }
}

