/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.server.action;

import bitel.billing.server.ActionBase;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.assist.common.bean.AssistPaymentRecurring;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistPaymentRecurringManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionRecurringList
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        if (this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        AssistPaymentRecurringManager prm = new AssistPaymentRecurringManager(this.con, this.mid);
        List<AssistPaymentRecurring> paymentList = prm.getRecurringList(this.cid);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        for (AssistPaymentRecurring payment : paymentList) {
            Element paymentEl = this.createElement(data, "row");
            paymentEl.setAttribute("id", String.valueOf(payment.getId()));
            paymentEl.setAttribute("cid", String.valueOf(payment.getCid()));
            paymentEl.setAttribute("date", TimeUtils.format((Date)payment.getDate(), (String)"dd.MM.yyyy HH:mm:ss"));
            paymentEl.setAttribute("amount", Utils.formatCost((BigDecimal)payment.getAmount()));
            paymentEl.setAttribute("billnumber", payment.getBillnumber() > 0L ? String.valueOf(payment.getBillnumber()) : null);
            paymentEl.setAttribute("ordernumber", payment.getOrdernumber() > 0 ? String.valueOf(payment.getOrdernumber()) : null);
            paymentEl.setAttribute("recurringMinAmount", Utils.formatCost((BigDecimal)payment.getRecurringMinAmount()));
            paymentEl.setAttribute("recurringMaxAmount", Utils.formatCost((BigDecimal)payment.getRecurringMaxAmount()));
            paymentEl.setAttribute("recurringPeriod", String.valueOf(payment.getRecurringPeriod()));
            paymentEl.setAttribute("recurringMaxDate", TimeUtils.format((Date)payment.getRecurringMaxDate(), (String)"dd.MM.yyyy"));
        }
    }
}

