<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="layout.xsl"/>


<xsl:template name="title">
	<xsl:choose>
		<xsl:when test="data/@action = 'PayList'">
			<xsl:choose>
				<!-- NEW - 1, OK - 2, FAIL - 4 -->
				<xsl:when test="data/@result = 'NEW'">Платеж Assist.Ru в обработке</xsl:when>
				<xsl:when test="data/@result = 'OK'">Платеж Assist.Ru успешно проведён</xsl:when>				
				<xsl:when test="data/@result = 'FAIL'">Ошибка проведения платежа Assist.Ru</xsl:when>
				<xsl:otherwise>Список платежей Assist.Ru</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:when test="data/@action = 'Pay'">Пополнение счета через Assist.Ru</xsl:when>
	</xsl:choose>
</xsl:template>


<xsl:template name="head">
<xsl:text disable-output-escaping="yes">
	<![CDATA[    
<script type="text/javascript">
<!--

function mousePageXY(e)
{
  var x = 0, y = 0;

  if (!e) e = window.event;

  if (e.pageX || e.pageY)
  {
    x = e.pageX;
    y = e.pageY;
  }
  else if (e.clientX || e.clientY)
  {
    x = e.clientX + (document.documentElement.scrollLeft || document.body.scrollLeft) - document.documentElement.clientLeft;
    y = e.clientY + (document.documentElement.scrollTop || document.body.scrollTop) - document.documentElement.clientTop;
  }

  return {"x":x, "y":y};
}

var dive=null;
var bodyX;
var bodyY;
var widthE;
var heightE;

document.onmousemove = function(e){ var mCur = mousePageXY(e); bodyX = mCur.x; bodyY = mCur.y; };

function showInfo(text)
{
	hideInfo();
	dive=document.createElement('pre');	
	dive.textContent=text;
	//dive.style.cssText = "width:200px; height:200px; border:1px solid #CCCCFF; background-color:#EEEEFF; position: absolute;";
	document.body.appendChild(dive);	
	updateInfo();	
	widthE = dive.offsetWidth;
	heightE = dive.offsetHeight;	
}

function hideInfo()
{
	if(dive!=null)
	{
		document.body.removeChild(dive);
		dive=null;
	}
}

function updateInfo()
{
	if(dive!=null)
	{
		dive.style.cssText = "border:1px solid #CCCCFF; background-color:#EEEEFF; position: absolute; left: "+(bodyX-widthE-5)+"px; top: "+bodyY+"px;";
	}
}
//-->
</script>   
    ]]>
</xsl:text>
</xsl:template>


<xsl:template match="/data">
	<xsl:choose>
		<xsl:when test="@action = 'PayList'">
			<xsl:call-template name="PayList"/>
		</xsl:when>
		<xsl:when test="@action = 'Pay'">
			<xsl:choose>
				<xsl:when test="pay/@Merchant_ID">
					<xsl:call-template name="PayConfirm"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="Pay"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>		
	</xsl:choose>
</xsl:template>


<xsl:template name="PayList">

	<xsl:if test="resultmessage">
		<div class="infoMessage">
			<pre><xsl:value-of select="resultmessage"/></pre>
		</div>
	</xsl:if>

	<div class="bgMonthAndYearWidget">
		<xsl:attribute name="month"><xsl:value-of select="/data/@month"/></xsl:attribute>
		<xsl:attribute name="year"><xsl:value-of select="/data/@year"/></xsl:attribute>
		<xsl:attribute name="query"><xsl:value-of select="$WEBEXECUTER"/>?action=<xsl:value-of select="/data/@action"/>&amp;module=<xsl:value-of select="/data/@module"/>&amp;mid=<xsl:value-of select="/data/@mid"/></xsl:attribute></div>

	<table class="layout">
		<tr><td>
			<table class="table800">
				<thead>
		  			<tr>
						<td>Номер</td>
						<td>Дата/время оплаты</td>
						<td>Карта</td>
						<td>Владелец</td>
						<td>Сумма</td>
						<td>Статус операции</td>
		  			</tr>
		 		</thead>
		 		<tbody>	 		
		  			<xsl:for-each select="assist/payment">	  				
						<tr>	
							<xsl:attribute name="class">
								<xsl:choose>
		  							<xsl:when test="@status='NEW'">row_status_process</xsl:when>
		  							<xsl:when test="@status='OK'">row_status_ok</xsl:when>
		  							<xsl:when test="@status='FAIL'">row_status_fail</xsl:when>
		  						</xsl:choose>
							</xsl:attribute>
		
							<td nowrap="nowrap"><xsl:value-of select="@number"/></td>
							<td><xsl:value-of select="@time"/></td>
							<td><xsl:value-of select="@card_text"/></td>
							<td><xsl:value-of select="@card_holder"/></td>
							<td nowrap="nowrap"><xsl:value-of select="@summ"/></td>
							<td>
		  						<xsl:variable name="info">
		  							<xsl:choose>
		  								<xsl:when test="@status='NEW'">Платёж находится в обработке.\nПодождите, пожалуйста.</xsl:when>
		  								<xsl:otherwise>Номер платежа: <xsl:value-of select="@number"/>\nНомер assist: #<xsl:value-of select="@billnumber"/>\nСумма: <xsl:value-of select="@summ"/>\nДата: <xsl:value-of select="@time"/>\nНомер карты: <xsl:value-of select="@card_number"/>\nТип/подтип карты: <xsl:value-of select="@cardtype"/>/<xsl:value-of select="@cardsubtype"/>\nДержатель: <xsl:value-of select="@card_holder"/>\nПлательщик: <xsl:value-of select="@name"/>\nIP: <xsl:value-of select="@ipaddress"/>\nКомментарий: <xsl:value-of select="@comment"/>\nКод возврата: <xsl:value-of select="@responsecode"/></xsl:otherwise>
		  							</xsl:choose>
		  						</xsl:variable>
								<span onmouseover="showInfo('{$info}');" onmousemove="updateInfo()" onmouseout="hideInfo();" style="cursor: help; border-bottom: 1px dashed gray;" >
								<xsl:choose>
		  							<xsl:when test="@status='NEW'">В обработке</xsl:when>
		  							<xsl:when test="@status='OK'">Успешно</xsl:when>
		  							<xsl:when test="@status='FAIL'">Неуспешно</xsl:when>
		  						</xsl:choose>
		  						</span>
		  						<!--
		  						<small>(<a href="{$WEBEXECUTER}?module={/data/@module}&amp;mid={/data/@mid}&amp;action=PayResult&amp;order_idp={@number}">Обновить</a>)</small> 
		  						-->
							</td>
						</tr>
		  			</xsl:for-each>
		 		</tbody>
			</table>
		</td></tr>	
	 	<tr><td style="text-align: right;">
			<form method='post' action='{$WEBEXECUTER}' style="display: inline;">
				<xsl:call-template name="module"/>
				<input type="hidden" name="action" value="Pay" />
					
				<xsl:call-template name="submit">
					<xsl:with-param name="title" select="'Пополнить счет'"/>
				</xsl:call-template>
			</form>
		</td></tr>
	</table>	

	<xsl:if test="recurring">
		<div>
			<h2>Автоплатёж</h2>
			<xsl:choose>
				<xsl:when test="recurring/@billnumber > 0">
				Подключен <xsl:value-of select="recurring/@Date"/> в заказе #<xsl:value-of select="recurring/@ordernumber"/> до даты <xsl:value-of select="recurring/@RecurringMaxDate"/> (сумма <xsl:value-of select="recurring/@RecurringMinAmount"/> - <xsl:value-of select="recurring/@RecurringMaxAmount"/>, каждые <xsl:value-of select="recurring/@RecurringPeriod"/> день)<br/>
				</xsl:when>
				<xsl:otherwise>
				Автоплатёж в процессе активации (номер заказа: #<xsl:value-of select="recurring/@ordernumber"/>)...<br/>
				</xsl:otherwise>
			</xsl:choose>
			<form method='post' action='{$WEBEXECUTER}' style="display: inline;">
				<xsl:call-template name="module"/>
				<input type="hidden" name="action" value="Pay" />
				<input type="hidden" name="command" value="deleterecurring" />
				<xsl:call-template name="submit">
					<xsl:with-param name="title" select="'Отменить автоплатёж'"/>
				</xsl:call-template>
			</form>
		</div>
	</xsl:if>
		
</xsl:template>

<xsl:template name="Pay">
	<form method="post" action="{$WEBEXECUTER}">
		<xsl:call-template name="action"/>
		
		<table class="layout">
			<tr>
				<td nowrap="nowrap">Текущий баланс:</td>
				<td><b><xsl:value-of select="balance/@balance"/></b></td>
			</tr>	
			<tr>
				<td nowrap="nowrap">Введите сумму для оплаты:</td>
				<td><input type="text" name="summ" size="13"></input></td>
			</tr>

			<xsl:if test="balance/@RecurringAllowed = 1">
			<tr>
				<td nowrap="nowrap">Подключить автоплатёж:</td>
				<td><input type="checkbox" name="recurring" value="1"></input>подключить</td>
			</tr>
			<tr>
				<td nowrap="nowrap">Автоплатежи до:</td>
				<td>
					<input type="text" name="recurringmaxdate" value="{balance/@defaultrecurringmaxdate}"></input><br/>
					<small>Дата окончания автоплатежей не должна быть больше,<br/>
					чем дата действия карты (или другого платёжного средства).</small>
				</td>
			</tr>
			</xsl:if>

			<tr class="foot">
				<td colspan="2">
					<xsl:call-template name="okCancel">
						<xsl:with-param name="title1" select="'Далее'"/>
						<xsl:with-param name="onclick2">window.location.replace( "<xsl:value-of select="$WEBEXECUTER"/>?action=PayList&#38;mid=<xsl:value-of select="/data/@mid"/>&#38;module=<xsl:value-of select="/data/@module"/>");</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
		</table>		
	</form>
</xsl:template>


<xsl:template name="PayConfirm">
	<form method="POST" action="{pay/@ACTION_URL}" id="authForm" accept-charset="utf-8">

		<input type="hidden" name="Merchant_ID" value="{pay/@Merchant_ID}"/>
		<input type="hidden" name="OrderNumber" value="{pay/@OrderNumber}"/>
		<input type="hidden" name="OrderAmount" value="{pay/@OrderAmount}"/>
		<input type="hidden" name="OrderComment" value="{pay/@OrderComment}"/>
		<input type="hidden" name="URL_RETURN_OK" value="{pay/@URL_RETURN_OK}"/>
		<input type="hidden" name="URL_RETURN_NO" value="{pay/@URL_RETURN_NO}"/>

		<xsl:if test="pay/@Delay"><input type="hidden" name="Delay" value="{pay/@Delay}"/></xsl:if>
		<xsl:if test="pay/@CardPayment"><input type="hidden" name="CardPayment" value="{pay/@CardPayment}"/></xsl:if>
		<xsl:if test="pay/@WMPayment"><input type="hidden" name="WMPayment" value="{pay/@WMPayment}"/></xsl:if>
		<xsl:if test="pay/@YMPayment"><input type="hidden" name="YMPayment" value="{pay/@YMPayment}"/></xsl:if>
		<xsl:if test="pay/@AssistIDPayment"><input type="hidden" name="AssistIDPayment" value="{pay/@AssistIDPayment}"/></xsl:if>

		<xsl:if test="pay/@QIWIPayment"><input type="hidden" name="QIWIPayment" value="{pay/@QIWIPayment}"/></xsl:if>
		<xsl:if test="pay/@QIWIMtsPayment"><input type="hidden" name="QIWIMtsPayment" value="{pay/@QIWIMtsPayment}"/></xsl:if>
		<xsl:if test="pay/@QIWIMegafonPayment"><input type="hidden" name="QIWIMegafonPayment" value="{pay/@QIWIMegafonPayment}"/></xsl:if>
		<xsl:if test="pay/@QIWIBeelinePayment"><input type="hidden" name="QIWIBeelinePayment" value="{pay/@QIWIBeelinePayment}"/></xsl:if>
		
		<xsl:if test="pay/@TestMode"><input type="hidden" name="TestMode" value="{pay/@TestMode}"/></xsl:if>
		
		<xsl:if test="pay/@RecurringIndicator"><input type="hidden" name="RecurringIndicator" value="{pay/@RecurringIndicator}"/></xsl:if>
		<xsl:if test="pay/@RecurringMinAmount"><input type="hidden" name="RecurringMinAmount" value="{pay/@RecurringMinAmount}"/></xsl:if>
		<xsl:if test="pay/@RecurringMaxAmount"><input type="hidden" name="RecurringMaxAmount" value="{pay/@RecurringMaxAmount}"/></xsl:if>
		<xsl:if test="pay/@RecurringPeriod"><input type="hidden" name="RecurringPeriod" value="{pay/@RecurringPeriod}"/></xsl:if>
		<xsl:if test="pay/@RecurringMaxDate"><input type="hidden" name="RecurringMaxDate" value="{pay/@RecurringMaxDate}"/></xsl:if>

		<div class="report">
			<table cellspacing="1" style="width: 600px;"><!-- TODO проверить -->
				<tbody>
					<xsl:choose>
					<xsl:when test="pay/@RecurringIndicator = 1">
						<tr>
							<td>
			  					Вы подключаете автплатёж на сумму <xsl:value-of select="pay/@OrderAmount"/>.<br/>
			  					Периодичность в днях: <xsl:value-of select="pay/@RecurringPeriod"/>, дата окончания платежей: <xsl:value-of select="pay/@RecurringMaxDate"/>.
							</td>
						</tr>
						<tr>
							<td>Убедитесь, что вы хотите этого и проверьте параметры платежа.<br/>
							Дата окончания автоплатежей не должна быть больше, чем дата действия карты (или другого платёжного средства).<br/>
							Нажмите "Далее" для перехода к системе Assist.Ru и продолжения проведения оплаты.</td>
						</tr>
					</xsl:when>
					<xsl:otherwise>
						<tr>
							<td>
			  					Новый платёж на сумму <xsl:value-of select="pay/@OrderAmount"/>
							</td>
						</tr>
						<tr>
							<td>Должна открыться страница ввода данных Assist.Ru<br/>
							Если этого не произошло, нажмите "Далее" для ручного
							перехода к системе Assist.Ru и продолжения проведения
							оплаты.</td>
						</tr>
					</xsl:otherwise>
					</xsl:choose>
				</tbody>
				<tfoot>
					<tr>
						<td>
							<xsl:call-template name="okCancel">
								<xsl:with-param name="title1" select="'Далее'"/>
								<xsl:with-param name="onclick2">window.location.replace( '<xsl:value-of select="$WEBEXECUTER"/>?action=PayList&#38;mid=<xsl:value-of select="/data/@mid"/>&#38;module=<xsl:value-of select="/data/@module"/>');</xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</tfoot>
			</table>
		</div>

	</form>

	<xsl:if test="pay/@RecurringIndicator = 0">
	<script language="JavaScript" type="text/javascript">document.forms["authForm"].submit();</script>
	</xsl:if>

</xsl:template>


</xsl:stylesheet>