/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.bill.common.bean.Organization;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.IdTitle;

public class OrganizationDao
extends AbstractDao<Organization> {
    public OrganizationDao(Connection con, int moduleId) {
        super(con, moduleId, "bill_organization");
    }

    public Organization getOrganization(int id) throws BGException {
        return (Organization)this.get("id=?", new Object[]{id});
    }

    public List<Organization> getOrganizationList() throws BGException {
        return this.list("", "title", new Object[0]);
    }

    public void deleteOrganization(int organizationId) throws BGException {
        this.delete("id=? AND NOT `default_org`", new Object[]{organizationId});
    }

    public void setDefaultOrganization(int organizationId) throws BGException {
        try {
            String query = "UPDATE bill_organization_" + this.moduleId + " SET default_org=(id=?), in_use=if(id=?, true, in_use)";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, organizationId);
            ps.setInt(2, organizationId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public Organization getDefaultOrganization() throws BGException {
        Organization result = null;
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE default_org=true");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = this.getFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public List<IdTitle> getOrganizationTitleList(Boolean inUse) throws BGException {
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        try {
            String query = "SELECT id, title FROM " + this.tableName + (String)(inUse == null ? "" : " WHERE in_use=" + inUse.toString()) + " ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(new IdTitle(rs.getInt(1), rs.getString(2)));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    protected Organization getFromRS(ResultSet rs) throws SQLException, BGException {
        Organization organization = new Organization();
        organization.setId(rs.getInt("id"));
        organization.setTitle(rs.getString("title"));
        organization.setDefaultOrganization(rs.getBoolean("default_org"));
        organization.setInUse(rs.getBoolean("in_use"));
        organization.setComment(rs.getString("comment"));
        String data = rs.getString("data");
        if (Utils.isEmptyString((String)data)) {
            data = "{}";
        }
        organization.setData(data);
        return organization;
    }

    protected void updateImpl(Organization organization) throws BGException, SQLException {
        boolean insert = organization.getId() <= 0;
        String query = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET title=?, comment=?, data=?, default_org=?, in_use=?" + (insert ? "" : " WHERE id=?");
        PreparedStatement ps = this.con.prepareStatement(query, 1);
        int index = 1;
        ps.setString(index++, organization.getTitle());
        ps.setString(index++, organization.getComment());
        ps.setString(index++, Utils.isEmptyString((String)organization.getData()) ? "{}" : organization.getData());
        ps.setBoolean(index++, organization.isDefaultOrganization());
        ps.setBoolean(index++, organization.isInUse());
        if (!insert) {
            ps.setInt(index++, organization.getId());
        }
        ps.executeUpdate();
        if (insert) {
            organization.setId(ServerUtils.lastInsertId((Connection)this.con));
        }
        ps.close();
    }
}

