/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.service;

import bitel.billing.server.contract.bean.ContractManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.jws.WebService;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Holder;
import net.sf.jasperreports.engine.JasperReport;
import org.apache.fop.apps.FOPException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.contract.config.server.bean.ContractModuleConfigDao;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.modules.bill.common.bean.BankAccount;
import ru.bitel.bgbilling.modules.bill.common.bean.BillDocument;
import ru.bitel.bgbilling.modules.bill.common.bean.DocType;
import ru.bitel.bgbilling.modules.bill.common.bean.DocumentPosition;
import ru.bitel.bgbilling.modules.bill.common.bean.DocumentType;
import ru.bitel.bgbilling.modules.bill.common.bean.InvoiceDocument;
import ru.bitel.bgbilling.modules.bill.common.bean.Organization;
import ru.bitel.bgbilling.modules.bill.common.bean.Position;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.bgbilling.modules.bill.server.bean.AccountManager;
import ru.bitel.bgbilling.modules.bill.server.bean.Bill;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDocumentDao;
import ru.bitel.bgbilling.modules.bill.server.bean.BillManager;
import ru.bitel.bgbilling.modules.bill.server.bean.BillUtil;
import ru.bitel.bgbilling.modules.bill.server.bean.ContractDocType;
import ru.bitel.bgbilling.modules.bill.server.bean.ContractDocTypeManager;
import ru.bitel.bgbilling.modules.bill.server.bean.DocTypeManager;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceDocumentDao;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceManager;
import ru.bitel.bgbilling.modules.bill.server.bean.OrganizationDao;
import ru.bitel.bgbilling.modules.bill.server.bean.PositionDao;
import ru.bitel.bgbilling.modules.bill.server.bean.PositionValue;
import ru.bitel.bgbilling.modules.bill.server.bean.TemplateBill;
import ru.bitel.bgbilling.modules.bill.server.bean.TemplateBillManager;
import ru.bitel.bgbilling.modules.bill.server.event.BillCreatedEvent;
import ru.bitel.bgbilling.modules.reports.server.bean.BGReportTemplate;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.FOUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.bill.common.service.BillService")
public class BillServiceImpl
extends AbstractService
implements BillService {
    public ru.bitel.common.model.Result<BillDocument> billDocumentListForContract(int contractId, Page page) throws BGException {
        return new ru.bitel.common.model.Result(new BillDocumentDao(this.getSetup(), (ParameterMap)this.getModuleSetup(), this.getConnection(), this.moduleId).list(contractId, page), page);
    }

    public void billDocumentDelete(int contractId, int id, boolean customer) throws BGException {
        if (contractId <= 0) {
            throw new BGIllegalArgumentException("contractId");
        }
        try (BillManager billManager = new BillManager(this.getConnection(), this.moduleId);){
            Bill bill = billManager.getBill(id);
            Calendar closedDate = null;
            if (bill != null && (closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"BillService.billDocumentDelete", (int)this.moduleId, (int)this.userId)) != null) {
                LocalDate month = LocalDate.of(bill.getYy(), bill.getMm() + 1, 1);
                ClosedDateChecker.checkDatesForDelete((Calendar)closedDate, (LocalDate)month);
            }
            if (customer) {
                int result = billManager.deleteBill(contractId, id, !customer);
                switch (result) {
                    case 1: {
                        throw new BGException("\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0439 \u0441\u0447\u0435\u0442", "bill.deleteError.userId");
                    }
                    case 2: {
                        throw new BGException("\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0439 \u0441\u0447\u0435\u0442", "bill.deleteError.status");
                    }
                    case 4: {
                        throw new BGException("\u0421\u0447\u0435\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", "bill.deleteError.notFound");
                    }
                }
            } else {
                if (bill == null || bill.getContractId() != contractId) {
                    throw new BGIllegalArgumentException("contractId");
                }
                billManager.delete(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<DocType> documentSpecListForCustomer(int contractId) throws BGException {
        ArrayList<DocType> billTypeList = new ArrayList<DocType>();
        Set allowedWebBillTypes = Utils.toIntegerSet((String)this.getModuleSetup().get("allowed.web.bill.types", null));
        for (DocType type : new ContractDocTypeManager(this.getConnection(), this.moduleId).getContractDocTypeList(contractId, DocumentType.BILL)) {
            if (!allowedWebBillTypes.contains(type.getId())) continue;
            billTypeList.add(type);
        }
        return billTypeList;
    }

    public List<BankAccount> bankAccountList() throws BGException {
        return new AccountManager(this.getConnection(), this.moduleId).getAccountList().stream().map(a -> a.toBankAccount()).collect(Collectors.toList());
    }

    public List<DocumentPosition> templateDocumentPositionList(int contractId, int documentSpecId, int year, int month) throws BGException {
        DocTypeManager docTypeManager = new DocTypeManager(this.getConnection(), this.moduleId);
        DocType docType = docTypeManager.getType(documentSpecId);
        ContractManager contractManager = new ContractManager(this.getConnection());
        TemplateBill templateBill = new TemplateBill();
        try (PositionDao positionDao = new PositionDao(this.getConnection(), this.moduleId, docType.getDocumentType());){
            TemplateBillManager templateBillManager = new TemplateBillManager(this.getConnection(), this.moduleId, docType.getDocumentType());
            templateBillManager.getTemplatePositions(contractManager, templateBill, new GregorianCalendar(year, month, 1), contractId, String.valueOf(contractId), null, docType, positionDao.getPositionMap());
        }
        return templateBill.getPositionList() == null ? null : templateBill.getPositionList().stream().map(e -> e.toDocumentPosition()).collect(Collectors.toList());
    }

    public int billDocumentCreate(int contractId, int documentSpecId, int bankAccountId, int year, int month, List<DocumentPosition> documentPositionList) throws BGException {
        if (!this.documentSpecListForCustomer(contractId).stream().anyMatch(s -> s.getId() == documentSpecId)) {
            new BGIllegalArgumentException("documentSpecId");
        }
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"BillService.billDocumentCreate", (int)this.moduleId, (int)this.userId);
        if (closedDate != null) {
            LocalDate datemonth = LocalDate.of(year, month + 1, 1);
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (LocalDate)datemonth, (LocalDate)datemonth);
        }
        List<DocumentPosition> templateDocumentPositionList = this.templateDocumentPositionList(contractId, documentSpecId, year, month);
        ArrayList<PositionValue> posList = new ArrayList<PositionValue>();
        BigDecimal total = BigDecimal.ZERO;
        for (DocumentPosition pos : documentPositionList) {
            if (!templateDocumentPositionList.stream().anyMatch(s -> s.getPositionId() == pos.getPositionId())) {
                new BGIllegalArgumentException("positionId=" + pos.getPositionId());
            }
            PositionValue val = new PositionValue();
            val.setPositionId(pos.getPositionId());
            val.setName(pos.getName());
            val.setSum(pos.getAmount());
            val.setUnit(Utils.maskNull((String)pos.getUnit()));
            pos.setInTotal(true);
            val.setInSumm(true);
            val.setQuantity(Utils.parseBigDecimal((String)this.getModuleSetup().get("web.bill.generate.position.quantity", "0"), (BigDecimal)BigDecimal.ZERO));
            posList.add(val);
            total = total.add(val.getSum());
        }
        Bill bill = new Bill();
        bill.setContractId(contractId);
        bill.setTypeId(documentSpecId);
        bill.setAccountId(bankAccountId);
        bill.setBankAccount(new AccountManager(this.getConnection(), this.moduleId).getBankAccount(bankAccountId));
        bill.setYy(year);
        bill.setMm(month);
        bill.setSumm(total);
        bill.setCreateDate(new Date());
        bill.setUserId(-1);
        bill.setNpid(new DocTypeManager(this.getConnection(), this.moduleId).getType(documentSpecId).getNpid());
        int billId = 0;
        try (BillManager billManager = new BillManager(this.getConnection(), this.moduleId);){
            billId = billManager.addBillDoc(this.userId, bill, posList, Collections.emptyList());
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        this.context.publishAfterCommit((Event)new BillCreatedEvent(this.userId, this.moduleId, contractId, billId));
        return billId;
    }

    public void billDocumentDownload(int contractId, int id, Holder<String> name, Holder<DataHandler> data) throws BGException {
        this.documentDownload(contractId, id, false, name, data);
    }

    private void documentDownload(int contractId, int id, boolean invoice, Holder<String> name, Holder<DataHandler> data) throws BGException {
        if (this.moduleId <= 0 || contractId <= 0 || id <= 0) {
            throw new BGIllegalArgumentException();
        }
        Connection con = this.getConnection();
        try {
            byte[] xmlData = null;
            String patternName = BillUtil.getPatternName(this.getSetup(), invoice ? "invoice" : "bill", con, this.moduleId, id);
            xmlData = invoice ? new InvoiceManager(con, this.moduleId).getXMLData(contractId, id) : new BillManager(con, this.moduleId).getXMLData(contractId, id);
            if (xmlData == null) {
                throw new BGIllegalArgumentException("documentNotFoundForContract");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(2000);
            final String fileName = this.docl2PDF(con, xmlData, patternName, invoice, baos);
            name.value = fileName;
            final ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            data.value = new DataHandler(new DataSource(){

                public String getContentType() {
                    return "application/pdf";
                }

                public InputStream getInputStream() throws IOException {
                    return bais;
                }

                public String getName() {
                    return fileName;
                }

                public OutputStream getOutputStream() throws IOException {
                    return null;
                }
            });
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private String docl2PDF(Connection con, byte[] data, String patternName, boolean invoice, OutputStream out) throws IOException, FOPException, BGException {
        Date date;
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        Document doc = XMLUtils.parseDocument((InputSource)new InputSource(bis));
        Element bill = (Element)doc.getDocumentElement().getElementsByTagName("bill").item(0);
        StringBuilder fileName = new StringBuilder(50);
        if (invoice) {
            fileName.append("Invoice_");
        } else {
            fileName.append("Bill_");
        }
        String contract = bill.getAttribute("contract");
        if (Utils.notBlankString((String)contract)) {
            fileName.append(contract).append("_");
        }
        if ((date = TimeUtils.parseDate((String)bill.getAttribute("date"), (String)"dd.MM.yyyy")) != null) {
            fileName.append(TimeUtils.format((Date)date, (String)"yyyyMMdd"));
        }
        fileName.append(".pdf");
        bill.setAttribute("with_stamp", "1");
        if (patternName.endsWith(".jrxml")) {
            JasperReport report = BGReportTemplate.getJasperReport((ParameterMap)this.getSetup(), (URI)new File("webroot/xsl/" + patternName).toURI());
            BGReportFilter reportFilter = new BGReportFilter(Collections.emptyMap(), (Preferences)this.getSetup(), this.userId);
            BGReportTemplate.fillReportToPdfStream((JasperReport)report, (BGReportFilter)reportFilter, (Connection)con, (Document)doc, (OutputStream)out);
        } else {
            XSLManager.getInstance().transform((Source)new DOMSource(doc), patternName, (Result)FOUtils.renderSAXResult((OutputStream)out, (String)"application/pdf"));
        }
        return fileName.toString();
    }

    public ru.bitel.common.model.Result<InvoiceDocument> invoiceDocumentListForContract(int contractId, boolean onlyReady, Page page) throws BGException {
        return new ru.bitel.common.model.Result(new InvoiceDocumentDao(this.getSetup(), (ParameterMap)this.getModuleSetup(), this.getConnection(), this.moduleId).list(contractId, onlyReady, page), page);
    }

    public void invoiceDocumentDownload(int contractId, int id, Holder<String> name, Holder<DataHandler> data) throws BGException {
        this.documentDownload(contractId, id, true, name, data);
    }

    public List<IdTitle> getBankAccountTitleList(int contractId, int organizationId, Boolean inUse, Holder<Integer> selectedItemId) throws BGException {
        try (ContractModuleConfigDao configDao = new ContractModuleConfigDao(this.getConnection(), this.moduleId);){
            selectedItemId.value = Utils.parseInteger((String)configDao.get(contractId, this.moduleId, "bank.account.id"), (Integer)0);
        }
        return new AccountManager(this.getConnection(), this.moduleId).getAccountTitleList(organizationId, inUse);
    }

    public void setBankAccount(int contractId, int selectedBabkAccountId) throws BGException {
        ContractModuleConfigDao configDao = new ContractModuleConfigDao(this.getConnection(), this.moduleId);
        if (selectedBabkAccountId == 0) {
            configDao.delete(contractId, this.moduleId, "bank.account.id");
        } else {
            configDao.update(contractId, this.moduleId, "bank.account.id", String.valueOf(selectedBabkAccountId));
        }
        configDao.close();
    }

    public List<BankAccount> getBankAccountList(int organizationId, Boolean inUse) throws BGException {
        return new AccountManager(this.getConnection(), this.moduleId).getBankAccountList(organizationId, inUse);
    }

    public void setDefaultBankAccount(BankAccount bankAccount) throws BGException {
        new AccountManager(this.getConnection(), this.moduleId).setDefaultBankAccount(bankAccount.getId(), bankAccount.getOrganizationId());
    }

    public BankAccount getDefaultBankAccount(int organizationId) throws BGException {
        return new AccountManager(this.getConnection(), this.moduleId).getDefaultBankAccount(organizationId);
    }

    public void updateBankAccount(BankAccount bankAccount) throws BGException {
        new AccountManager(this.getConnection(), this.moduleId).updateBankAccount(bankAccount);
    }

    public void deleteBankAccount(int bankAccountId) throws BGException {
        new AccountManager(this.getConnection(), this.moduleId).deleteBankAccount(bankAccountId);
    }

    public BankAccount getBankAccount(int bankAccountId) throws BGException {
        return new AccountManager(this.getConnection(), this.moduleId).getBankAccount(bankAccountId);
    }

    public List<Organization> getOrganizationList() throws BGException {
        ArrayList<Organization> list = new ArrayList<Organization>();
        try (OrganizationDao organizationDao = new OrganizationDao(this.getConnection(), this.moduleId);){
            list.addAll(organizationDao.getOrganizationList());
        }
        return list;
    }

    public void updateOrganization(Organization organization) throws BGException {
        try (OrganizationDao organizationDao = new OrganizationDao(this.getConnection(), this.moduleId);){
            organizationDao.update(organization);
        }
    }

    public void deleteOrganization(int organizationId) throws BGException {
        try (OrganizationDao organizationDao = new OrganizationDao(this.getConnection(), this.moduleId);){
            organizationDao.deleteOrganization(organizationId);
        }
    }

    public void setDefaultOrganization(int organizationId) throws BGException {
        try (OrganizationDao organizationDao = new OrganizationDao(this.getConnection(), this.moduleId);){
            organizationDao.setDefaultOrganization(organizationId);
        }
    }

    public void setOrganization(int contractId, int selectedOrganizationId) throws BGException {
        try (ContractModuleConfigDao configDao = new ContractModuleConfigDao(this.getConnection(), this.moduleId);){
            if (selectedOrganizationId == 0) {
                configDao.delete(contractId, this.moduleId, "organization.id");
            } else {
                configDao.update(contractId, this.moduleId, "organization.id", String.valueOf(selectedOrganizationId));
            }
        }
    }

    public List<IdTitle> getOrganizationTitleList(int contractId, Boolean inUse, Holder<Integer> selectedItemId) throws BGException {
        try (ContractModuleConfigDao contractModuleConfigDao = new ContractModuleConfigDao(this.getConnection(), this.moduleId);){
            List<IdTitle> list;
            try (OrganizationDao organizationDao = new OrganizationDao(this.getConnection(), this.moduleId);){
                selectedItemId.value = Utils.parseInteger((String)contractModuleConfigDao.get(contractId, this.moduleId, "organization.id"), (Integer)0);
                list = organizationDao.getOrganizationTitleList(inUse);
            }
            return list;
        }
    }

    public Organization getOrganization(int organizationId) throws BGException {
        try (OrganizationDao organizationDao = new OrganizationDao(this.getConnection(), this.moduleId);){
            Organization organization = organizationDao.getOrganization(organizationId);
            return organization;
        }
    }

    public Organization getDefaultOrganization() throws BGException {
        try (OrganizationDao organizationDao = new OrganizationDao(this.getConnection(), this.moduleId);){
            Organization organization = organizationDao.getDefaultOrganization();
            return organization;
        }
    }

    public DocType docTypeGet(int id) throws BGException {
        return new DocTypeManager(this.getConnection(), this.moduleId).getType(id);
    }

    public void docTypeUpdate(DocType dt) throws BGException {
        new DocTypeManager(this.getConnection(), this.moduleId).updateType(dt);
    }

    public void docTypeDelete(int id) throws BGException {
        new DocTypeManager(this.getConnection(), this.moduleId).deleteType(id);
    }

    public List<DocType> docTypeList(DocumentType documentType) throws BGException {
        return new DocTypeManager(this.getConnection(), this.moduleId).getTypeList(documentType);
    }

    public List<DocType> docTypeListForContract(int contractId, DocumentType documentType) throws BGException {
        ArrayList<DocType> list = new ArrayList<DocType>();
        ContractDocTypeManager cdtm = new ContractDocTypeManager(this.getConnection(), this.moduleId);
        List<ContractDocType> selected = cdtm.getContractTypeList(contractId, documentType, null);
        block0: for (DocType docType : new DocTypeManager(this.getConnection(), this.moduleId).getTypeList(documentType)) {
            for (ContractDocType contractDocType : selected) {
                if (contractDocType.getDocTypeId() != docType.getId()) continue;
                list.add(docType);
                continue block0;
            }
        }
        return list;
    }

    public List<IdTitle> positionList(DocumentType documentType) throws BGException {
        try (PositionDao positionDao = new PositionDao(this.getConnection(), this.moduleId, documentType);){
            ArrayList<IdTitle> list = new ArrayList<IdTitle>();
            for (Position p : positionDao.getPositonList()) {
                list.add(new IdTitle(p.getId(), p.getTitle()));
            }
            ArrayList<IdTitle> arrayList = list;
            return arrayList;
        }
    }

    public MapHolder<Integer, List<IdTitle>> xmlComposition() throws BGException {
        MapHolder map = new MapHolder();
        ArrayList<IdTitle> moduleList = new ArrayList<IdTitle>();
        ArrayList<IdTitle> pluginList = new ArrayList<IdTitle>();
        for (BGModule module : ModuleCache.getInstance().getModulesList()) {
            moduleList.add(new IdTitle(module.getId(), module.getTitle()));
        }
        for (BGPluginServer pluginServer : BGPluginManagerServer.getManager().getPluginsMap().values()) {
            pluginList.add(new IdTitle(pluginServer.getPluginUID(), pluginServer.getName()));
        }
        map.getMap().put(1, moduleList);
        map.getMap().put(2, pluginList);
        return map;
    }

    public SearchResult<Position> searchPositionList(DocumentType documentType, Page page) throws BGException, BGMessageException {
        try (PositionDao positionDao = new PositionDao(this.getConnection(), this.moduleId, documentType);){
            SearchResult<Position> searchResult = positionDao.searchPositionList(page);
            return searchResult;
        }
    }

    public Position positionGet(DocumentType documentType, int positionId) throws BGException, BGMessageException {
        try (PositionDao positionDao = new PositionDao(this.getConnection(), this.moduleId, documentType);){
            Position position = positionDao.getPosition(positionId);
            return position;
        }
    }

    public Position positionUpdate(DocumentType documentType, Position position) throws BGException, BGMessageException {
        try (PositionDao positionDao = new PositionDao(this.getConnection(), this.moduleId, documentType);){
            Position position2 = positionDao.updatePosition(position);
            return position2;
        }
    }

    public boolean positionDelete(DocumentType documentType, int positionId) throws BGException, BGMessageException {
        try (PositionDao positionDao = new PositionDao(this.getConnection(), this.moduleId, documentType);){
            boolean bl = positionDao.deletePosition(positionId);
            return bl;
        }
    }
}

