/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.bonus.client;

import bitel.billing.module.admin.ContractGroupOperation;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.IntTextField;
import bitel.billing.module.common.ListItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGCalendarButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusPaymentType;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusProgram;
import ru.bitel.bgbilling.plugins.bonus.common.service.BonusService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class ContractGroupOperationFactory
implements ContractGroupOperation.ContractGroupOperationFactory {
    public Collection<ContractGroupOperation.ContractGroupOperationItem> getContractGroupOperations(String mid, String title) {
        ArrayList<ContractGroupOperation.ContractGroupOperationItem> list = new ArrayList<ContractGroupOperation.ContractGroupOperationItem>(1);
        list.add(new AddTagOperationItem(title));
        list.add(new ExtendPaymentOperationItem(title));
        return list;
    }

    private class AddTagOperationItem
    extends ContractGroupOperation.ContractGroupOperationItem {
        private final String pluginTitle;
        private JCheckBox turnOnOff;
        private BGControlPanelListSelect programListSelect;
        private BGControlPanelPeriod period;
        private List<BonusProgram> programList;

        public AddTagOperationItem(String pluginTitle) {
            super((LayoutManager)new GridBagLayout());
            this.turnOnOff = new JCheckBox("\u0412\u043a\u043b\u044e\u0447\u0435\u043d", true);
            this.programListSelect = new BGControlPanelListSelect();
            this.period = new BGControlPanelPeriod();
            this.pluginTitle = pluginTitle;
            this.period.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    AddTagOperationItem.this.setProgramInListSelect();
                    AddTagOperationItem.this.programListSelect.setEnabled(AddTagOperationItem.this.period.getDateFrom() != null);
                }
            });
        }

        protected void jbInit() throws Exception {
            this.programListSelect.setBorder((Border)new BGTitleBorder(" \u0411\u043e\u043d\u0443\u0441\u043d\u044b\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b "));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.period, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)this.turnOnOff, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.programListSelect, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
            this.add(panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
            this.programListSelect.setEnabled(false);
        }

        protected void setData() {
            try {
                this.programList = ((BonusService)((ClientContext)this.getContext()).getPort(BonusService.class)).programList(null);
                this.setProgramInListSelect();
            }
            catch (BGException e) {
                ((ClientContext)this.getContext()).processException((Throwable)e);
            }
        }

        private void setProgramInListSelect() {
            DefaultListModel<ListItem> model = new DefaultListModel<ListItem>();
            if (this.programList != null) {
                for (BonusProgram program : this.programList) {
                    Date periodDateFrom = this.period.getDateFrom();
                    Date programPeriodDateFrom = program.getPeriod().getDateFrom();
                    if (periodDateFrom != null && programPeriodDateFrom != null && periodDateFrom.compareTo(programPeriodDateFrom) < 0) continue;
                    Date periodDateTo = this.period.getDateTo();
                    Date programPeriodDateTo = program.getPeriod().getDateTo();
                    if (periodDateTo != null && programPeriodDateTo != null && periodDateTo.compareTo(programPeriodDateTo) > 0 || programPeriodDateTo != null && programPeriodDateTo.compareTo(new Date()) < 0) continue;
                    ListItem listItem = new ListItem(program.getTitle(), false);
                    listItem.setAttribute("program", (Object)program);
                    model.addElement(listItem);
                }
                this.programListSelect.getList().setModel(model);
            }
        }

        protected boolean doItemOperation(String cids) {
            try {
                ArrayList<BonusProgram> programs = new ArrayList<BonusProgram>();
                DefaultListModel model = (DefaultListModel)this.programListSelect.getList().getModel();
                for (int i = 0; i < model.getSize(); ++i) {
                    ListItem item = (ListItem)model.elementAt(i);
                    if (!item.isSelected()) continue;
                    programs.add((BonusProgram)item.getAttribute("program"));
                }
                ((BonusService)((ClientContext)this.getContext()).getPort(BonusService.class)).updateProgramAndPluginIncludeGroupOperation(programs, cids, this.period.getPeriod(), this.turnOnOff.isSelected());
            }
            catch (BGException e) {
                ((ClientContext)this.getContext()).processException((Throwable)e);
            }
            return true;
        }

        protected String getOperationTitle() {
            return this.pluginTitle + ": \u0412\u043a\u043b/\u0432\u044b\u043a\u043b \u043f\u043b\u0430\u0433\u0438\u043d\u0430, \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0431\u043e\u043d\u0443\u0441. \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430\u043c";
        }
    }

    private class ExtendPaymentOperationItem
    extends ContractGroupOperation.ContractGroupOperationItem {
        private final String pluginTitle;
        private BGControlPanelListSelect paymentTypeListSelect;
        private BGControlPanelPeriod paymentPeriod;
        private BGComboBox<IdTitle> typesComboBox;
        private JCheckBox onlyActive;
        private BGCalendarButton datePanel;
        private IntTextField daysTextField;

        public ExtendPaymentOperationItem(String title) {
            super((LayoutManager)new GridBagLayout());
            this.paymentTypeListSelect = new BGControlPanelListSelect();
            this.paymentPeriod = new BGControlPanelPeriod();
            this.typesComboBox = new BGComboBox();
            this.onlyActive = new JCheckBox("\u0422\u043e\u043b\u044c\u043a\u043e \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0438", true);
            this.datePanel = new BGCalendarButton();
            this.daysTextField = new IntTextField(9);
            this.pluginTitle = title;
        }

        protected void setData() {
            try {
                DefaultListModel<ListItem> modelPayment = new DefaultListModel<ListItem>();
                for (BonusPaymentType paymentType : ((BonusService)((ClientContext)this.getContext()).getPort(BonusService.class)).paymentTypeList(true)) {
                    ListItem listItem = new ListItem(paymentType.getTitle(), false);
                    listItem.setAttribute("paymentTypeId", (Object)paymentType.getId());
                    modelPayment.addElement(listItem);
                }
                this.paymentTypeListSelect.getList().setModel(modelPayment);
                this.typesComboBox.setModel(new DefaultComboBoxModel<IdTitle>(new IdTitle[]{new IdTitle(1, "\u0414\u043e \u0434\u0430\u0442\u044b"), new IdTitle(2, "\u041d\u0430 \u043a\u043e\u043b-\u0432\u043e \u0434\u043d\u0435\u0439")}));
            }
            catch (BGException e) {
                ((ClientContext)this.getContext()).processException((Throwable)e);
            }
        }

        protected void jbInit() throws Exception {
            this.paymentPeriod.setTitleBorderName(" \u041f\u043b\u0430\u0442\u0435\u0436\u0438 \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434 ");
            this.paymentTypeListSelect.setBorder((Border)new BGTitleBorder(" \u0422\u0438\u043f\u044b \u0431\u043e\u043d\u0443\u0441\u043d\u044b\u0445 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 "));
            JTextArea area = this.getTextArea("\u0418\u0437\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u0430 bonus_contract_payment");
            area.setMinimumSize(new Dimension(20, area.getMinimumSize().height));
            area.setPreferredSize(new Dimension(20, area.getPreferredSize().height));
            JPanel typePanel = new JPanel(new GridBagLayout());
            typePanel.setBorder((Border)new BGTitleBorder(" \u0422\u0438\u043f \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u044f \u0438 \u0435\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434 "));
            typePanel.add((Component)this.typesComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            typePanel.add((Component)this.datePanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
            typePanel.add((Component)this.daysTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)area, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 10, 5), 0, 0));
            panel.add((Component)this.onlyActive, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 10, 5), 0, 0));
            panel.add((Component)this.paymentPeriod, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)typePanel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)this.paymentTypeListSelect, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
            this.add(panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
            this.daysTextField.setVisible(false);
            this.typesComboBox.addActionListener(a -> {
                IdTitle selectType = (IdTitle)this.typesComboBox.getSelectedItem();
                if (selectType != null) {
                    this.datePanel.setVisible(selectType.getId() == 1);
                    this.daysTextField.setVisible(selectType.getId() == 2);
                }
            });
        }

        protected boolean doItemOperation(String cids) {
            try {
                Object valueExtend;
                HashSet<Integer> types = new HashSet<Integer>();
                DefaultListModel model = (DefaultListModel)this.paymentTypeListSelect.getList().getModel();
                for (int i = 0; i < model.getSize(); ++i) {
                    ListItem item = (ListItem)model.elementAt(i);
                    if (!item.isSelected()) continue;
                    types.add((Integer)item.getAttribute("paymentTypeId"));
                }
                int typeExtend = ((IdTitle)this.typesComboBox.getSelectedItem()).getId();
                if (typeExtend == 1) {
                    valueExtend = TimeUtils.format((Calendar)this.datePanel.getCalendar(), (String)"dd.MM.yyyy");
                } else {
                    int days = Utils.parseInt((String)this.daysTextField.getText(), (int)-1);
                    valueExtend = "" + days;
                }
                ((BonusService)((ClientContext)this.getContext()).getPort(BonusService.class)).extendPaymentsGroupOperation(cids, this.paymentPeriod.getPeriod(), types, typeExtend, (String)valueExtend, this.onlyActive.isSelected());
            }
            catch (BGException e) {
                ((ClientContext)this.getContext()).processException((Throwable)e);
            }
            return true;
        }

        protected String getOperationTitle() {
            return this.pluginTitle + ": \u041f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0431\u043e\u043d\u0443\u0441\u043d\u044b\u0445 \u043f\u0440\u0438\u0445\u043e\u0434\u043e\u0432";
        }
    }
}

