/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.bonus.client.contract;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.contract.ContractPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusContractProgram;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusProgram;
import ru.bitel.bgbilling.plugins.bonus.common.service.BonusService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.table.BGTableModel;

public class ContractPanel_Bonus
extends ContractPanel {
    private JCheckBox turnOnOff = new JCheckBox("\u0412\u043a\u043b\u044e\u0447\u0435\u043d");
    private BonusContractProgramTableModel tableModel = new BonusContractProgramTableModel();
    private BGUTable programTable = new BGUTable((TableModel)((Object)this.tableModel));
    private HashMap<Integer, BonusProgram> programMap = new HashMap();
    private Set<Integer> installedProgramsSet;
    private BonusService bonusService;
    private JPopupMenu popupMenu;

    public ContractPanel_Bonus() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            this.getContext().processException((Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        JPanel programPanel = new JPanel(new GridBagLayout());
        programPanel.setBorder(new TitledBorder("\u0411\u043e\u043d\u0443\u0441\u043d\u044b\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b"));
        programPanel.add((Component)new JScrollPane((Component)this.programTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(this.turnOnOff, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 11, new Insets(10, 10, 0, 0), 0, 0));
        this.add(programPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.turnOnOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    ContractPanel_Bonus.this.getBonusService().updatePluginInclude(ContractPanel_Bonus.this.getContractId(), ContractPanel_Bonus.this.turnOnOff.isSelected());
                    ContractPanel_Bonus.this.setData();
                }
                catch (BGException e) {
                    ContractPanel_Bonus.this.getContext().processException((Throwable)e);
                }
            }
        });
        this.programTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                super.mouseClicked(event);
                if (SwingUtilities.isLeftMouseButton(event) && event.getClickCount() == 2) {
                    ContractPanel_Bonus.this.editItem();
                } else if (ContractPanel_Bonus.this.getPopupMenu() != null && SwingUtilities.isRightMouseButton(event) && ContractPanel_Bonus.this.programTable.pointOnSelectRows(event.getPoint())) {
                    ContractPanel_Bonus.this.getPopupMenu().show((Component)ContractPanel_Bonus.this.programTable, event.getX(), event.getY());
                }
            }
        });
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b");
            menuItem.addActionListener(e -> {
                BonusContractProgram bonusContractProgram = (BonusContractProgram)this.tableModel.getSelectedRow();
                try {
                    JTextArea textArea = new JTextArea(this.getBonusService().getDataProgramOfContract(bonusContractProgram.getProgram().getId(), bonusContractProgram.getContractId()), 20, 50);
                    textArea.setMargin(new Insets(5, 5, 5, 5));
                    textArea.setEditable(false);
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), new JScrollPane(textArea), "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b", 1);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            });
            this.popupMenu.add(menuItem);
        }
        return this.popupMenu;
    }

    public void setData() {
        try {
            this.turnOnOff.setSelected(this.getBonusService().pluginInclude(this.getContractId()));
            List installedProgams = this.getBonusService().programContractList(this.getContractId());
            this.tableModel.setData(installedProgams);
            this.installedProgramsSet = new HashSet<Integer>();
            for (BonusContractProgram cProgram : installedProgams) {
                this.installedProgramsSet.add(cProgram.getProgram().getId());
            }
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((String)ex.getLocalizedMessage());
        }
    }

    public void newItem() {
        try {
            List programList = this.getBonusService().programList(new Date());
            if (programList.size() == 0) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0437\u0430\u0432\u0435\u0434\u0435\u043d\u044b \u0431\u043e\u043d\u0443\u0441\u043d\u044b\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b!");
                return;
            }
            if (this.installedProgramsSet.size() == programList.size()) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0441\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0443\u0436\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430!");
                return;
            }
            new BonusEditor("\u041d\u043e\u0432\u0430\u044f \u0431\u043e\u043d\u0443\u0441\u043d\u0430\u044f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430", new BonusContractProgram(), programList).getDialog().setVisible(true);
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    public void editItem() {
        BonusContractProgram bonusContractProgram = (BonusContractProgram)this.tableModel.getSelectedRow();
        if (bonusContractProgram == null) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u0431\u043e\u043d\u0443\u0441\u043d\u0430\u044f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u0443 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
            return;
        }
        try {
            new BonusEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0431\u043e\u043d\u0443\u0441\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b", bonusContractProgram, this.getBonusService().programList(null)).getDialog().setVisible(true);
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    public void deleteItem() {
        super.deleteItem();
    }

    private BonusService getBonusService() {
        if (this.bonusService == null) {
            this.bonusService = (BonusService)this.getContext().getPort(BonusService.class);
        }
        return this.bonusService;
    }

    class BonusContractProgramTableModel
    extends BGTableModel<BonusContractProgram> {
        public BonusContractProgramTableModel() {
            super(BonusContractProgramTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("ID \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b", 100, 100, 100, "id", true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER);
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 200, 200, 200, "period", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u0422\u0438\u043f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b", String.class, -1, 350, 500, "titleType", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", String.class, -1, -1, -1, "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
        }

        public Object getValue(BonusContractProgram value, int column) throws BGException {
            Object result = null;
            String identifier = this.getIdentifier(column);
            result = "id".equals(identifier) ? Integer.valueOf(value.getProgram().getId()) : ("titleType".equals(identifier) ? value.getProgram().getSpecificationTitle() : ("title".equals(identifier) ? value.getProgram().getTitle() : super.getValue((Object)value, column)));
            return result;
        }
    }

    class BonusEditor
    extends BGEditorDialog<BonusContractProgram> {
        private BGComboBox<ComboBoxItem> programComboBox;
        private BGControlPanelPeriodNoB period;

        public BonusEditor(String title, BonusContractProgram program, List<BonusProgram> programList) {
            super(title, (Object)program);
            this.programComboBox = new BGComboBox();
            this.period = new BGControlPanelPeriodNoB();
            DefaultComboBoxModel<ComboBoxItem> model = new DefaultComboBoxModel<ComboBoxItem>();
            for (BonusProgram bonusProgram : programList) {
                if (ContractPanel_Bonus.this.installedProgramsSet.contains(bonusProgram.getId()) && program.getProgram() == null) continue;
                model.addElement(new ComboBoxItem(bonusProgram.getId(), bonusProgram.getTitle()));
                ContractPanel_Bonus.this.programMap.put(bonusProgram.getId(), bonusProgram);
            }
            this.programComboBox.setModel(model);
            if (program.getProgram() != null) {
                this.programComboBox.setSelectedId(Integer.toString(program.getProgram().getId()));
                this.programComboBox.setEnabled(false);
                this.period.setPeriod(program.getPeriod());
            } else {
                this.programComboBox.setSelectedIndex(-1);
                this.programComboBox.setEnabled(true);
                this.period.setLocalDateFrom(LocalDate.now());
                this.period.setLocalDateTo(null);
            }
        }

        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 11, new Insets(0, 10, 0, 0), 0, 0));
            this.panel.add((Component)this.period, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 11, new Insets(2, 5, 5, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0411\u043e\u043d\u0443\u0441\u043d\u0430\u044f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 11, new Insets(10, 10, 0, 0), 0, 0));
            this.panel.add((Component)this.programComboBox, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 5, 0), 0, 0));
        }

        public boolean doApply() throws Exception {
            if (this.period.getDateCalendar1() == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0441\u0442\u0430\u0432\u0438\u0442\u0435 \u043f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u0440\u0438\u0445\u043e\u0434\u0430");
                return false;
            }
            if (this.period.getDateCalendar2() != null && this.period.getDateCalendar1() != null && this.period.getDateCalendar1().compareTo(this.period.getDateCalendar2()) > 0) {
                ClientUtils.showErrorMessageDialog((String)"\u041f\u0435\u0440\u0432\u0430\u044f \u0434\u0430\u0442\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435!");
                return false;
            }
            int programId = Utils.parseInt((String)this.programComboBox.getSelectedId(), (int)-1);
            if (programId < 1) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u0431\u043e\u043d\u0443\u0441\u043d\u0430\u044f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430");
                return false;
            }
            ((BonusContractProgram)this.data).setContractId(ContractPanel_Bonus.this.getContractId());
            ((BonusContractProgram)this.data).setProgram(ContractPanel_Bonus.this.programMap.get(programId));
            ((BonusContractProgram)this.data).setPeriod(this.period.getPeriod());
            try {
                ContractPanel_Bonus.this.getBonusService().programContractUpdate((BonusContractProgram)this.data);
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
                return false;
            }
            ContractPanel_Bonus.this.setData();
            return true;
        }
    }
}

