/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.bean;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractAddressParamValue;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractParameterManager;
import java.sql.Connection;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.server.bean.ContractParameterPrefDao;
import ru.bitel.common.Utils;
import ru.bitel.common.util.MacrosFormat;

public class BGMacrosFormat
extends MacrosFormat {
    private final Connection con;
    private final int cid;
    private ContractParameterManager cpm;
    private List<ContractParameterPref> prefs;
    private BalanceUtils bu;
    private ContractManager cm;
    private Contract contract;

    public ContractParameterManager getCpm() {
        if (this.cpm == null) {
            try (ContractParameterPrefDao dao = new ContractParameterPrefDao(this.con);){
                this.cpm = new ContractParameterManager(this.con);
                this.prefs = dao.getAllContractParameterPrefList();
            }
            catch (BGException e) {
                e.printStackTrace();
            }
        }
        return this.cpm;
    }

    public BalanceUtils getBalanceUtils() {
        if (this.bu == null) {
            this.bu = new BalanceUtils(this.con);
        }
        return this.bu;
    }

    public ContractManager getContractManager() {
        if (this.cm == null) {
            this.cm = new ContractManager(this.con);
        }
        return this.cm;
    }

    public Contract getContract(int cid) {
        if (this.contract == null || this.contract.getId() != cid) {
            this.contract = this.getContractManager().getContractById(cid);
        }
        return this.contract;
    }

    public BGMacrosFormat(Connection con, int mid, int cid) {
        this.con = con;
        this.cid = cid;
    }

    public BGMacrosFormat(Connection con, int mid, Contract contract) {
        this.con = con;
        this.cid = contract.getId();
        this.contract = contract;
    }

    protected Object invoke(String macros, Object[] args) {
        if ("contract_param".equals(macros)) {
            if (args.length > 0) {
                int pid = this.getInt(args, 0, 0);
                ContractParameterManager cpm = this.getCpm();
                for (ContractParameterPref pref : this.prefs) {
                    if (pref.getId() != pid) continue;
                    switch (pref.getType().getId()) {
                        case 1: {
                            return Utils.maskNull((String)cpm.getStringParam(this.cid, pid));
                        }
                        case 2: {
                            ContractAddressParamValue value = cpm.getAddressParam(this.cid, pid);
                            return value != null ? value.getAddress() : "";
                        }
                    }
                    break;
                }
            }
        } else {
            if ("contract_balance".equals(macros)) {
                return this.getBalanceUtils().getBalance(new Date(), this.cid);
            }
            if ("contract_title".equals(macros)) {
                Contract contract = this.getContract(this.cid);
                return contract != null ? contract.getTitle() : null;
            }
            if ("contract_comment".equals(macros)) {
                Contract contract = this.getContract(this.cid);
                return contract != null ? contract.getComment() : "";
            }
        }
        return null;
    }
}

