/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.client;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.plugins.cashcheck.client.ManagerQueue;
import ru.bitel.bgbilling.plugins.cashcheck.client.PosLoginDialog;
import ru.bitel.bgbilling.plugins.cashcheck.common.BGPrinterNotloggedMessageException;
import ru.bitel.bgbilling.plugins.cashcheck.common.CashcheckService;
import ru.bitel.bgbilling.plugins.cashcheck.common.PrintCheckData;
import ru.bitel.common.client.table.BasicBGTableModel;
import ru.bitel.common.model.Id;

public class PopupMenuAction
implements ActionListener {
    private void printCheckFromContract(List<Payment> payments) throws BGException {
        if (payments == null || payments.isEmpty()) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u043d\u0438 \u043e\u0434\u0438\u043d \u043f\u043b\u0430\u0442\u0451\u0436! \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0434\u043d\u0443 \u0438\u043b\u0438 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0441\u0442\u0440\u043e\u043a!");
            return;
        }
        ClientContext context = new ClientContext("ru.bitel.bgbilling.plugins.cashcheck", 0, 0, "");
        Directory paymentTypeDirectory = context.getDirectory(PaymentType.class);
        StringBuffer sb = new StringBuffer(1024);
        int colnum = 1;
        BigDecimal summaTotal = BigDecimal.ZERO;
        for (Payment row : payments) {
            String paymentTypeTitle = paymentTypeDirectory.get(row.getTypeId()) == null ? "<\u0422\u0438\u043f \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>" : ((PaymentType)paymentTypeDirectory.get(row.getTypeId())).getTitle();
            sb.append(colnum++).append(") ");
            sb.append(paymentTypeTitle).append(" | ");
            sb.append(row.getSum()).append(" | ");
            sb.append(row.getComment()).append("\n");
            summaTotal = summaTotal.add(row.getSum());
        }
        BigDecimal fsumma = ManagerQueue.getClientSumma(sb.toString(), summaTotal);
        if (fsumma != null) {
            try {
                PrintCheckData pc = ((CashcheckService)context.getPort(CashcheckService.class)).printCheck(Id.newIdList(payments), fsumma);
                String submitRet = pc.submit;
                String summaRet = pc.summa;
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u043d \u0447\u0435\u043a \u043d\u0430 \u0441\u0443\u043c\u043c\u0443: " + summaRet + "\n\n\u0421\u0434\u0430\u0447\u0430: " + submitRet);
            }
            catch (BGPrinterNotloggedMessageException e) {
                ClientUtils.showErrorMessageDialog((String)("\u041e\u0448\u0438\u0431\u043a\u0430! " + e.getMessage()));
                PosLoginDialog posLoginDialog = new PosLoginDialog();
                if ("1".equals(posLoginDialog.showDialog())) {
                    this.printCheckFromContract(payments);
                    return;
                }
                ClientUtils.warning((String)"\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u0427\u0435\u043a \u043d\u0435 \u0431\u044b\u043b \u043d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u043d.", (String)"\u0427\u0435\u043a \u043d\u0435 \u043d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u043d");
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog((String)("\u041e\u0448\u0438\u0431\u043a\u0430! " + e.getMessage()));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("printCheck".equals(actionEvent.getActionCommand())) {
            try {
                BGUTable co2 = (BGUTable)((JPopupMenu)((JMenuItem)actionEvent.getSource()).getParent()).getInvoker();
                List paymentList = ((BasicBGTableModel)co2.getModel()).getSelectedRows();
                this.printCheckFromContract(paymentList);
            }
            catch (Exception _e) {
                ClientUtils.showErrorMessageDialog((String)("\u042d\u0442\u043e \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442: " + _e.toString()));
                _e.printStackTrace();
            }
        }
    }
}

