/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.cashcheck.frk.driver.atol3;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Map;
import jssc.SerialPortList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.ICashCheckDriver;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.atol3.AtolPrinter;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.atol3.AtolPrinterType;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.atol3.PrinterAtolErrorException;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.atol3.PrinterStatus;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.DriverException;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.NotImplementedException;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.PrinterConnectException;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.PrinterErrorException;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.BGByteBuffer;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.FrkUtils;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.SerialParameters;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;
import ru.bitel.common.Utils;

public class Driver
implements ICashCheckDriver {
    private SerialParameters serialParameters = new SerialParameters();
    private static final Logger logger = LogManager.getLogger();
    private AtolPrinterType printerType = AtolPrinterType.UNKNOWN;
    private int accessPassword = 0;
    private boolean cutterDisabled = false;
    private boolean cutterForceManual = false;
    private int checkWidth = -1;

    @Override
    public void init(Map<String, String> config) throws Exception {
        this.serialParameters.setFlowControlIn(0);
        this.serialParameters.setFlowControlOut(0);
        this.serialParameters.setDatabits(8);
        this.serialParameters.setStopbits(1);
        this.serialParameters.setParity(0);
        if (config.containsKey("portName")) {
            this.serialParameters.setPortName(config.get("portName"));
        }
        if (config.containsKey("baudRate")) {
            this.serialParameters.setBaudRate(config.get("baudRate"));
        }
        if (config.containsKey("type")) {
            try {
                this.printerType = AtolPrinterType.valueOf(config.get("type"));
            }
            catch (Exception e) {
                throw new Exception("parameter 'type' error (" + config.get("type") + ")");
            }
        } else {
            throw new Exception("parameter 'type' must be specified");
        }
        if (config.containsKey("accessPassword")) {
            this.accessPassword = FrkUtils.parseInt(config.get("accessPassword"));
        }
        this.cutterDisabled = Utils.parseBoolean((String)config.get("cutterDisabled"), (boolean)this.cutterDisabled);
        this.cutterForceManual = Utils.parseBoolean((String)config.get("cutterForceManual"), (boolean)this.cutterForceManual);
        this.checkWidth = Utils.parseInt((String)config.get("checkWidth"), (int)this.checkWidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void touchDriver() throws Exception {
        StringBuilder sb = new StringBuilder();
        String[] portNames = SerialPortList.getPortNames();
        sb.append("available serial ports:\n");
        for (String portName : portNames) {
            sb.append(portName).append("\n");
        }
        if (portNames.length <= 0) {
            sb.append("not available com ports!\n");
        }
        logger.debug(sb.toString());
        int[] baudrates = new int[]{1200, 2400, 4800, 9600, 14400, 38400, 57600, 115200};
        int[] flowcontrolins = new int[]{0};
        int[] flowcontrolouts = new int[]{0};
        int[] databits = new int[]{8};
        int[] stopbits = new int[]{1};
        int[] paritys = new int[]{0};
        SerialParameters portParam = new SerialParameters();
        AtolPrinter printer = new AtolPrinter(portParam, AtolPrinterType.UNKNOWN, 0L, 0L, logger);
        for (String comport : portNames) {
            portParam.setPortName(comport);
            for (int baudRate : baudrates) {
                portParam.setBaudRate(baudRate);
                for (int flowControlIn : flowcontrolins) {
                    portParam.setFlowControlIn(flowControlIn);
                    for (int flowControlOut : flowcontrolouts) {
                        portParam.setFlowControlOut(flowControlOut);
                        for (int databit : databits) {
                            portParam.setDatabits(databit);
                            for (int stopbit : stopbits) {
                                portParam.setStopbits(stopbit);
                                for (int parity : paritys) {
                                    portParam.setParity(parity);
                                    sb = new StringBuilder();
                                    sb.append(portParam.getPortName()).append(",BR:").append(portParam.getBaudRateString()).append(",DB:").append(portParam.getDatabitsString()).append(",SB:").append(portParam.getStopbitsString()).append(",P:").append(portParam.getParityString());
                                    Object message = null;
                                    try {
                                        printer.open();
                                        message = printer.touch();
                                    }
                                    catch (Throwable e) {
                                        message = "device touch error: " + e.toString();
                                    }
                                    finally {
                                        printer.close();
                                    }
                                    sb.append(" -> ").append((String)message).append("\n");
                                    logger.debug(sb.toString());
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getStatus() {
        return this.serialParameters.getStringStatus() + ", printerType: " + this.printerType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void buzzer(String operatorPass) throws PrinterAtolErrorException, PrinterConnectException, DriverException {
        int oppass = FrkUtils.parseInt(operatorPass);
        try (AtolPrinter printer = new AtolPrinter(this.serialParameters, this.printerType, this.accessPassword, oppass, logger);){
            printer.open();
            printer.buzzer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String name(String operatorPass) throws PrinterConnectException, PrinterErrorException, DriverException {
        int oppass = FrkUtils.parseInt(operatorPass);
        String name = null;
        try (AtolPrinter printer = new AtolPrinter(this.serialParameters, this.printerType, this.accessPassword, oppass, logger);){
            printer.open();
            name = printer.getName();
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String status(String operatorPass) throws PrinterConnectException, PrinterErrorException, DriverException {
        int oppass = FrkUtils.parseInt(operatorPass);
        String status = null;
        try (AtolPrinter printer = new AtolPrinter(this.serialParameters, this.printerType, this.accessPassword, oppass, logger);){
            printer.open();
            PrinterStatus ps = printer.getStatus();
            status = this.getStringStatus(ps);
        }
        return status;
    }

    private String getStringStatus(PrinterStatus ps) {
        StringBuffer status = new StringBuffer(1024);
        status.append("\u041a\u0430\u0441\u0441\u0438\u0440: ").append(ps.cashman);
        status.append("\n\u041d\u043e\u043c\u0435\u0440 \u0432 \u0437\u0430\u043b\u0435: ").append(ps.number);
        status.append("\n\u041f\u043e\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u0445 \u0447\u0430\u0441\u043e\u0432 \u041a\u041a\u041c: ").append(ps.datetime);
        status.append("\n\u041a\u041a\u041c \u0444\u0438\u0441\u043a\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u0430: ").append(ps.isFiscal ? "\u0434\u0430" : "\u043d\u0435\u0442");
        status.append("\n\u0421\u043c\u0435\u043d\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u0430: ").append(ps.isDayOpen ? "\u0434\u0430" : "\u043d\u0435\u0442");
        status.append("\n\u0414\u0435\u043d\u0435\u0436\u043d\u044b\u0439 \u044f\u0449\u0438\u043a \u043e\u0442\u043a\u0440\u044b\u0442: ").append(ps.isCashBoxNotOpen ? "\u043d\u0435\u0442" : "\u0434\u0430");
        status.append("\n\u0412\u0435\u0441\u043e\u0432\u043e\u0439 \u0434\u0430\u0442\u0447\u0438\u043a \u0427\u041b: ").append(ps.isWeightPaperHave ? "\u0435\u0441\u0442\u044c \u0431\u0443\u043c\u0430\u0433\u0430" : "\u043d\u0435\u0442 \u0431\u0443\u043c\u0430\u0433\u0438");
        if (!this.printerType.isSensorPaperWeight()) {
            status.append(" (\u043c\u043e\u0434\u0435\u043b\u044c \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0434\u0430\u0442\u0447\u0438\u043a\u0430)");
        }
        status.append("\n\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0434\u0430\u0442\u0447\u0438\u043a\u0430 \u043a\u0440\u044b\u0448\u043a\u0438: \u043a\u0440\u044b\u0448\u043a\u0430 ").append(ps.isCoverOpen ? "\u043e\u0442\u043a\u0440\u044b\u0442\u0430" : "\u0437\u0430\u043a\u0440\u044b\u0442\u0430");
        if (!this.printerType.isSensorCover()) {
            status.append(" (\u043c\u043e\u0434\u0435\u043b\u044c \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0434\u0430\u0442\u0447\u0438\u043a\u0430)");
        }
        status.append("\n\u041d\u0430\u043f\u0440\u044f\u0436\u0435\u043d\u0438\u0435 \u0431\u0430\u0442\u0430\u0440\u0435\u0439\u043a\u0438: ").append(ps.isBatteriesLow ? "\u041d\u0418\u0417\u041a\u041e" : "\u043d\u043e\u0440\u043c\u0430\u043b\u044c\u043d\u043e");
        if (!this.printerType.isSensorBatteries()) {
            status.append(" (\u043c\u043e\u0434\u0435\u043b\u044c \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0434\u0430\u0442\u0447\u0438\u043a\u0430)");
        }
        status.append("\n\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0424\u041d: ").append(ps.isActiveFN ? "\u0430\u043a\u0442\u0438\u0432\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d" : "\u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d");
        if (!this.printerType.isFN()) {
            status.append(" (\u043c\u043e\u0434\u0435\u043b\u044c \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0424\u041d?)");
        }
        status.append("\n\u0417\u0430\u0432\u043e\u0434\u0441\u043a\u043e\u0439 \u043d\u043e\u043c\u0435\u0440: ").append(ps.serial);
        status.append("\n\u041c\u043e\u0434\u0435\u043b\u044c: ").append(ps.modelName);
        status.append("\n\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 (\u0440\u0435\u0436\u0438\u043c): ").append(ps.mode.toString());
        status.append("\n\u041d\u043e\u043c\u0435\u0440 \u0447\u0435\u043a\u0430 (\u043d\u043e\u043c\u0435\u0440 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e+1): ").append(ps.checkNumber);
        status.append("\n\u041d\u043e\u043c\u0435\u0440 \u0441\u043c\u0435\u043d\u044b (\u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u0439): ").append(ps.dayNumber);
        status.append("\n\u0421\u0443\u043c\u043c\u0430 \u0447\u0435\u043a\u0430: ").append(FrkUtils.formatMDE(ps.checkSum));
        status.append("\n\u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0434\u0435\u0441\u044f\u0442\u0438\u0447\u043d\u043e\u0439 \u0442\u043e\u0447\u043a\u0438: ").append(ps.decimalDot);
        status.append("\n\u041d\u043e\u043c\u0435\u0440 \u043f\u043e\u0440\u0442\u0430 \u041a\u041a\u041c: ").append(ps.port);
        status.append("\n\u0421\u0443\u043c\u043c\u0430 \u043d\u0430\u043b\u0438\u0447\u043d\u044b\u0445: ").append(FrkUtils.formatMDE(ps.cashTotal));
        status.append("\n\u0421\u0443\u043c\u043c\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0441\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u0438\u0442\u043e\u0433\u0430 \u043f\u0440\u043e\u0434\u0430\u0436: ").append(FrkUtils.formatMDE(ps.lastX));
        return status.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _check(int type, String ... parameters) throws PrinterConnectException, PrinterErrorException, DriverException {
        BigDecimal summa;
        BigDecimal clientsumma;
        block26: {
            FrkUtils.CommandCheckParameters commandCheckParameters = FrkUtils.processCommandCheckParameters(parameters, logger);
            if (commandCheckParameters.checkType != null) {
                int newtype = -1;
                switch (commandCheckParameters.checkType) {
                    case PAYMENT: {
                        newtype = 1;
                        break;
                    }
                    case PAYMENTREFUND: {
                        newtype = 2;
                        break;
                    }
                    case PAYMENTCORRECTION: {
                        newtype = 7;
                    }
                }
                if (newtype != type) {
                    logger.debug("Driver: overwrite check type from " + type + " to " + newtype);
                    type = newtype;
                }
            }
            int oppass = FrkUtils.parseInt(parameters[0]);
            BigDecimal par1 = FrkUtils.parseBigDecimal(parameters[1]);
            clientsumma = type == 1 ? par1 : BigDecimal.ZERO;
            BigDecimal mul100 = new BigDecimal(100);
            logger.debug("Driver: check/checkreturn(clientsumma=" + clientsumma + ",type=" + type + "):");
            summa = commandCheckParameters.paymentsum;
            Integer taxTotal = commandCheckParameters.tax;
            Integer payMethodTotal = commandCheckParameters.payMethod;
            Integer payObjectTotal = commandCheckParameters.payObject;
            Integer paymentType = commandCheckParameters.paymentType;
            if (type == 1 && clientsumma.compareTo(summa) < 0) {
                throw new PrinterAtolErrorException("\u0414\u0435\u043d\u0435\u0433 \u0432\u043d\u0435\u0441\u0435\u043d\u043e (" + clientsumma.toPlainString() + ") \u043c\u0435\u043d\u044c\u0448\u0435 \u0441\u0443\u043c\u043c\u044b \u0447\u0435\u043a\u0430 (" + summa.toPlainString() + ")");
            }
            AtolPrinter printer = new AtolPrinter(this.serialParameters, this.printerType, this.accessPassword, oppass, logger);
            Exception esave = null;
            try {
                printer.open();
                printer.openCheck();
                printer.opencheck(type, commandCheckParameters.onlyElCheck);
                if (commandCheckParameters.customerEmail != null) {
                    printer.sendTLV(1008, commandCheckParameters.customerEmail.getBytes(OFD_TAG_ENCODING));
                }
                if (commandCheckParameters.cashierName != null) {
                    printer.sendTLV(1021, commandCheckParameters.cashierName.getBytes(OFD_TAG_ENCODING));
                }
                if (commandCheckParameters.cashierINN != null) {
                    printer.sendTLV(1203, commandCheckParameters.cashierINN.getBytes(OFD_TAG_ENCODING));
                }
                for (Check.CheckLine checkLine : commandCheckParameters.lines) {
                    Integer tax;
                    if (checkLine.getSumma() == null) {
                        printer.printLine(checkLine.getText(), this.checkWidth);
                        continue;
                    }
                    Integer payMethod = checkLine.payMethod != null ? checkLine.payMethod : payMethodTotal;
                    Integer payObject = checkLine.payObject != null ? checkLine.payObject : payObjectTotal;
                    Integer n = tax = checkLine.tax != null ? checkLine.tax : taxTotal;
                    if (payMethod == null && payObject == null) {
                        printer.sale(checkLine.getText(), checkLine.getSumma().multiply(mul100).longValue(), 1000L, tax != null ? tax : 0, checkLine.getDep());
                        continue;
                    }
                    printer.sale_EBh(checkLine.getText(), checkLine.getSumma().multiply(mul100).longValue(), 1000L, tax != null ? tax : 0, checkLine.getDep(), payMethod != null ? payMethod : 0, payObject != null ? payObject : 0);
                }
                for (Map.Entry entry : commandCheckParameters.customTags.entrySet()) {
                    Object vtag = entry.getValue();
                    if (vtag instanceof byte[]) {
                        printer.sendTLV((Integer)entry.getKey(), (byte[])vtag);
                        continue;
                    }
                    if (vtag instanceof Long) {
                        printer.sendTLV((Integer)entry.getKey(), new byte[]{((Long)vtag).byteValue()});
                        continue;
                    }
                    if (!(vtag instanceof String)) continue;
                    printer.sendTLV((Integer)entry.getKey(), ((String)vtag).getBytes(Charset.forName("cp866")));
                }
                printer.closeCheck(clientsumma.multiply(mul100).longValue(), paymentType != null ? paymentType : 1);
                if (this.cutterForceManual) {
                    printer.cut();
                }
            }
            catch (Exception e) {
                esave = e;
                return esave;
            }
            finally {
                if (printer.testOnOpenCheckAndNulled()) {
                    esave = esave == null ? new PrinterAtolErrorException("\u041f\u043e\u0441\u043b\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0447\u0435\u043a \u043e\u0441\u0442\u0430\u043b\u0441\u044f \u043e\u0442\u043a\u0440\u044b\u0442. \u0427\u0435\u043a \u0431\u044b\u043b \u0430\u043d\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u043d.") : new PrinterAtolErrorException("\u0427\u0435\u043a \u0431\u044b\u043b \u0430\u043d\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u043d \u0432\u0432\u0438\u0434\u0443 \u043e\u0448\u0438\u0431\u043a\u0438: " + esave.toString());
                }
                printer.close();
                if (esave == null) break block26;
                if (esave instanceof PrinterConnectException) {
                    throw (PrinterConnectException)esave;
                }
                if (esave instanceof PrinterAtolErrorException) {
                    throw (PrinterAtolErrorException)esave;
                }
                throw new PrinterAtolErrorException(esave.toString());
            }
        }
        return clientsumma.subtract(summa).toPlainString();
    }

    @Override
    public synchronized String check(String ... parameters) throws PrinterConnectException, PrinterErrorException, DriverException {
        return this._check(1, parameters);
    }

    @Override
    public synchronized String checkreturn(String ... parameters) throws PrinterConnectException, PrinterErrorException, DriverException {
        return this._check(2, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void xreport(String adminPass) throws PrinterConnectException, PrinterErrorException, DriverException {
        int oppass = FrkUtils.parseInt(adminPass);
        try (AtolPrinter printer = new AtolPrinter(this.serialParameters, this.printerType, this.accessPassword, oppass, logger);){
            printer.open();
            printer.xreport(1);
            if (this.cutterForceManual) {
                printer.cut();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void divreport(String adminPass) throws PrinterConnectException, PrinterErrorException, DriverException {
        int oppass = FrkUtils.parseInt(adminPass);
        try (AtolPrinter printer = new AtolPrinter(this.serialParameters, this.printerType, this.accessPassword, oppass, logger);){
            printer.open();
            printer.xreport(2);
            if (this.cutterForceManual) {
                printer.cut();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void zreport(String adminPass) throws PrinterConnectException, PrinterErrorException, DriverException {
        int oppass = FrkUtils.parseInt(adminPass);
        try (AtolPrinter printer = new AtolPrinter(this.serialParameters, this.printerType, this.accessPassword, oppass, logger);){
            printer.open();
            printer.zreport();
            if (this.cutterForceManual) {
                printer.cut();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void printtext(String ... parameters) throws PrinterErrorException, PrinterConnectException, DriverException {
        int oppass = FrkUtils.parseInt(parameters[0]);
        try (AtolPrinter printer = new AtolPrinter(this.serialParameters, this.printerType, this.accessPassword, oppass, logger);){
            printer.open();
            for (int i = 1; i < parameters.length; ++i) {
                if ("!CUT%)".equals(parameters[i]) && !this.cutterDisabled) {
                    printer.cut();
                    continue;
                }
                printer.printLine(parameters[i], this.checkWidth);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String purecommand(String password, String command) throws PrinterConnectException, PrinterErrorException, DriverException {
        int pass = FrkUtils.parseInt(password);
        String ret = "?";
        try (AtolPrinter printer = new AtolPrinter(this.serialParameters, this.printerType, this.accessPassword, pass, logger);){
            printer.open();
            BGByteBuffer bb = printer.pureCmd(command);
            if (bb != null) {
                ret = bb.toString();
            }
        }
        return ret;
    }

    @Override
    public synchronized void repeatcheck(String operatorPass) throws NotImplementedException {
        throw new NotImplementedException("repeatcheck", "\u0432 \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b \u043d\u0435\u0442, \u043d\u043e \u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0434\u0443\u043c\u0430\u0442\u044c \u043a\u0430\u043a \u0441\u0434\u0435\u043b\u0430\u0442\u044c \u0438\u043c\u0438\u0442\u0430\u0446\u0438\u044e");
    }

    @Override
    public synchronized String closecheck_fix(String adminPass, String summa) throws NotImplementedException {
        throw new NotImplementedException("closecheck_fix", NotImplementedException.CAN_BE_IMPLEMENTED);
    }

    @Override
    public synchronized void continueprint(String pass) throws NotImplementedException {
        throw new NotImplementedException("continueprint", NotImplementedException.CAN_BE_IMPLEMENTED);
    }

    @Override
    public synchronized void cancelcheck(String pass) throws NotImplementedException {
        throw new NotImplementedException("cancelcheck", NotImplementedException.CAN_BE_IMPLEMENTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openday(String adminPass) throws DriverException, PrinterConnectException, PrinterErrorException {
        int oppass = FrkUtils.parseInt(adminPass);
        try (AtolPrinter printer = new AtolPrinter(this.serialParameters, this.printerType, this.accessPassword, oppass, logger);){
            printer.open();
            printer.openDay("\u041e\u0442\u043a\u0440\u044b\u0442\u0438\u0435 \u0441\u043c\u0435\u043d\u044b");
            if (this.cutterForceManual) {
                printer.cut();
            }
        }
    }
}

