/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.cashcheck.frk.server;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jssc.SerialNativeInterface;
import jssc.SerialPortList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.cashcheck.frk.common.CmdProtocolClient;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.ICashCheckDriver;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.CmdTcpServer;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.IDeviceDriver;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.BGCfg;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.FrkUtils;
import ru.bitel.common.Utils;

public class TestServer {
    private Logger log;
    private BGCfg cfg;
    private boolean isDoTest;
    private boolean isDoTouch;
    private int operPassword;
    private int indexTest;
    private Set<String> driversSet;

    public static void main(String[] args) {
        new TestServer(args);
    }

    public TestServer(String[] args) {
        System.setProperty("cashserver.start.timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        System.setProperty("log4j.configurationFile", System.getProperty("log4j.configurationFile", "conf/log4j2.xml"));
        this.log = LogManager.getLogger();
        this.cfg = null;
        this.isDoTest = false;
        this.isDoTouch = false;
        this.operPassword = 0;
        this.indexTest = 0;
        this.driversSet = null;
        if (args.length > 0) {
            for (String arg : args) {
                if ("--dotest".equals(arg)) {
                    this.isDoTest = true;
                    continue;
                }
                if ("--dotouch".equals(arg)) {
                    this.isDoTouch = true;
                    continue;
                }
                if (arg.startsWith("--password")) {
                    this.operPassword = Utils.parseInt((String)arg.substring("--password".length()), (int)this.operPassword);
                    continue;
                }
                if (arg.startsWith("--drivers")) {
                    this.driversSet = new HashSet<String>(Arrays.asList(arg.substring("--drivers".length()).split(",")));
                    continue;
                }
                this.log.warn("unrecognized parameter " + arg);
                TestServer.showHelp();
                return;
            }
        } else {
            TestServer.showHelp();
            return;
        }
        this.cfg = CmdTcpServer.getConfig();
        this.doCommon();
        if (this.isDoTouch) {
            this.doTouch();
        }
        if (this.isDoTest) {
            this.doTest();
        }
        this.log.info("TEST COMPLETED. THE END.");
    }

    private void doCommon() {
        this.log.info(++this.indexTest + ") CASHSERVER VERSION GETTING (LOCAL)");
        this.log.info(CmdTcpServer.getVersion());
        this.log.info(++this.indexTest + ") JAVA VERSION");
        this.log.info("os:" + System.getProperty("os.name") + "; java:" + System.getProperty("java.vm.name") + ", v." + System.getProperty("java.version"));
        this.log.info(++this.indexTest + ") logging level " + this.log.getLevel());
        this.log.info(++this.indexTest + ") CHECK jssc.* CLASS");
        try {
            Class.forName("jssc.SerialNativeInterface");
        }
        catch (Throwable t) {
            this.log.error("error get class", t);
            return;
        }
        this.log.info(++this.indexTest + ") jssc VERSION GETTING");
        this.log.info("libraryVersion=" + SerialNativeInterface.getLibraryVersion());
        this.log.info("osType=" + SerialNativeInterface.getOsType() + " (" + (new String[]{"LIN", "WIN", "SOL", "MAC"})[SerialNativeInterface.getOsType()] + ")");
    }

    private void doTest() {
        this.log.info(++this.indexTest + ") PORT SCAN");
        String[] portNames = SerialPortList.getPortNames();
        this.log.info("Ports:");
        if (portNames == null || portNames.length < 1) {
            this.log.warn("warning: no ports found!");
        }
        for (String portName : portNames) {
            this.log.info(portName);
        }
        this.log.info(++this.indexTest + ") LOCAL TEST (CURRENT DRIVER)");
        try {
            String driver = this.cfg.getString("driver");
            this.log.debug("create driver '" + driver + "' instance...");
            IDeviceDriver device = (IDeviceDriver)Class.forName(driver).getConstructor(new Class[0]).newInstance(new Object[0]);
            this.log.debug("created driver: " + device);
            HashMap<String, String> config = new HashMap<String, String>();
            Map<String, Object> driverMap = this.cfg.getMap(driver);
            if (driverMap != null) {
                for (Map.Entry entry : driverMap.entrySet()) {
                    if (entry.getValue() instanceof String) {
                        config.put((String)entry.getKey(), (String)entry.getValue());
                        this.log.trace("config: " + (String)entry.getKey() + "=" + (String)entry.getValue());
                        continue;
                    }
                    this.log.warn("config driver parameter '" + entry.getValue() + "' is not stringable, ignored");
                }
            }
            device.init(config);
            if (this.operPassword == 0) {
                this.log.warn("use DEFAULT oper password '0'");
            } else {
                this.log.debug("use oper password '" + this.operPassword + "'");
            }
            Class<?> deviceClass = device.getClass();
            Class[] classArray = new Class[1];
            String[] parametersObject = new String[1];
            classArray[0] = String.class;
            parametersObject[0] = String.valueOf(this.operPassword);
            this.log.debug("get deviceMethod 'name'...");
            Method deviceMethod = deviceClass.getMethod("name", classArray);
            this.log.debug("invoke '" + deviceMethod + "'...");
            Object ret = deviceMethod.invoke((Object)device, (Object[])parametersObject);
            this.log.info("getted device name: '" + (String)ret + "'");
            this.log.info("get device.getStatus(): " + device.getStatus());
        }
        catch (Exception e) {
            this.log.error("error local test", (Throwable)e);
        }
        CmdProtocolClient client = null;
        this.log.info(++this.indexTest + ") REMOTE SERVER PROTOCOL TEST");
        try {
            String serverPort = this.cfg.getString("port");
            client = new CmdProtocolClient("127.0.0.1", Integer.parseInt(serverPort));
            this.log.debug("connecting (127.0.0.1:" + Integer.parseInt(serverPort) + ")...");
            client.connect();
            this.log.debug("sending 'printtext'...");
            boolean result = client.send("printtext", this.operPassword, "\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442", "\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442", "\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442");
            this.log.debug("OK, result=" + result + ", reply=" + client.getReply());
            this.log.debug("sending 'name'...");
            result = client.send("name", this.operPassword);
            this.log.debug("OK, result=" + result + ", reply=" + client.getReply());
            this.log.debug("sending 'status'...");
            client.send("status", this.operPassword);
            this.log.debug("OK: " + client.getReply());
            this.log.debug("sending 'buzzer'...");
            result = client.send("buzzer", this.operPassword);
            this.log.debug("OK, result=" + result + ", reply=" + client.getReply());
        }
        catch (Exception e) {
            this.log.error("error remote server test", (Throwable)e);
        }
        this.log.info(++this.indexTest + ") GET SERVER STATUS");
        try {
            String serverStatus = client.getServerStatus();
            this.log.info("status: " + serverStatus);
            client.disconnect();
        }
        catch (Exception e) {
            this.log.error("error get remote server status", (Throwable)e);
        }
    }

    private void doTouch() {
        this.log.info(++this.indexTest + ") DRIVERS TOUCH");
        try {
            int skipedDriver = 0;
            Set<Class<?>> classes = FrkUtils.driversTouch();
            for (Class<?> clazz : classes) {
                if (!ICashCheckDriver.class.isAssignableFrom(clazz) || clazz.isInterface()) continue;
                if (this.driversSet != null && !this.driversSet.contains(clazz.getCanonicalName())) {
                    ++skipedDriver;
                    continue;
                }
                this.log.debug("[!]driver: '" + clazz.getCanonicalName() + "'");
                ICashCheckDriver driver = (ICashCheckDriver)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                driver.touchDriver();
            }
            if (skipedDriver > 0) {
                this.log.debug(skipedDriver + " driver(s) skiped");
            }
        }
        catch (Exception e) {
            this.log.error("error touch", (Throwable)e);
        }
    }

    private static void showHelp() {
        StringBuffer sb = new StringBuffer();
        sb.append("TestServer of ").append(CmdTcpServer.getVersion()).append("\n");
        sb.append("Usage: testserver[.bat|.sh] [--dotest] [--dotouch] [--passwordXXX] [--driversDRIVER1,DRIVER2,...]\n");
        sb.append("Parameters:\n");
        sb.append("\t--dotest\tdo test\n");
        sb.append("\t--dotouch\tdo drivers touch\n");
        sb.append("\t--passwordXXX\tset operator password XXX\n");
        sb.append("\t--driversDRIVER1,DRIVER2,...\tset driver(s) for touch\n");
        System.out.println(sb.toString());
    }
}

