/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server.task;

import java.util.List;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.plugins.cashcheck.common.Printer;
import ru.bitel.bgbilling.plugins.cashcheck.server.CashCheckUtils;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.PrinterManager;

public class AutoprintCloseDay
extends TaskBase {
    private BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.cashcheck");

    public String getDescription() {
        return this.defaultDescription + "\u041f\u043b\u0430\u0433\u0438\u043d CashCheck. \u0417\u0430\u0434\u0430\u0447\u0430 \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0434\u043d\u044f (\u0441\u043d\u044f\u0442\u0438\u0435 z-\u043e\u0442\u0447\u0451\u0442\u0430)";
    }

    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        this.log.info("cashcheck autoprint: ZReport...");
        PrinterManager printerManager = new PrinterManager(this.plugin);
        List autocloseseprinters = printerManager.getPrinters().stream().filter(printer -> printer.isAutoclose()).collect(Collectors.toList());
        if (autocloseseprinters.isEmpty()) {
            this.log.error("cashcheck autoprint: not found autoclose printers in plugin config, task do nothing");
            return;
        }
        for (Printer autocloseseprinter : autocloseseprinters) {
            int kkmNum = autocloseseprinter.getId();
            int kkmPass = autocloseseprinter.getAutoclosePass();
            try {
                CashCheckUtils.ZReport(autocloseseprinter, kkmPass);
                this.log.info("cashcheck autoprint: ZReport on kkm #" + kkmNum + " was made");
                CashCheckUtils.sendMailsAutoprint("zreport.ok", "cashcheck autoprint: ZReport on kkm #" + kkmNum + " was made", "subj");
            }
            catch (BGException e) {
                this.log.error("cashcheck autoprint: ERROR ZReport on kkm #" + kkmNum, (Throwable)e);
                CashCheckUtils.sendMailsAutoprint("zreport.error", "cashcheck autoprint: ERROR ZReport on kkm #" + kkmNum, e.printStackTraceToString());
            }
        }
    }
}

