/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.gospell;

import java.io.UnsupportedEncodingException;

public class ByteDeserializer {
    private byte[] buffer = null;
    private int pos = 0;

    public ByteDeserializer(byte[] buffer) {
        this.buffer = buffer;
    }

    public long getLong(int fieldlen) {
        long result = 0L;
        for (int i = 0; i < fieldlen; ++i) {
            long b = (long)this.buffer[this.pos + fieldlen - i - 1] & 0xFFL;
            result |= b << 8 * i;
        }
        this.pos += fieldlen;
        return result;
    }

    public int getInt(int fieldlen) {
        return (int)this.getLong(fieldlen);
    }

    public String getString(int fieldlen) {
        try {
            return new String(this.getBytes(fieldlen), "latin1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getBytes(int fieldlen) {
        byte[] result = new byte[fieldlen];
        System.arraycopy(this.buffer, this.pos, result, 0, result.length);
        this.pos += result.length;
        return result;
    }

    public int available() {
        int a = this.buffer.length - this.pos;
        return a > 0 ? a : 0;
    }
}

