/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.service;

import java.util.Date;
import java.util.List;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Dealer;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.DealerService;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.DealerManager;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.cerbercrypt.common.service.DealerService")
public class DealerServiceImpl
extends AbstractService
implements DealerService {
    public List<Dealer> dealerTable(String title, Date date1, Date date2) throws BGException {
        return new DealerManager(this.getConnection(), this.moduleId).getDealerList(title, date1, date2);
    }

    public void deleteDealer(int id) throws BGException {
        if (id <= 0) {
            throw new BGIllegalArgumentException();
        }
        new DealerManager(this.getConnection(), this.moduleId).deleteDealer(id);
    }

    public Dealer get(int id) throws BGException {
        if (id <= 0) {
            throw new BGIllegalArgumentException();
        }
        return new DealerManager(this.getConnection(), this.moduleId).getDealer(id);
    }

    public int update(Dealer dealer) throws BGException {
        if (dealer == null || Utils.isEmptyString((String)dealer.getTitle())) {
            throw new BGIllegalArgumentException();
        }
        new DealerManager(this.getConnection(), this.moduleId).updateDealer(dealer);
        return dealer.getId();
    }

    public List<Dealer> dealerList() throws BGException {
        return new DealerManager(this.getConnection(), this.moduleId).getDealerList();
    }
}

