<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">

<xsl:output encoding="UTF-8" method='html' indent='yes'/>

<xsl:template match="/data">

<HTML>
<head>
	<title>BGBilling</title>
	<META http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
	<link rel="stylesheet" type="text/css" href="style.css"/>	
</head>

<body>
<basefont face="arial">
	<p align="center" style="font-size: 20; font-weight: bold;">
	Для того, чтобы создать договор по карте <BR/>
	вам  необходимо:</p>
	
	<form  method="post" action="pubexecuter?action=CreateContract&amp;module=cerbercrypt&amp;mid=43&amp;debug=1">
	<table align="center" width="500" border="0" cellpadding="3">
		<tr>
			<td>Введите номер карты:</td>			
			<td align="right">
				<input name="number" type="text" size="30"/>
			</td>
		</tr>	
		<tr>
			<td>Введите пароль карты:</td>			
			<td align="right">
				<input name="pswd" type="password" size="30"/>
			</td>
		</tr>
		<tr>
			<td colspan="2"><input type="checkbox" name="set_address"/> привязать договор к адресу:</td>
		</tr>
		<tr>	
			<td colspan="2">
				Улица:
				<select name="street">
					<xsl:for-each select="/data/street_list/item">
						<option>
								<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>								
								<xsl:value-of select="@title"/>
						</option>
					</xsl:for-each>
				</select>
				дом
				<input name="house" type="text" size="5"/>
				кв.
				<input name="flat" type="text" size="3"/>
				комн.
				<input name="room" type="text" size="3"/>
			</td>
		</tr>
		<tr>
			<td>
				<input type="checkbox" name="set_fio"/>
				привязать ФИО 				
			</td>
			<td align="right">
				<input type="text" size="30" name="fio"/>
			</td>
		</tr>
		<tr>
			<td colspan="2">
				<input type="checkbox" name="allow_change"/>
				разрешить смену подписки через сайт
			</td>
		</tr>
		
		<tr>
			<td colspan="2" align="right"><input type="submit" value="Создать договор"/></td>
		</tr>
		
		<tr><td colspan="2"><hr/></td></tr>
		
		<xsl:if test="/data/@status='error'">
			<tr><td colspan="2" style="color:red; font-weight: bold">				
				<xsl:value-of select="/data/text()"/>
			</td></tr>
		</xsl:if>
		
		<xsl:if test="/data/contract and ( /data/contract/@created = 'yes' )">
			<tr><td colspan="2">	
				<div class="infoMessage">		
					&#160;По карте создан договор.<br/><br/>
					<xsl:apply-templates select="/data/contract"/>
				</div>
			</td></tr>
		</xsl:if>
		<xsl:if test="/data/contract and ( /data/contract/@created != 'yes' )">
			<tr><td colspan="2">	
				<div class="infoMessage">		
					&#160;Для карты уже существует договор.<br/><br/>
					<xsl:apply-templates select="/data/contract"/>
				</div>
			</td></tr>
		</xsl:if>
		
	</table>
	</form>
	
</basefont>
</body>
</HTML>
</xsl:template>

<xsl:template match="contract">
	&#160;Название договора <xsl:value-of select="@title"/><br/>
	&#160;Для дальнейших операций с договором вам нужно перейти на 
	<a href="#">страницу статистики</a>.<br/>
	&#160;В качестве логина доступа
	используйте имя договора, в качестве пароля - пароль карты создания договора.	
</xsl:template>

</xsl:stylesheet>