/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cladr.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.plugins.cladr.common.model.Address;
import ru.bitel.bgbilling.plugins.cladr.common.model.House;
import ru.bitel.bgbilling.plugins.cladr.common.model.Street;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class StreetDAO {
    private static final String TABLE_CLADR_STREET = "cladr_street";
    private static final String TABLE_CLADR_STREET_MAP = "cladr_street_map";
    private static final String TABLE_ADDRESS_STREET = "address_street";
    private Connection con = null;
    private Logger log = null;

    public StreetDAO(Connection con, Logger log) {
        this.con = con;
        this.log = log;
    }

    private void clearMapTable() throws SQLException {
        try (PreparedStatement ps = this.con.prepareStatement("delete from cladr_street_map WHERE street_id NOT IN (SELECT id FROM address_street)");){
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
    }

    public List<Street> getStreetNotFromCladr(Address address, int cityId) throws SQLException {
        ArrayList<Street> res = new ArrayList<Street>();
        try {
            this.clearMapTable();
            String query = "SELECT * FROM address_street WHERE id NOT IN (select street_id from cladr_street_map) AND (cityid=-1 OR cityid=" + cityId + ") ";
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                Street street = new Street();
                street.setId(rs.getInt("id"));
                street.setTitle(rs.getString("title"));
                street.setIndex(rs.getString("p_index"));
                street.setCityId(rs.getInt("cityid"));
                res.add(street);
            }
            st.close();
        }
        catch (SQLException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
        return res;
    }

    public void addStreetForCladrCompare(List<Street> list) throws SQLException {
        try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO cladr_street SET id=?, title=?, socr=?, code=?, p_index=?, cityid=?");){
            Statement st = this.con.createStatement();
            st.executeUpdate("DELETE FROM cladr_street");
            for (Street street : list) {
                int index = 1;
                ps.setInt(index++, street.getId());
                ps.setString(index++, street.getTitle());
                ps.setString(index++, street.getSocr());
                ps.setString(index++, street.getCode());
                ps.setString(index++, street.getIndex());
                ps.setInt(index++, street.getCityId());
                ps.executeUpdate();
            }
            st.close();
        }
        catch (SQLException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
    }

    private void addStreetInMap(Street street) throws SQLException {
        try {
            String query = "SELECT street_id FROM cladr_street_map WHERE code=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, street.getCode());
            ResultSet rs = ps.executeQuery();
            int id = -1;
            if (rs.next()) {
                id = rs.getInt(1);
            }
            query = id != -1 ? "UPDATE cladr_street_map SET code=? WHERE street_id=?" : "INSERT INTO cladr_street_map SET code=?, street_id=?";
            rs.close();
            ps.close();
            ps = this.con.prepareStatement(query);
            int indexMap = 1;
            ps.setString(indexMap++, street.getCode());
            ps.setInt(indexMap++, street.getId());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
    }

    public void addStreet(Street street, boolean ignoreSocr) throws SQLException {
        try {
            String query = null;
            query = street.getId() > 0 ? "UPDATE address_street SET title=?, p_index=?, cityid=? WHERE id=?" : "INSERT INTO address_street SET title=?, p_index=?, cityid=?";
            PreparedStatement ps = this.con.prepareStatement(query, 1);
            int index = 1;
            ps.setString(index++, this.getStreetName(street, ignoreSocr));
            ps.setString(index++, street.getIndex());
            ps.setInt(index++, street.getCityId());
            if (street.getId() > 0) {
                ps.setInt(index++, street.getId());
            }
            ps.executeUpdate();
            if (street.getId() <= 0) {
                street.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
            this.addStreetInMap(street);
        }
        catch (SQLException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
    }

    public List<Integer> addStreeFromCladr(List<Address> list, boolean ignoreSocr, int cityId) throws SQLException {
        ArrayList<Integer> res = new ArrayList<Integer>();
        try {
            PreparedStatement selectPs = this.con.prepareStatement("SELECT street_id FROM cladr_street_map WHERE code=?");
            String query = "INSERT INTO address_street SET title=?, p_index=?, cityid=?";
            PreparedStatement insertPs = this.con.prepareStatement(query, 1);
            query = "UPDATE address_street SET title=?, p_index=?,cityid=? WHERE id=?";
            PreparedStatement updatePs = this.con.prepareStatement(query);
            for (Address address : list) {
                int index;
                selectPs.setString(1, address.getCode());
                ResultSet rs = selectPs.executeQuery();
                int id = -1;
                if (rs.next()) {
                    id = rs.getInt(1);
                }
                rs.close();
                if (id > 0) {
                    index = 1;
                    updatePs.setString(index++, this.getStreetName(address, ignoreSocr));
                    updatePs.setString(index++, address.getIndex());
                    updatePs.setInt(index++, cityId);
                    updatePs.setInt(index++, id);
                    updatePs.executeUpdate();
                } else {
                    index = 1;
                    insertPs.setString(index++, address.getSocr() + ". " + address.getName());
                    insertPs.setString(index++, address.getIndex());
                    insertPs.setInt(index++, cityId);
                    insertPs.executeUpdate();
                    id = ServerUtils.lastInsertId((PreparedStatement)insertPs);
                }
                Street street = new Street();
                street.setCode(address.getCode());
                street.setId(id);
                res.add(id);
                this.addStreetInMap(street);
            }
            selectPs.close();
            updatePs.close();
            insertPs.close();
        }
        catch (SQLException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
        return res;
    }

    public void delStreetFromCladrCompare(Street street) throws SQLException {
        this.delStreetImpl(street, TABLE_CLADR_STREET);
    }

    public void delStreet(Street street) throws SQLException {
        this.delStreetImpl(street, TABLE_ADDRESS_STREET);
    }

    private void delStreetImpl(Street street, String tableName) throws SQLException {
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + tableName + " WHERE id=?");){
            int index = 1;
            ps.setInt(index++, street.getId());
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
    }

    public Street getNextStreet() throws SQLException {
        Street res = null;
        try {
            String query = "SELECT * FROM cladr_street LIMIT 0,1";
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query);
            if (rs.next()) {
                res = new Street();
                res.setId(rs.getInt("id"));
                res.setTitle(rs.getString("title"));
                res.setSocr(rs.getString("socr"));
                res.setIndex(rs.getString("p_index"));
                res.setCityId(rs.getInt("cityid"));
            }
            st.close();
        }
        catch (SQLException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
        return res;
    }

    private String getCityName(Address region, Address area, Address city, int direct) {
        StringBuilder res = new StringBuilder();
        String regionName = null;
        String areaName = null;
        if (region != null) {
            regionName = region.getSocr() + ". " + region.getName();
        }
        if (area != null) {
            areaName = area.getSocr() + ". " + area.getName();
        }
        String cityName = city.getSocr() + ". " + city.getName();
        if (direct == 1) {
            if (regionName != null) {
                res.append(regionName);
                res.append(" ");
            }
            if (areaName != null) {
                res.append(areaName);
                res.append(" ");
            }
            res.append(cityName);
        } else {
            res.append(cityName);
            res.append(" ");
            if (areaName != null) {
                res.append(areaName);
                res.append(" ");
            }
            if (regionName != null) {
                res.append(regionName);
            }
        }
        return res.toString();
    }

    public void addCity(Address region, Address area, Address city, int direct, int cityId) throws SQLException {
        try {
            this.clearMapTable();
            String query = "UPDATE address_city SET title=? WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            int index = 1;
            ps.setString(index++, this.getCityName(region, area, city, direct));
            ps.setInt(index++, cityId);
            ps.executeUpdate();
            ps.close();
            city.setValue("cityid", cityId);
        }
        catch (SQLException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
    }

    public void addHouseForCladr(List<House> list) throws SQLException {
        try {
            String query = "DELETE FROM cladr_house WHERE code=?";
            PreparedStatement psDel = this.con.prepareStatement(query);
            query = "INSERT INTO cladr_house SET name=?, code=?, p_index=?";
            PreparedStatement psInsert = this.con.prepareStatement(query);
            for (House house : list) {
                psDel.setString(1, house.getCode());
                psDel.executeUpdate();
                int index = 1;
                psInsert.setString(index++, house.getName());
                psInsert.setString(index++, house.getCode());
                psInsert.setString(index++, house.getIndex());
                psInsert.executeUpdate();
            }
            psDel.close();
            psInsert.close();
        }
        catch (SQLException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
    }

    public String getStreetCode(int streetId) throws SQLException {
        String res = null;
        try {
            String query = "SELECT code FROM cladr_street_map WHERE street_id=" + streetId;
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query);
            if (rs.next()) {
                res = rs.getString(1);
            }
            st.close();
        }
        catch (SQLException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
        return res;
    }

    public List<House> getHouseByCode(String code) throws SQLException {
        ArrayList<House> res = new ArrayList<House>();
        if (code == null) {
            return res;
        }
        try {
            String query = "SELECT * FROM cladr_house WHERE code like '" + code.substring(0, 15) + "____'";
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                House house = new House();
                house.setCode(rs.getString("code"));
                house.setName(rs.getString("name"));
                house.setIndex(rs.getString("p_index"));
                res.add(house);
            }
            st.close();
        }
        catch (SQLException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
        return res;
    }

    private String getStreetName(Street street, boolean ignoreSocr) {
        return this.getStreetImpl(street.getSocr(), street.getTitle(), ignoreSocr);
    }

    private String getStreetName(Address address, boolean ignoreSocr) {
        return this.getStreetImpl(address.getSocr(), address.getName(), ignoreSocr);
    }

    private String getStreetImpl(String socr, String name, boolean ignoreSocr) {
        if (ignoreSocr) {
            if (socr.equals("\u0443\u043b")) {
                return name;
            }
            return socr + ". " + name;
        }
        return socr + ". " + name;
    }
}

