/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cloudpayments.server.servlet;

import java.io.IOException;
import java.sql.Connection;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.cloudpayments.common.bean.Transaction;
import ru.bitel.bgbilling.modules.cloudpayments.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.cloudpayments.server.event.CloudPaymentsCheckEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebServlet(name="CloudPaymentsExecutor", urlPatterns={"/cloudpayments/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final String PARAM_MD_ORDER = "mdOrder";
    private static final String PARAM_ORDER_NUMBER = "orderNumber";
    private static final Logger logger = LogManager.getLogger();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Transaction transaction;
        int moduleId;
        Connection con;
        block15: {
            String transactionId;
            String orderNumber;
            block14: {
                con = null;
                moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
                con = Setup.getSetup().getDBConnectionFromPool();
                orderNumber = request.getParameter(PARAM_ORDER_NUMBER);
                transactionId = request.getParameter(PARAM_MD_ORDER);
                transaction = null;
                try (TransactionManager transactionManager = new TransactionManager(con, moduleId);){
                    transaction = (Transaction)transactionManager.get(Utils.parseInt((String)orderNumber));
                }
                if (transaction != null) break block14;
                logger.error("Not found transaction for ID = " + orderNumber);
                ServerUtils.closeConnection((Connection)con);
                return;
            }
            if (transaction.getTransactionId().equals(transactionId)) break block15;
            logger.error("Transaction for ID = " + orderNumber + "( " + transaction.getTransactionId() + " != " + transactionId + " )");
            ServerUtils.closeConnection((Connection)con);
            return;
        }
        try {
            try {
                EventProcessor.getInstance().publish((Event)new CloudPaymentsCheckEvent(moduleId, transaction.getContractId(), transaction.isAutopayment()));
            }
            catch (BGException e) {
                e.printStackTrace();
            }
        }
        catch (BGException ex) {
            try {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                ServerUtils.closeConnection(con);
                throw throwable;
            }
            ServerUtils.closeConnection((Connection)con);
        }
        ServerUtils.closeConnection((Connection)con);
    }
}

