/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.client;

import bitel.billing.module.common.ListItem;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGServiceConfig;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.plugins.crm.client.admin.ActionConfig;
import ru.bitel.bgbilling.plugins.crm.client.admin.ProblemManager;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class CallEditor
extends BGPanel {
    private int callContractID = 0;
    private String callContractTitle;
    private String problemId = "";
    private DefaultListModel<ListItem> groupModel = new DefaultListModel();
    private JList<ListItem> groupList = new JList<ListItem>(this.groupModel);
    private DefaultListModel<ListItem> subjectModel = new DefaultListModel();
    private JList<ListItem> subjectList = new JList<ListItem>(this.subjectModel);
    private DefaultListModel<ListItem> currentProblemsModel = new DefaultListModel();
    private JList<ListItem> currentProblems_L = new JList<ListItem>(this.currentProblemsModel);
    private JTabbedPane link = new JTabbedPane();
    private JTabbedPane jTabbedPane1 = new JTabbedPane();
    private JPanel view = new JPanel();
    private JLabel problemRef_L = new JLabel();
    private JLabel contractLabel = new JLabel("\u0414\u043e\u0433\u043e\u0432\u043e\u0440: ");
    private JButton contractOpenButton = new JButton();
    private CardLayout cardLayout1 = new CardLayout();
    private JTextArea problemComment_TA = new JTextArea();
    private JTextArea problemResolution_TA = new JTextArea();
    private JTextArea createProblemComment_TA = new JTextArea();
    private JTextArea comment_TA = new JTextArea();
    private String module = "ru.bitel.bgbilling.plugins.crm";

    public CallEditor() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.contractOpenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CallEditor.this.openContract(CallEditor.this.callContractID);
            }
        });
    }

    private void jbInit() throws Exception {
        JPanel jPanel1 = new JPanel(new GridBagLayout());
        JPanel linkProblemPanel = new JPanel(new GridBagLayout());
        JPanel createProblemPanel = new JPanel(new GridBagLayout());
        this.link.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                if (((JTabbedPane)event.getSource()).getSelectedIndex() == 1) {
                    CallEditor.this.loadCurrentProblemList();
                }
            }
        });
        this.subjectList.setSelectionMode(0);
        this.subjectList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CallEditor.this.subjectList_valueChanged(e);
            }
        });
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CallEditor.this.save(false);
            }
        });
        JButton cancelButton = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CallEditor.this.cancelButton_actionPerformed(actionEvent);
            }
        });
        this.problemRef_L.setText("\u041e\u0442\u043a\u0440\u044b\u0442\u0430");
        this.view.setLayout(new GridBagLayout());
        this.groupList.setSelectionMode(0);
        JButton openProblem_B = new JButton("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440");
        openProblem_B.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CallEditor.this.openProblem_B_actionPerformed(actionEvent);
            }
        });
        JButton unlinkProblem_B = new JButton("\u041e\u0442\u0432\u044f\u0437\u0430\u0442\u044c");
        unlinkProblem_B.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CallEditor.this.unlinkProblem_B_actionPerformed(actionEvent);
            }
        });
        this.problemComment_TA.setEnabled(false);
        this.problemComment_TA.setEditable(false);
        this.problemComment_TA.setLineWrap(true);
        this.problemComment_TA.setWrapStyleWord(true);
        this.problemResolution_TA.setEnabled(false);
        this.problemResolution_TA.setEditable(false);
        this.problemResolution_TA.setLineWrap(true);
        this.problemResolution_TA.setWrapStyleWord(true);
        this.contractOpenButton.setText(" ");
        JButton okEmailButton = new JButton("OK + EMail");
        okEmailButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CallEditor.this.save(true);
            }
        });
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)new JScrollPane(this.subjectList), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)new JLabel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0437\u0432\u043e\u043d\u043a\u0430"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel2.add((Component)new JScrollPane(this.comment_TA), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.add((Component)new JScrollPane(this.groupList), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.link.add((Component)createProblemPanel, "\u0421\u043e\u0437\u0434\u0430\u0442\u044c");
        this.link.add((Component)linkProblemPanel, "\u041f\u0440\u0438\u0432\u044f\u0437\u0430\u0442\u044c");
        linkProblemPanel.add((Component)new JScrollPane(this.currentProblems_L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JScrollPane jScrollPane6 = new JScrollPane(this.problemResolution_TA);
        jScrollPane6.setMinimumSize(new Dimension(18, 100));
        jScrollPane6.setPreferredSize(new Dimension(3, 100));
        JScrollPane jScrollPane1 = new JScrollPane(this.problemComment_TA);
        jScrollPane1.setMinimumSize(new Dimension(18, 60));
        jScrollPane1.setPreferredSize(new Dimension(3, 60));
        createProblemPanel.add((Component)new JScrollPane(this.createProblemComment_TA), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.view.add((Component)this.problemRef_L, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.view.add((Component)openProblem_B, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.view.add((Component)unlinkProblem_B, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.view.add((Component)jScrollPane6, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.view.add((Component)jScrollPane1, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.4, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel problemPanel = new JPanel(this.cardLayout1);
        problemPanel.setBorder(null);
        problemPanel.add((Component)this.link, "problemCreate");
        problemPanel.add((Component)this.view, "problemView");
        this.jTabbedPane1.add((Component)jPanel2, "\u0422\u0438\u043f \u0437\u0432\u043e\u043d\u043a\u0430");
        this.jTabbedPane1.add((Component)jPanel5, "\u0413\u0440\u0443\u043f\u043f\u0430");
        this.jTabbedPane1.add((Component)problemPanel, "\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u0430");
        jPanel1.add((Component)this.contractLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 10, 0), 0, 0));
        jPanel1.add((Component)this.contractOpenButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
        jPanel1.add(Box.createHorizontalGlue(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
        jPanel1.add((Component)okButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
        jPanel1.add((Component)okEmailButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
        jPanel1.add((Component)cancelButton, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.add(this.jTabbedPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add(jPanel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
    }

    public void setData() {
        if (!this.init) {
            this.init();
        }
        if (!this.id.equals("new")) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("GetRegisterCall");
            request.setAttribute("id", this.id);
            this.setDocument(this.getDocument(request));
        } else {
            this.comment_TA.setText("");
            this.subjectList.clearSelection();
            this.groupList.clearSelection();
            this.problemComment_TA.setText("");
            this.showProblemPanel(false);
            this.contractOpenButton.setVisible(false);
            this.contractOpenButton.setText(" ");
            this.contractLabel.setVisible(false);
            this.link.setSelectedIndex(0);
        }
        this.jTabbedPane1.setSelectedIndex(0);
    }

    private void init() {
        this.init = true;
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("RegisterSubjectList");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildList(this.subjectList, this.subjectModel, (Node)XMLUtils.selectNode((Node)doc, (String)"//list"));
        }
        request.setModule(this.module);
        request.setAction("RegisterGroupList");
        doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildList(this.groupList, this.groupModel, (Node)XMLUtils.selectNode((Node)doc, (String)"//list"));
        }
    }

    private void loadCurrentProblemList() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("CurrentProblemList");
        request.setContractId(this.getContractId());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildList(this.currentProblems_L, this.currentProblemsModel, (Node)XMLUtils.selectElement((Node)doc, (String)"//list"));
        }
    }

    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus((Document)doc)) {
            Element call = XMLUtils.selectElement((Node)doc, (String)"//call");
            ClientUtils.setListSelection(this.subjectList, (String)call.getAttribute("subject"));
            ClientUtils.setListSelection(this.groupList, (String)call.getAttribute("group"));
            this.comment_TA.setText(ClientUtils.linesToString((Element)XMLUtils.selectElement((Node)doc, (String)"//comment")));
            boolean problemLinked = false;
            if (call.getAttribute("problem_status").length() > 0) {
                String problemStatus = call.getAttribute("problem_status");
                if ("\u0437\u0430\u043a\u0440\u044b\u0442\u0430".equals(problemStatus)) {
                    this.jTabbedPane1.setSelectedIndex(2);
                }
                this.problemRef_L.setText(problemStatus);
                this.problemId = call.getAttribute("problem_id");
                this.problemComment_TA.setText(ClientUtils.linesToString((Element)XMLUtils.selectElement((Node)doc, (String)"//problem_comment")));
                this.problemResolution_TA.setText(ClientUtils.linesToString((Element)XMLUtils.selectElement((Node)doc, (String)"//problem_resolution")));
                problemLinked = true;
            }
            this.showProblemPanel(problemLinked);
            this.callContractTitle = call.getAttribute("contract");
            this.callContractID = Utils.parseInt((String)call.getAttribute("contract_id"), (int)0);
            this.contractOpenButton.setText(Utils.notEmptyString((String)this.callContractTitle) ? this.callContractTitle : " ");
            this.contractOpenButton.setVisible(this.callContractID > 0);
            this.contractLabel.setVisible(this.callContractID > 0);
        }
    }

    public void subjectList_valueChanged(ListSelectionEvent e) {
        ListItem subjectItem;
        if (e.getValueIsAdjusting() && (subjectItem = this.subjectList.getSelectedValue()) != null) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("GetRegisterSubjectGroup");
            request.setAttribute("subject", subjectItem.getAttribute("id"));
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                ClientUtils.setListSelection(this.groupList, (String)doc.getDocumentElement().getAttribute("gid"));
            }
        }
    }

    public void save(boolean email) {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("UpdateRegisterCall");
        request.setAttribute("id", this.id);
        request.setContractId(this.getContractId());
        ListItem subjectItem = this.subjectList.getSelectedValue();
        ListItem groupItem = this.groupList.getSelectedValue();
        if (subjectItem != null && groupItem != null) {
            request.setAttribute("subject", subjectItem.getAttribute("id"));
            request.setAttribute("group", groupItem.getAttribute("id"));
            request.setAttribute("comment", this.comment_TA.getText());
            if (email) {
                request.setAttribute("send.mail", "1");
            }
            if (this.link.isVisible()) {
                int index = this.link.getSelectedIndex();
                if (index == 1) {
                    ListItem linkProblem = this.currentProblems_L.getSelectedValue();
                    if (linkProblem != null) {
                        request.setAttribute("problem_id", (String)linkProblem.getAttribute("id"));
                    } else {
                        request.setAttribute("problem_id", "0");
                    }
                } else if (this.createProblemComment_TA.getText().trim().length() > 0) {
                    request.setAttribute("problem_comment", this.createProblemComment_TA.getText());
                } else {
                    request.setAttribute("problem_id", "0");
                }
            }
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                this.setVisible(false);
            }
        }
    }

    private void showProblemPanel(boolean problemExist) {
        this.view.setVisible(problemExist);
        this.link.setVisible(!problemExist);
    }

    public void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    public void openProblem_B_actionPerformed(ActionEvent actionEvent) {
        BGServiceConfig serviceConfig = (BGServiceConfig)BGClientBase.getFrame().getTabbedPane().addTab(ActionConfig.class.getName(), BGServiceConfig.class);
        if (serviceConfig.getTabTitle() == null) {
            ClientContext ctx = new ClientContext(null, -1, -1, ActionConfig.class.getPackage().getName() + ".setup");
            serviceConfig.setTabTitle(ResourceBundle.getBundle(ctx.getResourceBundleName()).getString("module.title"));
            serviceConfig.initPanel("module", ctx, ActionConfig.class.getName(), true);
            serviceConfig.setData();
        }
        serviceConfig.selectTab(ProblemManager.class.getName());
        ((ProblemManager)serviceConfig.getTab(ProblemManager.class)).updateForId(this.problemId);
    }

    public void unlinkProblem_B_actionPerformed(ActionEvent actionEvent) {
        this.showProblemPanel(false);
        this.link.setSelectedIndex(0);
    }
}

