/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.radius;

import bitel.billing.server.admin.errorlog.AlarmSender;
import bitel.billing.server.admin.errorlog.bean.AlarmErrorMessage;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractStatusManager;
import bitel.billing.server.processor.LC_LimitChecker;
import bitel.billing.server.processor.dialup.ConnectionBreaker;
import bitel.billing.server.processor.dialup.DialUpSessionRealtime;
import bitel.billing.server.processor.dialup.WaitRemover;
import bitel.billing.server.processor.dialup.ZombiChecker;
import bitel.billing.server.radius.RadiusSetup;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusUtils;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnectionInspector;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasList;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionDao;
import ru.bitel.bgbilling.modules.dialup.server.bean.DialUpLogin;
import ru.bitel.bgbilling.modules.dialup.server.bean.DialUpLoginManager;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNasConnection;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpRadiusProcessor;
import ru.bitel.bgbilling.modules.dialup.server.radius.IpAddressSet;
import ru.bitel.bgbilling.modules.dialup.server.radius.TariffOptionWatcher;
import ru.bitel.bgbilling.modules.dialup.server.radius.TrafficInspector;
import ru.bitel.bgbilling.modules.dialup.server.traffic.NASServiceConfig;
import ru.bitel.bgbilling.modules.dialup.server.traffic.Traffic;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.StopableThread;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.RangedLongSet;
import ru.bitel.common.worker.WorkerThreadFactory;

public class DialUpNas
extends Nas<DialUpNasConnection, Setup, DialUpRadiusProcessor> {
    private static final Logger loggerConnections = LogManager.getLogger((String)"connections");
    private static final Logger logger = LogManager.getLogger();
    private final Random random;
    private final NASServiceConfig serviceConfig;
    private ParameterMap port_phones;
    private final Map<String, RangedLongSet> ipPools;
    private final boolean closeCalculatePeriod;
    private final boolean logUpdate;
    private final TrafficInspector trafficInspector;
    private final boolean restoreConnections;
    public static final int UPDATE_MODE = 1;
    public static final int CHECKER_MODE = 2;
    private final int workMode;
    private final boolean supportCallback;
    static final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(2);
    final ExecutorService checkerUpdater;
    private final int delayStop;
    private final ScheduledExecutorService delayStopPool;
    private List<StopableThread> threads = new ArrayList<StopableThread>();
    private final Map<Integer, String> rejectToAcceptErrorAtributes = new ConcurrentHashMap<Integer, String>();
    private final boolean secondCalculatePeriod;
    private final int moduleId;
    private final AtomicInteger getFreeIpFromPoolCount = new AtomicInteger();
    private static AtomicInteger restoredCount = new AtomicInteger();
    private static Object fakeColumnCheckMutex = new Object();

    public DialUpNas(Setup setup, int moduleId, DialUpRadiusProcessor processor, int id, DialUpNas oldNas, InetAddress nasIPAddress, String nasIdentifier, int vendorCode, ParameterMap conf, byte[] secret, ConcurrentMap<Object, DialUpNasConnection> connections, String script, NasConnectionInspector inspector) {
        super((Preferences)setup, moduleId, (RadiusProcessor)processor, id, (Nas)oldNas, nasIPAddress, nasIdentifier, vendorCode, conf, secret, connections, script, inspector);
        this.random = new Random();
        this.moduleId = moduleId;
        this.serviceConfig = new NASServiceConfig(conf, LogManager.getLogger(NASServiceConfig.class));
        this.port_phones = conf.sub("nas.port_phone.");
        this.restoreConnections = conf.getInt("connection.restore", 1) != 0;
        this.workMode = conf.getInt("dialup.workmode", 1);
        this.closeCalculatePeriod = conf.getInt("close.calculate.period", -1) > 0;
        this.supportCallback = conf.getInt("callback.support", 0) == 1;
        boolean bl = this.logUpdate = conf.get("log.update", null) != null;
        this.checkerUpdater = this.workMode == 2 ? (oldNas != null && oldNas.checkerUpdater != null ? oldNas.checkerUpdater : Executors.newCachedThreadPool((ThreadFactory)new WorkerThreadFactory("checkerUpdater", null, null))) : null;
        this.secondCalculatePeriod = conf.getBoolean("second.calculate.period", setup.getBoolean("second.calculate.period", false));
        HashMap<String, RangedLongSet> ipPools = new HashMap<String, RangedLongSet>();
        ParameterMap pools = conf.sub("nas.pools.");
        for (Map.Entry pool : pools.entrySet()) {
            DialUpRadiusProcessor.loadPools(ipPools, (String)pool.getKey(), (String)pool.getValue());
        }
        this.ipPools = Collections.unmodifiableMap(ipPools);
        this.trafficInspector = oldNas != null ? oldNas.trafficInspector : new TrafficInspector();
        this.delayStop = setup.getInt("delay.stop", 0);
        this.delayStopPool = this.delayStop > 0 ? Executors.newScheduledThreadPool(4) : null;
        this.threads.add(new ZombiChecker(this));
        this.threads.add(new WaitRemover((DefaultServerSetup)setup, this));
        this.threads.add(new ConnectionBreaker(this));
        this.threads.add(new TariffOptionWatcher(this));
        ParameterMap records = conf.sub("reject_to_accept.");
        for (Map.Entry me : records.entrySet()) {
            String key = (String)me.getKey();
            String value = (String)me.getValue();
            if (key.equals("nas") || key.equals("db.write")) continue;
            StringTokenizer st = new StringTokenizer(key, ",");
            while (st.hasMoreTokens()) {
                int code = Utils.parseInt((String)st.nextToken().trim());
                if (code <= 0) continue;
                this.rejectToAcceptErrorAtributes.put(code, value);
            }
        }
    }

    public int getTimeService(String realm, String port) {
        return this.serviceConfig.getTimeService(realm, port);
    }

    public List<Traffic> getTrafficConfig(String realm, String port) {
        return this.serviceConfig.getTrafficConfig(realm, port);
    }

    public TrafficInspector getTrafficInspector() {
        return this.trafficInspector;
    }

    public String getPhoneOnPort(String port) {
        String result = this.port_phones.get(port, null);
        if (result == null) {
            result = this.port_phones.get("*", null);
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public int getFreeIpFromPool(Map<String, RangedLongSet> globalPools, IpAddressSet usedAddressSet, Set<Long> staticAddressSet, DialUpSessionRealtime session, String poolName, Map<String, Float> alarmPercentMap) {
        int result = 0;
        if (poolName != null) {
            RangedLongSet addrSet = this.ipPools.get(poolName);
            if (addrSet == null) {
                addrSet = globalPools.get(poolName);
            }
            if (addrSet != null) {
                int offset;
                Long address;
                if (this.getFreeIpFromPoolCount.incrementAndGet() > 50) {
                    this.getFreeIpFromPoolCount.set(0);
                    Float alarmPercent = alarmPercentMap.get(poolName);
                    if (alarmPercent != null) {
                        long time;
                        String key;
                        int usedCount = 0;
                        for (Long l : usedAddressSet.keySet()) {
                            if (!addrSet.contains((Object)l)) continue;
                            ++usedCount;
                        }
                        for (Long l : staticAddressSet) {
                            if (!addrSet.contains((Object)l)) continue;
                            ++usedCount;
                        }
                        int fullPoolSize = addrSet.size();
                        if ((float)usedCount / (float)fullPoolSize * 100.0f >= alarmPercent.floatValue() && AlarmSender.needAlarmSend((String)(key = "radius.dialup.address.pool.fullness.alarm"), (long)(time = System.currentTimeMillis()), (long)30000L)) {
                            String message = "\u0412 \u043f\u0443\u043b\u0435 IP \u0430\u0434\u0440\u0435\u0441\u043e\u0432 " + poolName + " \u043d\u0430 NAS " + this.getNasIdentifier() + " \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u043e " + usedCount + " \u0438\u0437 " + fullPoolSize + " \u0430\u0434\u0440\u0435\u0441\u043e\u0432.";
                            AlarmSender.sendAlarm((AlarmErrorMessage)new AlarmErrorMessage(key, "\u041f\u0443\u043b IP \u0430\u0434\u0440\u0435\u0441\u043e\u0432 \u0438\u0441\u0447\u0435\u0440\u043f\u0430\u043d \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043d\u0430 " + alarmPercent + " \u043f\u0440\u043e\u0446\u0435\u043d\u0442\u043e\u0432", message), (long)time);
                        }
                    }
                }
                WeakReference<DialUpSessionRealtime> sessionRef = new WeakReference<DialUpSessionRealtime>(session);
                while (!((address = addrSet.next(offset = this.random.nextInt(addrSet.size()), new Set[]{usedAddressSet.keySet(), staticAddressSet})) != null && usedAddressSet.tryOffer(address, sessionRef) || address == null)) {
                }
                if (address != null) {
                    result = address.intValue();
                } else {
                    String key = "radius.dialup.address.pool.empty";
                    long time = System.currentTimeMillis();
                    if (AlarmSender.needAlarmSend((String)key, (long)time, (long)30000L)) {
                        String message = "\u0418\u0441\u0447\u0435\u0440\u043f\u0430\u043d \u043f\u0443\u043b IP \u0430\u0434\u0440\u0435\u0441\u043e\u0432 " + poolName + " \u043d\u0430 NAS " + this.getNasIdentifier() + ".\n\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u0432\u0435\u043b\u0438\u0447\u0438\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 \u043f\u0443\u043b\u0430 \u0438 \u043f\u0435\u0440\u0435\u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440\u0430 \u043c\u043e\u0434\u0443\u043b\u044f DialUp \u043b\u0438\u0431\u043e NAS\u0430.";
                        AlarmSender.sendAlarm((AlarmErrorMessage)new AlarmErrorMessage(key, "\u0418\u0441\u0447\u0435\u0440\u043f\u0430\u043d \u043f\u0443\u043b IP \u0430\u0434\u0440\u0435\u0441\u043e\u0432", message), (long)time);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropConnection(String nasPort) {
        DialUpNasConnection nasCon = (DialUpNasConnection)((Object)this.connections.remove(nasPort));
        if (nasCon != null) {
            DialUpSessionRealtime session = (DialUpSessionRealtime)nasCon.getSession();
            session.addLogInfo("Dropping connection");
            Connection con = ((Setup)this.setup).getDBConnectionFromPool();
            Connection conSlave = ((Setup)this.setup).getDBSlaveConnectionFromPool(con);
            try {
                nasCon.stopConnection(this, null, con, conSlave);
            }
            finally {
                ServerUtils.closeConnection((Connection)con, (Connection)conSlave);
            }
            if (!session.isFakeSession()) {
                this.trafficInspector.stopSession(session);
            }
            DialUpRadiusProcessor.usedAddressSet.remove(session.getIpAddress(), session);
        }
    }

    public DialUpNasConnection setConnection(DialUpNasConnection nasCon, RadiusPacket request, Connection con, Connection conSlave) {
        if (nasCon != null && request != null) {
            DialUpSessionRealtime session = (DialUpSessionRealtime)nasCon.getSession();
            session.setCloseCalculatePeriod(this.closeCalculatePeriod);
            RadiusAttribute.RadiusAttributeInteger nasPortAttribute = (RadiusAttribute.RadiusAttributeInteger)request.getAttribute(-1, 5);
            if (nasPortAttribute != null) {
                String nasPort = String.valueOf(Utils.unsignedIntToLong((int)((Integer)nasPortAttribute.getValue())));
                DialUpNasConnection oldConnection = (DialUpNasConnection)((Object)this.connections.remove(nasPort));
                if (oldConnection != null) {
                    DialUpSessionRealtime oldSession = (DialUpSessionRealtime)oldConnection.getSession();
                    oldConnection.stopConnection(this, null, con, conSlave);
                    if (!oldSession.isFakeSession()) {
                        this.trafficInspector.stopSession(oldSession);
                    }
                    DialUpRadiusProcessor.usedAddressSet.remove(oldSession.getIpAddress(), oldSession);
                }
                session.setNasId(this.getId());
                session.setNasPort(nasPort);
                this.connections.put(nasPort, nasCon);
                return nasCon;
            }
        }
        return null;
    }

    private void tryChangePort(RadiusPacket request, String nasPort) {
        String userName = request.getStringAttribute(-1, 1, null);
        Iterator iter = this.connections.entrySet().iterator();
        while (iter.hasNext()) {
            DialUpSessionRealtime session;
            Map.Entry e = iter.next();
            DialUpNasConnection nasCon = (DialUpNasConnection)((Object)e.getValue());
            if (nasCon.getStatus() != NasConnection.Status.waiting || !(session = (DialUpSessionRealtime)nasCon.getSession()).getLoginName().equals(userName) || session.getNasPort().equals(nasPort)) continue;
            iter.remove();
            session.setNasPort(nasPort);
            this.connections.put(nasPort, nasCon);
            break;
        }
    }

    public DialUpNasConnection startConnection(RadiusListenerWorker<?> req, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, Date time) {
        RadiusAttribute.RadiusAttributeInteger nasPortAttribute;
        if (request != null && (nasPortAttribute = (RadiusAttribute.RadiusAttributeInteger)request.getAttribute(-1, 5)) != null) {
            DialUpNasConnection nasCon;
            String nasPort = String.valueOf(Utils.unsignedIntToLong((int)((Integer)nasPortAttribute.getValue())));
            if (this.supportCallback) {
                this.tryChangePort(request, nasPort);
            }
            if ((nasCon = (DialUpNasConnection)((Object)this.connections.get(nasPort))) != null) {
                nasCon.startConnection(this, request, connectionSet.getConnection(), connectionSet.getSlaveConnection());
                DialUpSessionRealtime session = (DialUpSessionRealtime)nasCon.getSession();
                if (!session.isFakeSession()) {
                    this.trafficInspector.startSession(session, true);
                }
            }
            return nasCon;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DialUpNasConnection updateConnection(RadiusListenerWorker<?> req, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        RadiusAttribute.RadiusAttributeInteger nasPortAttribute;
        if (request != null && (nasPortAttribute = (RadiusAttribute.RadiusAttributeInteger)request.getAttribute(-1, 5)) != null) {
            String nasPort = String.valueOf(Utils.unsignedIntToLong((int)((Integer)nasPortAttribute.getValue())));
            DialUpNasConnection nasCon = (DialUpNasConnection)((Object)this.connections.get(nasPort));
            if (nasCon != null) {
                DialUpNasConnection dialUpNasConnection = nasCon;
                synchronized (dialUpNasConnection) {
                    DialUpSessionRealtime session = (DialUpSessionRealtime)nasCon.getSession();
                    if (!session.isFakeSession()) {
                        if (nasCon.getStatus() == NasConnection.Status.waiting) {
                            this.trafficInspector.startSession(session, true);
                        }
                        this.updateBytes(session, request);
                        session.updateRadiusTraffics(request);
                    }
                    nasCon.updateConnection(this, request, response, connectionSet.getConnection(), connectionSet.getSlaveConnection());
                    if (!session.isFakeSession() && this.logUpdate) {
                        RadiusUtils.addToLog((DefaultServerSetup)((DefaultServerSetup)this.setup), (int)this.moduleId, (RadiusPacket)request, (Date)session.getStartTime().getTime(), (int)session.getRequestLogRecordId());
                    }
                }
                return nasCon;
            }
            logger.warn("Not found connection for update packet: \n" + request.toString());
        }
        return null;
    }

    public DialUpNasConnection stopConnection(RadiusListenerWorker<?> req, final RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        RadiusAttribute.RadiusAttributeInteger nasPortAttribute;
        if (request != null && (nasPortAttribute = (RadiusAttribute.RadiusAttributeInteger)request.getAttribute(-1, 5)) != null) {
            String nasPort = String.valueOf(Utils.unsignedIntToLong((int)((Integer)nasPortAttribute.getValue())));
            final DialUpNasConnection nasCon = (DialUpNasConnection)((Object)this.connections.get(nasPort));
            if (nasCon != null) {
                DialUpSessionRealtime session = (DialUpSessionRealtime)nasCon.getSession();
                String acctSessionId = request.getStringAttribute(-1, 44, null);
                if (Utils.notBlankString((String)acctSessionId) && !acctSessionId.equals(session.getAcctSessionId())) {
                    session.addLogError("Stop with incorrect Acct-Session-Id!");
                    return null;
                }
                if (this.connections.remove(nasPort, (Object)nasCon)) {
                    if (!session.isFakeSession()) {
                        LC_LimitChecker.getLimitChecker().unregisterLogin(((DialUpSessionRealtime)nasCon.getSession()).getLogin().getId());
                    }
                    if (this.delayStop > 0) {
                        this.delayStopPool.schedule(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Connection con = ((Setup)DialUpNas.this.setup).getDBConnectionFromPool();
                                Connection conSlave = ((Setup)DialUpNas.this.setup).getDBSlaveConnectionFromPool(con);
                                try {
                                    DialUpNas.this.doSessionStop(request, nasCon, con, conSlave);
                                }
                                catch (Exception e) {
                                    logger.error(e.getMessage(), (Throwable)e);
                                }
                                finally {
                                    ServerUtils.closeConnection((Connection)con, (Connection)conSlave);
                                }
                            }
                        }, (long)this.delayStop, TimeUnit.SECONDS);
                    } else {
                        this.doSessionStop(request, nasCon, connectionSet.getConnection(), connectionSet.getSlaveConnection());
                    }
                }
            }
            return nasCon;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSessionStop(RadiusPacket request, DialUpNasConnection nasCon, Connection con, Connection conSlave) {
        DialUpNasConnection dialUpNasConnection = nasCon;
        synchronized (dialUpNasConnection) {
            DialUpSessionRealtime session = (DialUpSessionRealtime)nasCon.getSession();
            if (!session.isFakeSession()) {
                this.updateBytes(session, request);
                session.updateRadiusTraffics(request);
                this.trafficInspector.stopSession(session);
            }
            DialUpRadiusProcessor.usedAddressSet.removeWithTimeout(session.getIpAddress(), session);
            nasCon.stopConnection(this, request, con, conSlave);
        }
    }

    private void updateBytes(DialUpSessionRealtime session, RadiusPacket request) {
        session.addLogDebug("updateBytes");
        session.addLogDebug("before update bytesIn=" + session.getBytesIn() + "; bytesOut=" + session.getBytesOut());
        int h = request.getIntAttribute(-1, 53, Integer.valueOf(0));
        long l = Utils.unsignedIntToLong((int)request.getIntAttribute(-1, 43, Integer.valueOf(0)));
        session.setBytesIn(((long)h << 32) + l);
        h = request.getIntAttribute(-1, 52, Integer.valueOf(0));
        l = Utils.unsignedIntToLong((int)request.getIntAttribute(-1, 42, Integer.valueOf(0)));
        session.setBytesOut(((long)h << 32) + l);
        session.addLogDebug("DialUpNASConnection after update bytesIn=" + session.getBytesIn() + "; bytesOut=" + session.getBytesOut());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Callable<Void> restoreConnections(final RadiusSetup setup, final NasList<? extends NasConnection<?>, ? extends Nas<? extends NasConnection<?>, ?, ?>> nasList, final AtomicInteger counter) {
        int count;
        block12: {
            int mid = setup.getModuleId();
            Connection con = null;
            PreparedStatement ps = null;
            count = 0;
            try {
                con = setup.getDBConnectionFromPool();
                String table_name = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)new Date(), (int)mid);
                if (!ServerUtils.tableExists((Connection)con, (String)table_name)) break block12;
                Object object = fakeColumnCheckMutex;
                synchronized (object) {
                    if (!ServerUtils.columnExist((Connection)con, (String)table_name, (String)"fake")) {
                        try {
                            con.prepareStatement("ALTER TABLE " + table_name + " ADD COLUMN fake TINYINT NOT NULL").executeUpdate();
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                ps = con.prepareStatement("SELECT COUNT(*) FROM " + table_name + " WHERE nas_id=? AND status=0 ORDER BY session_start");
                ps.setInt(1, this.getId());
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    count = rs.getInt(1);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                ServerUtils.closeConnection((Connection)con);
            }
        }
        counter.set(count);
        return new Callable<Void>(){

            @Override
            public Void call() {
                DialUpNas.this.restoreConnectionsImpl(setup, nasList, counter);
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreConnectionsImpl(RadiusSetup setup, NasList<? extends NasConnection<?>, ? extends Nas<? extends NasConnection<?>, ?, ?>> nasList, AtomicInteger counter) {
        String nasId = this.getNasIdentifier();
        loggerConnections.info("Restore Connections NAS: " + nasId);
        if (!this.restoreConnections) {
            loggerConnections.info(nasId + " Skipping restore..");
            return;
        }
        int mid = setup.getModuleId();
        String query = null;
        Connection con = null;
        Connection conSlave = null;
        PreparedStatement ps = null;
        try {
            block32: {
                try (ContractManager contractManager = new ContractManager(con);
                     ContractTariffOptionDao contractTariffOptionDao = new ContractTariffOptionDao(con);){
                    con = setup.getDBConnectionFromPool();
                    conSlave = setup.getDBSlaveConnectionFromPool(con);
                    String table_name = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)new Date(), (int)mid);
                    DialUpLoginManager dialUpLoginManager = new DialUpLoginManager(con, mid);
                    ContractStatusManager contractStatusManager = new ContractStatusManager(con);
                    if (!ServerUtils.tableExists((Connection)con, (String)table_name.toString())) break block32;
                    query = "SELECT start, end FROM calculate_period_" + mid + " WHERE cid=? AND start<=? AND ?<=end";
                    PreparedStatement psSelectPeriod = con.prepareStatement(query);
                    query = "SELECT * FROM " + table_name.toString() + " WHERE nas_id=? AND status=0 ORDER BY session_start";
                    ps = con.prepareStatement(query);
                    ps.setInt(1, this.getId());
                    ResultSet rs = ps.executeQuery();
                    while (rs.next()) {
                        try {
                            int loginID = rs.getInt("lid");
                            int logRecordID = rs.getInt("id");
                            int requestLogRecordID = rs.getInt("lr");
                            String nasPort = rs.getString("nas_port");
                            String sessionId = rs.getString("session_id");
                            Calendar sessionStart = TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp("session_start"));
                            Calendar calculatedStop = TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp("session_stop"));
                            String fromNumber = rs.getString("from_number");
                            String toNumber = rs.getString("to_number");
                            long bytesIn = rs.getLong("input_octets");
                            long bytesOut = rs.getLong("output_octets");
                            long ipAddr = rs.getLong("ipaddr");
                            String loginName = rs.getString("login_name");
                            String realm = "default";
                            int pos = loginName.indexOf("@");
                            if (pos > 0) {
                                realm = loginName.substring(pos + 1);
                            }
                            int serviceTime = rs.getInt("sid_time");
                            boolean isFake = rs.getBoolean("fake");
                            DialUpSessionRealtime session = new DialUpSessionRealtime(isFake, this.secondCalculatePeriod);
                            session.setMid(mid);
                            session.setNasId(this.getId());
                            if (!isFake) {
                                DialUpLogin login = (DialUpLogin)dialUpLoginManager.getLoginById(loginID);
                                login.setAttributeSets(dialUpLoginManager.loadAttrSet(login.getId(), realm));
                                login.setAvpPairs(dialUpLoginManager.loadAVPPairs(login));
                                session.setLogin(login);
                                session.setLogRecordId(logRecordID);
                                session.setRequestLogRecordId(requestLogRecordID);
                                session.setServiceTime(serviceTime);
                            }
                            session.setNasPort(nasPort);
                            session.setAcctSessionId(sessionId);
                            session.setStartTime(sessionStart);
                            session.setCalculatedStopTime(calculatedStop);
                            session.setStopTime(calculatedStop);
                            session.setBytesIn(bytesIn);
                            session.setBytesOut(bytesOut);
                            session.checkAndCreateTables(con, (DefaultServerSetup)setup);
                            if (!isFake) {
                                List<Traffic> trafficConfig = this.getTrafficConfig(realm, String.valueOf(nasPort));
                                if (trafficConfig == null) {
                                    loggerConnections.error(nasId + " session restore not found traffic config: realm => " + realm + "; port => " + nasPort);
                                    continue;
                                }
                                session.setTrafficConfig(trafficConfig);
                                session.restoreTraffics(con);
                            }
                            session.setFromNumber(fromNumber);
                            session.setToNumber(toNumber);
                            session.setIpAddress(ipAddr);
                            session.setLoginName(loginName);
                            if (!isFake) {
                                int contractId = session.getLogin().getCid();
                                psSelectPeriod.setInt(1, contractId);
                                psSelectPeriod.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)session.getCalculatedStopTime()));
                                psSelectPeriod.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)session.getCalculatedStopTime()));
                                ResultSet rsPeriod = psSelectPeriod.executeQuery();
                                if (rsPeriod.next()) {
                                    if (this.secondCalculatePeriod) {
                                        session.setCalculatePeriod(TimeUtils.convertTimestampToCalendar((Timestamp)rsPeriod.getTimestamp(1)), TimeUtils.convertTimestampToCalendar((Timestamp)rsPeriod.getTimestamp(2)));
                                    } else {
                                        session.setCalculatePeriod(TimeUtils.convertDateToCalendar((Date)rsPeriod.getDate(1)), TimeUtils.convertDateToCalendar((Date)rsPeriod.getDate(2)));
                                    }
                                } else {
                                    session.setMonthAsCalculatePeriod(session.getCalculatedStopTime());
                                }
                                rsPeriod.close();
                                Contract contract = contractManager.getContractById(contractId);
                                contract.setTts(contractManager.getRealtimeTariffTreeSet(contractId, session.getCalculatePeriodStart(), "dialup", mid, true));
                                contract.setTariffOptions(contractTariffOptionDao.getContractRealtimeTariffOptionList(contractId, session.getCalculatePeriodStart().getTime()));
                                session.setContract(contract);
                                session.resetAndInitTreeSet(contractStatusManager, session.getStartTime(), con);
                                session.checkPrices(session.getCalculatedStopTime(), new HashSet<Integer>(), new HashSet<Integer>(), new ArrayList<String>(1));
                                session.restoreIpNets(con);
                            }
                            DialUpNasConnection nasCon = new DialUpNasConnection(session, (DefaultServerSetup)setup, nasList, this.getId());
                            DialUpNasConnection oldCon = (DialUpNasConnection)((Object)this.connections.get(nasPort));
                            if (oldCon != null) {
                                DialUpSessionRealtime oldSession = (DialUpSessionRealtime)oldCon.getSession();
                                oldCon.stopConnection(this, null, con, conSlave);
                                if (!oldSession.isFakeSession()) {
                                    this.trafficInspector.stopSession(oldSession);
                                }
                                DialUpRadiusProcessor.usedAddressSet.remove(oldSession.getIpAddress(), oldSession);
                            }
                            nasCon.startConnection(this, null, con, conSlave);
                            this.connections.put(nasPort, nasCon);
                            if (!session.isFakeSession()) {
                                this.trafficInspector.startSession(session, false);
                            }
                            DialUpRadiusProcessor.usedAddressSet.add(session.getIpAddress(), session);
                            if (!isFake) {
                                LC_LimitChecker.getLimitChecker().registerLogin(((DialUpSessionRealtime)nasCon.getSession()).getLogin(), con);
                            }
                            loggerConnections.info(nasId + " Session restored for login: " + session.getLoginName() + "; contract:  " + session.getContract().getTitle() + "; ipaddr: " + IPUtils.convertLongIpToString((long)session.getIpAddress()) + "; count: " + restoredCount.incrementAndGet());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        counter.decrementAndGet();
                    }
                    ps.close();
                    psSelectPeriod.close();
                }
            }
            ServerUtils.closeConnection((Connection)con, (Connection)conSlave);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con, conSlave);
        }
    }

    public int getWorkMode() {
        return this.workMode;
    }

    public Map<Integer, String> getRejectToAcceptErrorAtributes() {
        return this.rejectToAcceptErrorAtributes;
    }

    public void destroy() {
        super.destroy();
        for (StopableThread thread : this.threads) {
            thread.shutdown();
        }
    }

    public boolean isSecondCalculatePeriod() {
        return this.secondCalculatePeriod;
    }
}

