/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.client;

import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Calendar;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class CalculatePeriodPanel
extends ServicePanel {
    private int currentID = 0;
    private JPanel editorPanel = new JPanel();
    private BGTable table = new BGTable();
    private JButton buttonCancel = new JButton();
    private JButton buttonOk = new JButton();
    private BGControlPanelDateNoB start = new BGControlPanelDateNoB();
    private BGControlPanelDateNoB end = new BGControlPanelDateNoB();

    public CalculatePeriodPanel() {
        this.jbInit();
        this.table.setHeader(this.rb_name, this.moduleDoc, "calculate_period");
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        JScrollPane tableScroll = new JScrollPane();
        tableScroll.setViewportView((Component)this.table);
        this.add(tableScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        ActionListener okCanselAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculatePeriodPanel.this.stopEdit(e.getActionCommand().equals("ok"));
            }
        };
        this.buttonOk.setActionCommand("ok");
        this.buttonOk.setSelected(true);
        this.buttonOk.setText("Ok");
        this.buttonOk.addActionListener(okCanselAction);
        this.buttonCancel.setActionCommand("cancel");
        this.buttonCancel.setText("\u041e\u0442\u043c\u0435\u043d\u0430");
        this.buttonCancel.addActionListener(okCanselAction);
        this.editorPanel.setLayout(new GridBagLayout());
        this.editorPanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 "));
        this.editorPanel.add((Component)new JLabel("\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.editorPanel.add((Component)this.start, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.editorPanel.add((Component)new JLabel("\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.editorPanel.add((Component)this.end, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.editorPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.editorPanel.add((Component)this.buttonOk, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.editorPanel.add(Box.createHorizontalStrut(8), new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.editorPanel.add((Component)this.buttonCancel, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add(this.editorPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CalculatePeriodPanel.this.editItem();
                }
            }
        });
        this.editorPanel.setVisible(false);
        this.editorPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                CalculatePeriodPanel.this.setData();
            }
        });
    }

    public void setData() {
        Request req = new Request();
        req.setModule(this.module);
        req.setModuleId(this.getModuleId());
        req.setAction("Period");
        req.setContractId(this.getContractId());
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.table.updateData((Node)XMLUtils.getElement((Document)doc, (String)"table"));
        }
    }

    private void stopEdit(boolean save) {
        if (save) {
            if (this.start.getDateCalendar() == null || this.end.getDateCalendar() == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043e\u0431\u0435 \u0434\u0430\u0442\u044b!");
                return;
            }
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAction("PeriodUpdate");
            request.setContractId(this.getContractId());
            request.setAttribute("id", this.currentID);
            request.setAttribute("start", TimeUtils.formatDate((Calendar)this.start.getDateCalendar()));
            request.setAttribute("end", TimeUtils.formatDate((Calendar)this.end.getDateCalendar()));
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                this.editorPanel.setVisible(false);
            }
        } else {
            this.editorPanel.setVisible(false);
        }
    }

    public void deleteItem() {
        String id = ClientUtils.getRowId((BGTable)this.table);
        if (id != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0435\u0440\u0438\u043e\u0434?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setContractId(this.getContractId());
            request.setAction("PeriodDelete");
            request.setAttribute("id", id);
            this.stopEdit(false);
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                this.setData();
            }
        }
    }

    public void editItem() {
        this.currentID = Utils.parseInt((String)ClientUtils.getRowId((BGTable)this.table), (int)-1);
        if (this.currentID > 0) {
            this.startEdit();
        }
    }

    public void newItem() {
        this.currentID = 0;
        this.startEdit();
    }

    private void startEdit() {
        if (this.currentID > 0) {
            Request req = new Request();
            req.setModule(this.module);
            req.setModuleId(this.getModuleId());
            req.setContractId(this.getContractId());
            req.setAction("Period");
            req.setAttribute("id", this.currentID);
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc)) {
                Element periodEl = XMLUtils.getElement((Document)doc, (String)"period");
                this.start.setDateCalendar(TimeUtils.convertStringToCalendar((String)periodEl.getAttribute("start")));
                this.end.setDateCalendar(TimeUtils.convertStringToCalendar((String)periodEl.getAttribute("end")));
            }
        } else {
            this.start.setDateCalendar(null);
            this.end.setDateCalendar(null);
        }
        this.editorPanel.setVisible(true);
    }
}

