/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.sender.enterix;

import java.util.List;
import javax.activation.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.network.sms.enterix.Message;
import ru.bitel.bgbilling.kernel.network.sms.enterix.impl.SmscApiV1;
import ru.bitel.bgbilling.kernel.network.sms.enterix.impl.SmscApiV1ImplService;
import ru.bitel.bgbilling.kernel.network.sms.enterix.impl.SoapAuthException;
import ru.bitel.bgbilling.kernel.network.sms.enterix.impl.SoapBalanceException;
import ru.bitel.bgbilling.kernel.network.sms.enterix.impl.SoapInternalException;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.server.sender.Sender;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class EnterixSmsSender
implements Sender {
    private static final Logger logger = LogManager.getLogger();
    private Preferences pluginPreferences = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.dispatch").getSetup();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void send(Contact contact, String title, String messageBody, List<DataSource> messageFiles) throws BGException {
        if (contact != null) {
            SmscApiV1 sms = new SmscApiV1ImplService().getSmscApiV1ImplPort();
            try {
                String login = this.pluginPreferences.get("sender.sms.enterix.login");
                String password = this.pluginPreferences.get("sender.sms.enterix.password");
                String sign = this.pluginPreferences.get("sender.sms.enterix.sign");
                String authToken = sms.getAuthToken(login, password);
                if (!Utils.notBlankString((String)authToken)) return;
                Message msg = new Message();
                msg.setDestAddr(contact.getValueForSend());
                msg.setSourceAddr(sign);
                msg.setUtfMessage(messageBody);
                String result = sms.sendMsg(authToken, msg);
                if (!logger.isDebugEnabled()) return;
                logger.debug("\t\t\tSms-\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043f\u043e \u043d\u043e\u043c\u0435\u0440\u0443 " + contact.getValueForSend() + " \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e. \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + result);
                return;
            }
            catch (SoapAuthException e) {
                String message = "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 - \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u043b\u043e\u0433\u0438\u043d \u0438(\u0438\u043b\u0438) \u043f\u0430\u0440\u043e\u043b\u044c";
                logger.error(message);
                throw new BGException(message, (Throwable)e);
            }
            catch (SoapInternalException e1) {
                throw new BGException();
            }
            catch (SoapBalanceException e) {
                String message = "\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043d\u0430 \u0441\u0447\u0435\u0442\u0443!";
                logger.error(message);
                throw new BGException(message, (Throwable)e);
            }
        } else {
            logger.warn("\t\t\t\u0412 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043a\u043e\u043d\u0442\u0430\u043a\u0442! \u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0441\u043c\u0441-\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435");
        }
    }
}

