/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.fias.server.action.pub;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.module.common.extension.fias.FiasConfigUtil;
import ru.bitel.bgbilling.kernel.module.common.extension.fias.LocationFinder;
import ru.bitel.bgbilling.plugins.fias.server.action.pub.ActionGetAbonentBase;
import ru.bitel.common.XMLUtils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;

public class ActionGetAbonentInfo
extends ActionGetAbonentBase {
    @Override
    protected Document BuildResponseXML(String numberForAnswer, LocationFinder.AddressData addressData) throws BGException {
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            dFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootNode = doc.createElement("response");
            doc.appendChild(rootNode);
            rootNode.setAttribute("xsi:noNamespaceSchemaLocation", "pull_response.xsd");
            rootNode.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLScgema-instance");
            rootNode.setAttribute("xmlns:ai", "http://www.svetets.ru/AbonentInfo");
            Element resultCode = XMLUtils.createElement((Element)rootNode, (String)"resultCode");
            Element resultDescription = XMLUtils.createElement((Element)rootNode, (String)"resultDescription");
            if (addressData == null || addressData.getCid() <= 0) {
                resultCode.setTextContent("4");
                resultDescription.setTextContent("UNKNOWN SUBSCRIBER");
                return doc;
            }
            resultCode.setTextContent("0");
            Element aiAbonentInfo = XMLUtils.createElement((Element)rootNode, (String)"ai:AbonentInfo");
            ContractDao contractDao = new ContractDao(this.con, this.userId.intValue());
            this.cid = addressData.getCid();
            Contract contract = (Contract)contractDao.get(this.cid);
            if (contract == null) {
                log.error("ERROR Contract find" + addressData);
                resultDescription.setTextContent(addressData.toString());
                contractDao.recycle();
                return doc;
            }
            if (contract.getPersonType() == 0) {
                Element aiPerson = XMLUtils.createElement((Element)aiAbonentInfo, (String)"ai:person");
                EntityAttr name = contractDao.getContractParameter(this.cid, FiasConfigUtil.getNamePid((boolean)true));
                Element aiName = XMLUtils.createElement((Element)aiPerson, (String)"ai:name");
                aiName.setTextContent(name.toString());
                Element aiSecondName = XMLUtils.createElement((Element)aiPerson, (String)"ai:secondName");
                EntityAttr secondName = contractDao.getContractParameter(this.cid, FiasConfigUtil.getSecondNamePid((boolean)true));
                aiSecondName.setTextContent(secondName.toString());
                Element aiLastName = XMLUtils.createElement((Element)aiPerson, (String)"ai:surname");
                EntityAttr lastName = contractDao.getContractParameter(this.cid, FiasConfigUtil.getLastNamePid((boolean)true));
                aiLastName.setTextContent(lastName.toString());
                Element aiAddress = XMLUtils.createElement((Element)aiPerson, (String)"ai:address");
                EntityAttr address = contractDao.getContractParameter(this.cid, FiasConfigUtil.getAddressPid((boolean)true));
                aiAddress.setTextContent(address.toString());
                Element aiBirthDate = XMLUtils.createElement((Element)aiPerson, (String)"ai:birthDate");
                EntityAttr bDate = contractDao.getContractParameter(this.cid, FiasConfigUtil.getDobAsTextPid());
                if (bDate == null) {
                    bDate = contractDao.getContractParameter(this.cid, FiasConfigUtil.getDobAsDatePid());
                }
                aiBirthDate.setTextContent(bDate.toString());
            } else {
                Element aiOrganization = XMLUtils.createElement((Element)aiAbonentInfo, (String)"ai:organization");
                EntityAttr name = contractDao.getContractParameter(this.cid, FiasConfigUtil.getNamePid((boolean)false));
                Element aiName = XMLUtils.createElement((Element)aiOrganization, (String)"ai:name");
                aiName.setTextContent(name.toString());
                Element aiAddress = XMLUtils.createElement((Element)aiOrganization, (String)"ai:address");
                EntityAttr address = contractDao.getContractParameter(this.cid, FiasConfigUtil.getAddressPid((boolean)true));
                aiAddress.setTextContent(address.toString());
            }
            contractDao.recycle();
            return doc;
        }
        catch (Exception ex) {
            throw new BGException(ex.getLocalizedMessage(), (Throwable)ex);
        }
    }
}

