/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.action;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Topic;
import ru.bitel.bgbilling.plugins.helpdesk.server.action.ActionBase;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.filestorage.HelpdeskFileStorage;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;

public class ActionGetMessage
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int id = this.getIntParameter("id", -1);
        int topicId = this.getIntParameter("topicId", -1);
        if (id < 0) {
            throw new BGIllegalArgumentException();
        }
        TopicManager topicManager = new TopicManager(this.con, this.plugin);
        Topic topic = topicManager.getTopic(topicId, false);
        Message message = topicManager.getMessage(id);
        if (topic != null && message != null && topic.getId() == message.getTopicId()) {
            Element messageEl = this.createElement(this.rootNode, "message");
            messageEl.setAttribute("id", String.valueOf(message.getId()));
            messageEl.setAttribute("topicId", String.valueOf(message.getTopicId()));
            messageEl.setAttribute("dateFrom", TimeUtils.format((Date)message.getDateFrom(), (String)"dd.MM.yyyy HH:mm:ss"));
            messageEl.setAttribute("dateTo", TimeUtils.format((Date)message.getDateTo(), (String)"dd.MM.yyyy HH:mm:ss"));
            messageEl.setAttribute("userName", UserMap.getUser((Integer)this.userId).getName());
            messageEl.setAttribute("userFrom", message.getUserNameFrom());
            messageEl.setAttribute("userTo", message.getUserNameTo());
            messageEl.setAttribute("userIdTopic", String.valueOf(topic.getUserId()));
            messageEl.setAttribute("userIdFrom", String.valueOf(message.getUserIdFrom()));
            messageEl.setAttribute("userIdTo", String.valueOf(message.getUserIdTo()));
            messageEl.setAttribute("userId", this.userId.toString());
            messageEl.setAttribute("comment", message.getComment());
            Element bodyEl = this.createElement(messageEl, "body");
            this.stringToLines(bodyEl, message.getBody());
            ServerUtils.prepareElementToSerialize((Node)bodyEl);
            Element filestable = this.createElement(this.rootNode, "files");
            Element data = this.createElement(filestable, "data");
            HelpdeskFileStorage fileStorage = new HelpdeskFileStorage(this.con);
            List messageFileList = fileStorage.getFilesListByOwner(message.getId());
            for (BGServerFile messageFile : messageFileList) {
                Element rowfile = this.createElement(data, "row");
                rowfile.setAttribute("id", String.valueOf(messageFile.getId()));
                rowfile.setAttribute("title", messageFile.getTitle());
                rowfile.setAttribute("size", String.valueOf(messageFile.getSize()));
            }
        }
    }
}

