/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.task;

import bitel.billing.server.util.MailMsg;
import java.sql.Connection;
import java.util.Map;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.util.JabberSender;

public class NewMessagesPersonalTask
extends TaskBase {
    private BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk");
    private String TMPLT_BODY_PART = "{title} (ID {id}) - {count} \u043d\u043e\u0432\u044b\u0445\n";
    private String TMPLT_BODY = "\u0412\u0430\u0448\u0438 \u0442\u0435\u043c\u044b ({youCountAll} \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439):\n{youNews}\n\u041d\u0438\u0447\u0435\u0439\u043d\u044b\u0435 ({unmanagedCountAll} \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439):\n{unmanagedNews}";
    private String TMPLT_SUBJECT = "HelpDesk => {youCountAll} \u043d\u043e\u0432\u044b\u0445 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 (\u0438 {unmanagedCountAll} \u043d\u043e\u0432\u044b\u0445 \u043d\u0438\u0447\u0435\u0439\u043d\u044b\u0445)";

    public String getDescription() {
        return this.defaultDescription + "\u041f\u043b\u0430\u0433\u0438\u043d HelpDesk. \u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0439 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u043d\u043e\u0432\u044b\u0445 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f\u0445.";
    }

    protected boolean initTask() {
        this.TMPLT_BODY_PART = this.taskSetup.get("mail.bodypart", this.TMPLT_BODY_PART).replaceAll("\\\\n", "\n");
        this.TMPLT_BODY = this.taskSetup.get("mail.body", this.TMPLT_BODY).replaceAll("\\\\n", "\n");
        this.TMPLT_SUBJECT = this.taskSetup.get("mail.subject", this.TMPLT_SUBJECT).replaceAll("\\\\n", "\n");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        JabberSender jabberSender = null;
        try {
            TopicManager topicManager = new TopicManager(con, this.plugin);
            UserManager userManager = new UserManager(con);
            String sjJid = this.setup.get("jabber.jid", null);
            String sjPas = this.setup.get("jabber.password", null);
            String sjSrv = this.setup.get("jabber.server", null);
            if (sjJid != null && sjPas != null) {
                jabberSender = new JabberSender(sjJid, sjPas, sjSrv);
                jabberSender.connect();
            }
            MailMsg mailSender = new MailMsg((Preferences)this.setup);
            Map<Integer, Map<IdTitle, Integer>> clientNewMessagesMap = topicManager.getClientNewMessagesMap();
            Map<IdTitle, Integer> unmanagedUserTopics = clientNewMessagesMap.get(-1);
            StringBuilder unmanagedBodyParts = new StringBuilder();
            int unmanagedNewsCount = 0;
            if (unmanagedUserTopics != null) {
                unmanagedNewsCount = this.formatUserTopics(unmanagedUserTopics, unmanagedBodyParts);
            }
            ParameterMap usersContact = this.taskSetup.sub("user.");
            for (Map.Entry entry : usersContact.entrySet()) {
                int index = ((String)entry.getKey()).indexOf(46);
                if (index <= -1) continue;
                String username = ((String)entry.getKey()).substring(0, index);
                String contacttype = ((String)entry.getKey()).substring(index + 1);
                User user = userManager.getUserByLogin(username);
                if (user != null) {
                    Map<IdTitle, Integer> youUserTopics = clientNewMessagesMap.get(user.getId());
                    StringBuilder youBodyParts = new StringBuilder();
                    int youNewsCount = 0;
                    if (youUserTopics != null) {
                        youNewsCount = this.formatUserTopics(youUserTopics, youBodyParts);
                    }
                    if (youNewsCount <= 0 && unmanagedNewsCount <= 0) continue;
                    String subject = this.TMPLT_SUBJECT.replaceAll("\\{youCountAll\\}", String.valueOf(youNewsCount));
                    subject = subject.replaceAll("\\{unmanagedCountAll\\}", String.valueOf(unmanagedNewsCount));
                    String body = this.TMPLT_BODY.replaceAll("\\{youNews\\}", youBodyParts.toString());
                    body = body.replaceAll("\\{unmanagedNews\\}", unmanagedBodyParts.toString());
                    body = body.replaceAll("\\{youCountAll\\}", String.valueOf(youNewsCount));
                    body = body.replaceAll("\\{unmanagedCountAll\\}", String.valueOf(unmanagedNewsCount));
                    body = body.replaceAll("\\\\n", "\n");
                    if ("mail".equals(contacttype)) {
                        this.log.debug("send mail " + (String)entry.getValue());
                        mailSender.sendMessage((String)entry.getValue(), subject, body);
                        continue;
                    }
                    if (!"jid".equals(contacttype) || jabberSender == null) continue;
                    this.log.debug("send jabber " + (String)entry.getValue());
                    jabberSender.send((String)entry.getValue(), subject, body);
                    continue;
                }
                this.log.warn("strange config: user '" + username + "' not found");
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (jabberSender != null) {
                jabberSender.disconnect();
            }
            ServerUtils.closeConnection((Connection)con);
        }
    }

    private int formatUserTopics(Map<IdTitle, Integer> userTopics, StringBuilder sb) {
        int countTotal = 0;
        for (Map.Entry<IdTitle, Integer> e : userTopics.entrySet()) {
            countTotal += e.getValue().intValue();
            String result = this.TMPLT_BODY_PART.replaceAll("\\{id\\}", String.valueOf(e.getKey().getId()));
            result = result.replaceAll("\\{title\\}", String.valueOf(e.getKey().getTitle()));
            result = result.replaceAll("\\{count\\}", String.valueOf(e.getValue()));
            sb.append(result);
        }
        return countTotal;
    }
}

