/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.common.event.sa;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.PartitionedQueueEvent;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaServModifyEvent;

@EventType(autoAcknowledge=false, timeToLive=432000000L)
@XmlRootElement
public class InetSaServInitEvent
extends PartitionedQueueEvent {
    @XmlAttribute
    private final int deviceId;
    @XmlAttribute
    private final int inetServId;

    protected InetSaServInitEvent() {
        this.deviceId = -1;
        this.inetServId = -1;
    }

    public InetSaServInitEvent(int moduleId, int userId, int deviceId, int inetServId) {
        super(moduleId, CONTRACT_GLOBAL, userId);
        this.deviceId = deviceId;
        this.inetServId = inetServId;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("deviceId", this.deviceId);
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public int getInetServId() {
        return this.inetServId;
    }

    protected void toString(StringBuilder sb) {
        sb.append("; deviceId: ");
        sb.append(this.deviceId);
        sb.append("; inetServId: ");
        sb.append(this.inetServId);
    }

    protected String getPackageName() {
        return InetSaServModifyEvent.PACKAGE_NAME;
    }

    protected int getPartitionValue() {
        return this.deviceId;
    }
}

